/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.jna;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.gemstone.gemfire.internal.shared.NativeErrorException;
import com.gemstone.gemfire.internal.shared.TCPSocketOptions;
import com.gemstone.gemfire.internal.shared.jna.OSType;
import com.sun.jna.Callback;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class POSIXNativeCalls
extends NativeCalls {
    private static final int EPERM = 1;
    private static final int ENOMEM = 12;
    private static final int ENOSPC = 28;
    private static final int SIGHUP = 1;
    private static final int SIGINT = 2;
    private static final int SIGCHLD = 20;
    private static final int SIGTSTP = 18;
    private static final int SIGTTOU = 21;
    private static final int SIGTTIN = 22;
    private static final int MCL_CURRENT = 1;
    private static final int MCL_FUTURE = 2;
    private static final Map<String, String> javaEnv;
    private SignalHandler hupHandler;
    protected final RLimit rlimit = new RLimit();
    private NativeCalls.RehashServerOnSIGHUP rehashCallback;

    POSIXNativeCalls() {
    }

    public static native int setenv(String var0, String var1, int var2) throws LastErrorException;

    public static native int unsetenv(String var0) throws LastErrorException;

    public static native String getenv(String var0);

    public static native int chdir(String var0) throws LastErrorException;

    public static native int getpid();

    public static native int kill(int var0, int var1) throws LastErrorException;

    public static native int setsid() throws LastErrorException;

    public static native int umask(int var0);

    public static native int signal(int var0, SignalHandler var1);

    public static native int setsockopt(int var0, int var1, int var2, IntByReference var3, int var4) throws LastErrorException;

    public static native int close(int var0) throws LastErrorException;

    public static native int isatty(int var0);

    public static native int getrlimit(int var0, RLimit var1) throws LastErrorException;

    public static native int mlockall(int var0);

    @Override
    public OSType getOSType() {
        return OSType.GENERIC_POSIX;
    }

    @Override
    public synchronized void setEnvironment(String name, String value) {
        if (name == null) {
            throw new UnsupportedOperationException("setEnvironment() for name=NULL");
        }
        int res = -1;
        NativeErrorException cause = null;
        try {
            res = value != null ? POSIXNativeCalls.setenv(name, value, 1) : POSIXNativeCalls.unsetenv(name);
        }
        catch (LastErrorException le) {
            cause = new NativeErrorException(le.getMessage(), le.getErrorCode(), le.getCause());
        }
        if (res != 0) {
            throw new IllegalArgumentException("setEnvironment: given name=" + name + " (value=" + value + ')', cause);
        }
        if (javaEnv != null) {
            if (value != null) {
                javaEnv.put(name, value);
            } else {
                javaEnv.remove(name);
            }
        }
    }

    @Override
    public void setCurrentWorkingDirectory(String path) throws LastErrorException {
        System.setProperty("user.dir", path);
        POSIXNativeCalls.chdir(path);
    }

    @Override
    public synchronized String getEnvironment(String name) {
        if (name == null) {
            throw new UnsupportedOperationException("getEnvironment() for name=NULL");
        }
        return POSIXNativeCalls.getenv(name);
    }

    @Override
    public int getProcessId() {
        return POSIXNativeCalls.getpid();
    }

    @Override
    public boolean isProcessActive(int processId) {
        try {
            return super.isProcessActive(processId);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            try {
                return POSIXNativeCalls.kill(processId, 0) == 0;
            }
            catch (LastErrorException le) {
                return le.getErrorCode() == 1;
            }
        }
    }

    @Override
    public boolean killProcess(int processId) {
        try {
            return POSIXNativeCalls.kill(processId, 9) == 0;
        }
        catch (LastErrorException le) {
            return false;
        }
    }

    @Override
    public void daemonize(NativeCalls.RehashServerOnSIGHUP callback) throws UnsupportedOperationException {
        UnsupportedOperationException err;
        block4: {
            err = null;
            try {
                POSIXNativeCalls.setsid();
            }
            catch (LastErrorException le) {
                if (le.getErrorCode() == 1) break block4;
                err = new UnsupportedOperationException("Failed in setsid() in daemonize() due to " + le.getMessage() + " (errno=" + le.getErrorCode() + ')');
            }
        }
        int newMask = 18;
        int oldMask = POSIXNativeCalls.umask(18);
        if ((oldMask & 0x3F) > 18) {
            POSIXNativeCalls.umask(oldMask);
        }
        this.rehashCallback = callback;
        this.hupHandler = new SignalHandler(){

            @Override
            public void callback(int signum) {
                NativeCalls.RehashServerOnSIGHUP rehashCb = POSIXNativeCalls.this.rehashCallback;
                if (signum == 1 && rehashCb != null) {
                    rehashCb.rehash();
                }
            }
        };
        POSIXNativeCalls.signal(1, this.hupHandler);
        POSIXNativeCalls.signal(20, this.hupHandler);
        POSIXNativeCalls.signal(2, this.hupHandler);
        POSIXNativeCalls.signal(18, this.hupHandler);
        POSIXNativeCalls.signal(21, this.hupHandler);
        POSIXNativeCalls.signal(22, this.hupHandler);
        if (err != null) {
            throw err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preBlow(String path, long maxSize, boolean preAllocate) throws IOException {
        Logger logger = ClientSharedUtils.getLogger();
        if (logger != null && logger.isLoggable(Level.FINE)) {
            logger.fine("DEBUG preBlow called for path = " + path);
        }
        if (!preAllocate || !this.hasFallocate()) {
            super.preBlow(path, maxSize, preAllocate);
            if (logger != null && logger.isLoggable(Level.FINE)) {
                logger.fine("DEBUG preBlow super.preBlow 1 called for path = " + path);
            }
            return;
        }
        int fd = -1;
        boolean unknownError = false;
        try {
            fd = this.createFD(path, 420);
            if (!this.isOnLocalFileSystem(path)) {
                super.preBlow(path, maxSize, preAllocate);
                if (logger != null && logger.isLoggable(Level.FINE)) {
                    logger.fine("DEBUG preBlow super.preBlow 2 called as path = " + path + " not on local file system");
                }
                if (TEST_NO_FALLOC_DIRS != null) {
                    TEST_NO_FALLOC_DIRS.add(path);
                }
                return;
            }
            this.fallocateFD(fd, 0L, maxSize);
            if (TEST_CHK_FALLOC_DIRS != null) {
                TEST_CHK_FALLOC_DIRS.add(path);
            }
            if (logger != null && logger.isLoggable(Level.FINE)) {
                logger.fine("DEBUG preBlow posix_fallocate called for path = " + path + " and ret = 0 maxsize = " + maxSize);
            }
        }
        catch (LastErrorException le) {
            if (logger != null && logger.isLoggable(Level.FINE)) {
                logger.fine("DEBUG preBlow posix_fallocate called for path = " + path + " and ret = " + le.getErrorCode() + " maxsize = " + maxSize);
            }
            if (le.getErrorCode() == 28) {
                unknownError = false;
                throw new IOException("Not enough space left on device");
            }
            unknownError = true;
        }
        finally {
            if (fd >= 0) {
                try {
                    POSIXNativeCalls.close(fd);
                }
                catch (Exception exception) {}
            }
            if (unknownError) {
                super.preBlow(path, maxSize, preAllocate);
                if (logger != null && logger.isLoggable(Level.FINE)) {
                    logger.fine("DEBUG preBlow super.preBlow 3 called for path = " + path);
                }
            }
        }
    }

    protected boolean hasFallocate() {
        return false;
    }

    protected int createFD(String path, int flags) throws LastErrorException {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    protected void fallocateFD(int fd, long offset, long len) throws LastErrorException {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    @Override
    public Map<TCPSocketOptions, Throwable> setSocketOptions(Socket sock, InputStream sockStream, Map<TCPSocketOptions, Object> optValueMap) throws UnsupportedOperationException {
        return super.setGenericSocketOptions(sock, sockStream, optValueMap);
    }

    @Override
    protected int setPlatformSocketOption(int sockfd, int level, int optName, TCPSocketOptions opt, Integer optVal, int optSize) throws NativeErrorException {
        try {
            return POSIXNativeCalls.setsockopt(sockfd, level, optName, new IntByReference(optVal.intValue()), optSize);
        }
        catch (LastErrorException le) {
            throw new NativeErrorException(le.getMessage(), le.getErrorCode(), le.getCause());
        }
    }

    @Override
    public boolean isTTY() {
        return POSIXNativeCalls.isatty(0) == 1;
    }

    @Override
    public void lockCurrentMemory() {
        if (POSIXNativeCalls.mlockall(1) == 0) {
            return;
        }
        int errno = Native.getLastError();
        String reason = errno == 1 ? "insufficient privileges" : (errno == 12 ? "insufficient free space" : "errno=" + errno);
        String msg = "Unable to lock memory due to " + reason + ". Please check the RLIMIT_MEMLOCK soft resource limit (ulimit -l) and increase the available memory if needed.";
        throw new IllegalStateException(msg);
    }

    protected int getRLimitNProcResourceId() {
        return -1;
    }

    @Override
    public synchronized long getSessionThreadLimit() {
        int nProcResourceId = this.getRLimitNProcResourceId();
        if (nProcResourceId >= 0) {
            try {
                this.rlimit.rlim_cur = 0L;
                this.rlimit.rlim_max = 0L;
                if (POSIXNativeCalls.getrlimit(nProcResourceId, this.rlimit) == 0) {
                    return this.rlimit.rlim_cur;
                }
            }
            catch (LastErrorException lastErrorException) {
                // empty catch block
            }
        }
        return 0L;
    }

    static {
        Native.register((String)Platform.C_LIBRARY_NAME);
        javaEnv = POSIXNativeCalls.getModifiableJavaEnv();
    }

    static interface SignalHandler
    extends Callback {
        public void callback(int var1);
    }

    public static class RLimit
    extends Structure {
        public long rlim_cur;
        public long rlim_max;

        protected List<String> getFieldOrder() {
            return Arrays.asList("rlim_cur", "rlim_max");
        }
    }
}

