/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.jna;

import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.gemstone.gemfire.internal.shared.jna.FreeBSDNativeCalls;
import com.gemstone.gemfire.internal.shared.jna.LinuxNativeCalls;
import com.gemstone.gemfire.internal.shared.jna.MacOSXNativeCalls;
import com.gemstone.gemfire.internal.shared.jna.POSIXNativeCalls;
import com.gemstone.gemfire.internal.shared.jna.SolarisNativeCalls;
import com.gemstone.gemfire.internal.shared.jna.WinNativeCalls;
import com.sun.jna.Platform;

public final class NativeCallsJNAImpl {
    private static final NativeCalls instance = NativeCallsJNAImpl.getImplInstance();
    static final boolean is64BitPlatform = Platform.is64Bit();

    private NativeCallsJNAImpl() {
    }

    private static NativeCalls getImplInstance() {
        if (Platform.isLinux()) {
            return new LinuxNativeCalls();
        }
        if (Platform.isWindows()) {
            return new WinNativeCalls();
        }
        if (Platform.isSolaris()) {
            return new SolarisNativeCalls();
        }
        if (Platform.isMac()) {
            return new MacOSXNativeCalls();
        }
        if (Platform.isFreeBSD()) {
            return new FreeBSDNativeCalls();
        }
        return new POSIXNativeCalls();
    }

    public static NativeCalls getInstance() {
        return instance;
    }
}

