/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.jna;

import com.gemstone.gemfire.internal.shared.TCPSocketOptions;
import com.gemstone.gemfire.internal.shared.jna.OSType;
import com.gemstone.gemfire.internal.shared.jna.POSIXNativeCalls;

final class MacOSXNativeCalls
extends POSIXNativeCalls {
    private static final int OPT_TCP_KEEPALIVE = 16;
    private static final int ENOPROTOOPT = 42;
    private static final int RLIMIT_NPROC = 7;

    MacOSXNativeCalls() {
    }

    @Override
    public OSType getOSType() {
        return OSType.MACOSX;
    }

    @Override
    protected int getPlatformOption(TCPSocketOptions opt) throws UnsupportedOperationException {
        switch (opt) {
            case OPT_KEEPIDLE: {
                return 16;
            }
            case OPT_KEEPINTVL: 
            case OPT_KEEPCNT: {
                return Integer.MIN_VALUE;
            }
        }
        throw new UnsupportedOperationException("unknown option " + (Object)((Object)opt));
    }

    @Override
    protected boolean isNoProtocolOptionCode(int errno) {
        return errno == 42;
    }

    @Override
    protected int getRLimitNProcResourceId() {
        return 7;
    }
}

