/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.jna;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.TCPSocketOptions;
import com.gemstone.gemfire.internal.shared.jna.NativeCallsJNAImpl;
import com.gemstone.gemfire.internal.shared.jna.OSType;
import com.gemstone.gemfire.internal.shared.jna.POSIXNativeCalls;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class LinuxNativeCalls
extends POSIXNativeCalls {
    private static final int OPT_TCP_KEEPIDLE = 4;
    private static final int OPT_TCP_KEEPINTVL = 5;
    private static final int OPT_TCP_KEEPCNT = 6;
    private static final int ENOPROTOOPT = 92;
    private static final int ENOPROTOOPT_ALPHA = 42;
    private static final int ENOPROTOOPT_MIPS = 99;
    private static final int ENOPROTOOPT_PARISC = 220;
    private static final int RLIMIT_NPROC = 6;
    private static boolean isJNATimerEnabled;
    private ThreadLocal<Structure> tSpecs = new ThreadLocal();
    private static boolean isStatFSEnabled;

    LinuxNativeCalls() {
    }

    public static native int posix_fallocate64(int var0, long var1, long var3);

    public static native int creat64(String var0, int var1) throws LastErrorException;

    @Override
    public OSType getOSType() {
        return OSType.LINUX;
    }

    @Override
    protected int getPlatformOption(TCPSocketOptions opt) throws UnsupportedOperationException {
        switch (opt) {
            case OPT_KEEPIDLE: {
                return 4;
            }
            case OPT_KEEPINTVL: {
                return 5;
            }
            case OPT_KEEPCNT: {
                return 6;
            }
        }
        throw new UnsupportedOperationException("unknown option " + (Object)((Object)opt));
    }

    @Override
    protected boolean isNoProtocolOptionCode(int errno) {
        switch (errno) {
            case 92: {
                return true;
            }
            case 42: {
                return true;
            }
            case 99: {
                return true;
            }
            case 220: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean loadNativeLibrary() {
        return true;
    }

    @Override
    public boolean isNativeTimerEnabled() {
        if (NativeCallsJNAImpl.is64BitPlatform) {
            TimeSpec64.init();
        } else {
            TimeSpec.init();
        }
        return isJNATimerEnabled;
    }

    @Override
    public long clockResolution(int clock_id) {
        if (NativeCallsJNAImpl.is64BitPlatform) {
            TimeSpec64 res = new TimeSpec64();
            TimeSpec64.clock_getres(clock_id, res);
            return res.tv_sec * 1000000000L + res.tv_nsec;
        }
        TimeSpec res = new TimeSpec();
        TimeSpec.clock_getres(clock_id, res);
        return (long)res.tv_sec * 1000000000L + (long)res.tv_nsec;
    }

    @Override
    public long nanoTime(int clock_id) {
        TimeSpec tp;
        Structure st = this.tSpecs.get();
        if (NativeCallsJNAImpl.is64BitPlatform) {
            TimeSpec64 tp2;
            if (st == null) {
                tp2 = new TimeSpec64();
                this.tSpecs.set(tp2);
            } else {
                tp2 = (TimeSpec64)st;
            }
            TimeSpec64.clock_gettime(clock_id, tp2);
            return tp2.tv_sec * 1000000000L + tp2.tv_nsec;
        }
        if (st == null) {
            tp = new TimeSpec();
            this.tSpecs.set(tp);
        } else {
            tp = (TimeSpec)st;
        }
        TimeSpec.clock_gettime(clock_id, tp);
        return (long)tp.tv_sec * 1000000000L + (long)tp.tv_nsec;
    }

    @Override
    public synchronized boolean isOnLocalFileSystem(String path) {
        Logger logger = ClientSharedUtils.getLogger();
        if (!isStatFSEnabled) {
            return false;
        }
        int numTries = 10;
        for (int i = 1; i <= 10; ++i) {
            try {
                if (Platform.is64Bit()) {
                    StatFS64 stat = StatFS64.instance;
                    stat.f_type = 0L;
                    StatFS64.statfs(path, stat);
                    return stat.isTypeLocal();
                }
                StatFS stat = StatFS.instance;
                stat.f_type = 0;
                StatFS.statfs(path, stat);
                return stat.isTypeLocal();
            }
            catch (LastErrorException le) {
                if (logger == null || !logger.isLoggable(Level.FINE)) continue;
                logger.fine("DEBUG isOnLocalFileSystem got ex = " + (Object)((Object)le) + " msg = " + le.getMessage());
                continue;
            }
        }
        return false;
    }

    @Override
    protected boolean hasFallocate() {
        return true;
    }

    @Override
    protected int createFD(String path, int flags) throws LastErrorException {
        return LinuxNativeCalls.creat64(path, flags);
    }

    @Override
    protected void fallocateFD(int fd, long offset, long len) throws LastErrorException {
        int errno = LinuxNativeCalls.posix_fallocate64(fd, offset, len);
        if (errno != 0) {
            throw new LastErrorException(errno);
        }
    }

    @Override
    protected int getRLimitNProcResourceId() {
        return 6;
    }

    static {
        Native.register((String)"c");
        if (Platform.is64Bit()) {
            StatFS64.dummy();
        } else {
            StatFS.dummy();
        }
        isJNATimerEnabled = false;
    }

    public static class StatFS64
    extends Structure {
        public long f_type;
        public long f_bsize;
        public long f_blocks;
        public long f_bfree;
        public long f_bavail;
        public long f_files;
        public long f_ffree;
        public FSIDIntArr2 f_fsid;
        public long f_namelen;
        public long f_frsize;
        public FSPARELongArr5 f_spare;
        private static long[] REMOTE_TYPES;
        static final StatFS64 instance;

        public static native int statfs(String var0, StatFS64 var1) throws LastErrorException;

        protected List<String> getFieldOrder() {
            return Arrays.asList("f_type", "f_bsize", "f_blocks", "f_bfree", "f_bavail", "f_files", "f_ffree", "f_fsid", "f_namelen", "f_frsize", "f_spare");
        }

        boolean isTypeLocal() {
            for (int i = 0; i < REMOTE_TYPES.length; ++i) {
                if (REMOTE_TYPES[i] != this.f_type) continue;
                return false;
            }
            return true;
        }

        public static void dummy() {
        }

        static {
            StatFS64 struct;
            REMOTE_TYPES = new long[]{4283649346L, 1937076805L, 22092L, 26985L, 20859L, 16914836L};
            try {
                Native.register((String)"rt");
                struct = new StatFS64();
                int ret = StatFS64.statfs(".", struct);
                if (ret == 0) {
                    isStatFSEnabled = true;
                } else {
                    isStatFSEnabled = false;
                }
            }
            catch (Throwable t) {
                System.out.println("got error " + t.getMessage());
                t.printStackTrace();
                struct = null;
                isStatFSEnabled = false;
            }
            instance = struct;
        }
    }

    public static class FSPARELongArr5
    extends Structure {
        public long[] fspare = new long[5];

        protected List<String> getFieldOrder() {
            return Arrays.asList("fspare");
        }
    }

    public static class StatFS
    extends Structure {
        public int f_type;
        public int f_bsize;
        public int f_blocks;
        public int f_bfree;
        public int f_bavail;
        public int f_files;
        public int f_ffree;
        public FSIDIntArr2 f_fsid;
        public int f_namelen;
        public int f_frsize;
        public FSPAREIntArr5 f_spare;
        static final StatFS instance;
        private static int[] REMOTE_TYPES;

        public static native int statfs(String var0, StatFS var1) throws LastErrorException;

        protected List<String> getFieldOrder() {
            return Arrays.asList("f_type", "f_bsize", "f_blocks", "f_bfree", "f_bavail", "f_files", "f_ffree", "f_fsid", "f_namelen", "f_frsize", "f_spare");
        }

        public boolean isTypeLocal() {
            for (int i = 0; i < REMOTE_TYPES.length; ++i) {
                if (REMOTE_TYPES[i] != this.f_type) continue;
                return false;
            }
            return true;
        }

        public static void dummy() {
        }

        static {
            StatFS struct;
            try {
                Native.register((String)"rt");
                struct = new StatFS();
                int ret = StatFS.statfs(".", struct);
                if (ret == 0) {
                    isStatFSEnabled = true;
                } else {
                    isStatFSEnabled = false;
                }
            }
            catch (Throwable t) {
                struct = null;
                isStatFSEnabled = false;
            }
            instance = struct;
            REMOTE_TYPES = new int[]{1937076805, 22092, 26985, 20859, 16914836};
        }
    }

    public static class FSPAREIntArr5
    extends Structure {
        public int[] fspare = new int[5];

        protected List<String> getFieldOrder() {
            return Arrays.asList("fspare");
        }
    }

    public static class FSIDIntArr2
    extends Structure {
        public int[] fsid = new int[2];

        protected List<String> getFieldOrder() {
            return Arrays.asList("fsid");
        }
    }

    public static class TimeSpec64
    extends Structure {
        public long tv_sec;
        public long tv_nsec;

        static void init() {
        }

        public static native int clock_getres(int var0, TimeSpec64 var1) throws LastErrorException;

        public static native int clock_gettime(int var0, TimeSpec64 var1) throws LastErrorException;

        protected List<String> getFieldOrder() {
            return Arrays.asList("tv_sec", "tv_nsec");
        }

        static {
            try {
                Native.register((String)"rt");
                TimeSpec64 res = new TimeSpec64();
                int ret = TimeSpec64.clock_getres(0, res);
                if (ret == 0) {
                    isJNATimerEnabled = true;
                }
                if ((ret = TimeSpec64.clock_gettime(2, res)) == 0) {
                    isJNATimerEnabled = true;
                }
            }
            catch (Throwable t) {
                isJNATimerEnabled = false;
            }
        }
    }

    public static class TimeSpec
    extends Structure {
        public int tv_sec;
        public int tv_nsec;

        static void init() {
        }

        public static native int clock_getres(int var0, TimeSpec var1) throws LastErrorException;

        public static native int clock_gettime(int var0, TimeSpec var1) throws LastErrorException;

        protected List<String> getFieldOrder() {
            return Arrays.asList("tv_sec", "tv_nsec");
        }

        static {
            try {
                Native.register((String)"rt");
                TimeSpec res = new TimeSpec();
                int ret = TimeSpec.clock_getres(0, res);
                if (ret == 0) {
                    isJNATimerEnabled = true;
                }
                if ((ret = TimeSpec.clock_gettime(2, res)) == 0) {
                    isJNATimerEnabled = true;
                }
            }
            catch (Throwable t) {
                isJNATimerEnabled = false;
            }
        }
    }
}

