/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.jna;

import com.gemstone.gemfire.internal.shared.TCPSocketOptions;
import com.gemstone.gemfire.internal.shared.jna.OSType;
import com.gemstone.gemfire.internal.shared.jna.POSIXNativeCalls;

final class FreeBSDNativeCalls
extends POSIXNativeCalls {
    private static final int OPT_TCP_KEEPALIVE = 256;
    private static final int OPT_TCP_KEEPINTVL = 512;
    private static final int OPT_TCP_KEEPCNT = 1024;
    private static final int ENOPROTOOPT = 42;
    private static final int RLIMIT_NPROC = 7;

    FreeBSDNativeCalls() {
    }

    @Override
    public OSType getOSType() {
        return OSType.FREEBSD;
    }

    @Override
    protected int getPlatformOption(TCPSocketOptions opt) throws UnsupportedOperationException {
        switch (opt) {
            case OPT_KEEPIDLE: {
                return 256;
            }
            case OPT_KEEPINTVL: {
                return 512;
            }
            case OPT_KEEPCNT: {
                return 1024;
            }
        }
        throw new UnsupportedOperationException("unknown option " + (Object)((Object)opt));
    }

    @Override
    protected boolean isNoProtocolOptionCode(int errno) {
        return errno == 42;
    }

    @Override
    protected int getRLimitNProcResourceId() {
        return 7;
    }
}

