/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.UnsupportedGFXDVersionException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Map;

public final class Version
implements Comparable<Version> {
    private final transient String name;
    private final transient String productName;
    private final transient String methodSuffix;
    private final byte majorVersion;
    private final byte minorVersion;
    private final byte release;
    private final byte patch;
    private Version gemfireVersion;
    private final short ordinal;
    public static final String Version_REMOTE_VERSION_NOT_SUPPORTED = "Peer or client version with ordinal {0} not supported. Last known version is {1}";
    private static final Method getGFEClientCommands;
    public static final int NUM_OF_VERSIONS = 34;
    private static final Version[] VALUES;
    private static final byte TOKEN_ORDINAL = -1;
    private static final int TOKEN_ORDINAL_INT = 255;
    public static final Version TOKEN;
    private static final byte GFE_56_ORDINAL = 0;
    public static final Version GFE_56;
    private static final byte GFE_57_ORDINAL = 1;
    public static final Version GFE_57;
    private static final byte GFE_58_ORDINAL = 3;
    public static final Version GFE_58;
    private static final byte GFE_603_ORDINAL = 4;
    public static final Version GFE_603;
    private static final byte GFE_61_ORDINAL = 5;
    public static final Version GFE_61;
    private static final byte GFE_65_ORDINAL = 6;
    public static final Version GFE_65;
    private static final byte GFE_651_ORDINAL = 7;
    public static final Version GFE_651;
    private static final byte GFE_6516_ORDINAL = 12;
    public static final Version GFE_6516;
    private static final byte GFE_66_ORDINAL = 16;
    public static final Version GFE_66;
    private static final byte GFE_662_ORDINAL = 17;
    public static final Version GFE_662;
    private static final byte GFE_6622_ORDINAL = 18;
    public static final Version GFE_6622;
    private static final byte GFE_70_ORDINAL = 19;
    public static final Version GFE_70;
    private static final byte GFE_701_ORDINAL = 20;
    public static final Version GFE_701;
    private static final byte GFE_7099_ORDINAL = 21;
    public static final Version SQLF_1099;
    public static final Version GFE_7099;
    private static final byte GFE_71_ORDINAL = 22;
    public static final Version GFE_71;
    private static final byte SQLF_11_ORDINAL = 23;
    public static final Version SQLF_11;
    private static final byte GFE_75_ORDINAL = 24;
    public static final Version GFE_75;
    private static final byte GFXD_10_ORDINAL = 25;
    public static final Version GFXD_10;
    private static final byte GFXD_101_ORDINAL = 26;
    public static final Version GFXD_101;
    private static final byte GFXD_1011_ORDINAL = 27;
    public static final Version GFXD_1011;
    private static final byte GFXD_13_ORDINAL = 28;
    public static final Version GFXD_13;
    private static final byte GFXD_1302_ORDINAL = 29;
    public static final Version GFXD_1302;
    private static final byte GFXD_14_ORDINAL = 30;
    public static final Version GFXD_14;
    private static final byte GFXD_20_ORDINAL = 31;
    public static final Version GFXD_20;
    private static final byte GFE_80_ORDINAL = 30;
    public static final Version GFE_80;
    private static final byte GFXD_155_ORDINAL = 32;
    public static final Version GFXD_155;
    private static final byte STORE_162_ORDINAL = 33;
    public static final Version STORE_162;
    public static final Version CURRENT;
    public static final Version CURRENT_GFE;
    public static final short CURRENT_ORDINAL;
    public static final short CURRENT_GFE_ORDINAL;
    public static final short NOT_SUPPORTED_ORDINAL = 59;
    private static final byte validOrdinalForTesting = 2;
    public static final Version TEST_VERSION;

    private Version(String product, String name, byte major, byte minor, byte release, byte patch, byte ordinal) {
        this(product, name, major, minor, release, patch, ordinal, true);
    }

    private Version(String product, String name, byte major, byte minor, byte release, byte patch, byte ordinal, boolean overwrite) {
        this.productName = product;
        this.name = name;
        this.majorVersion = major;
        this.minorVersion = minor;
        this.release = release;
        this.patch = patch;
        this.ordinal = ordinal;
        this.methodSuffix = this.productName + "_" + this.majorVersion + "_" + this.minorVersion + "_" + this.release + "_" + this.patch;
        this.gemfireVersion = null;
        if (overwrite && ordinal != -1) {
            Version.VALUES[this.ordinal] = this;
        }
    }

    private Version(String product, String name, byte major, byte minor, byte release, byte patch, byte ordinal, Version gemfireVersion) {
        this(product, name, major, minor, release, patch, ordinal);
        this.gemfireVersion = gemfireVersion;
    }

    public static Version fromOrdinal(short ordinal, boolean forGFEClients) throws UnsupportedGFXDVersionException {
        Version version;
        if (ordinal == 59) {
            throw new UnsupportedGFXDVersionException("Un-versioned clients are not supported. ");
        }
        if (ordinal == -1) {
            return TOKEN;
        }
        if (VALUES.length < ordinal + 1 || (version = VALUES[ordinal]) == null || forGFEClients && Version.getClientCommands(version) == null) {
            throw new UnsupportedGFXDVersionException(MessageFormat.format(Version_REMOTE_VERSION_NOT_SUPPORTED, ordinal, Version.CURRENT.name));
        }
        return version;
    }

    private static Map<?, ?> getClientCommands(Version version) {
        if (getGFEClientCommands == null) {
            return null;
        }
        try {
            return (Map)getGFEClientCommands.invoke(null, version);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Version fromOrdinalOrCurrent(short ordinal) {
        Version version;
        if (ordinal == -1) {
            return TOKEN;
        }
        if (VALUES.length < ordinal + 1 || (version = VALUES[ordinal]) == null) {
            return CURRENT;
        }
        return version;
    }

    public static void writeOrdinal(DataOutput out, short ordinal, boolean compressed) throws IOException {
        if (compressed && ordinal <= 127) {
            out.writeByte(ordinal);
        } else {
            out.writeByte(-1);
            out.writeShort(ordinal);
        }
    }

    public final void writeOrdinal(DataOutput out, boolean compressed) throws IOException {
        Version.writeOrdinal(out, this.ordinal, compressed);
    }

    public static final int uncompressedSize() {
        return 3;
    }

    public final int compressedSize() {
        if (this.ordinal <= 127) {
            return 1;
        }
        return 3;
    }

    public static void writeOrdinal(ByteBuffer buffer, short ordinal, boolean compressed) throws IOException {
        if (compressed && ordinal <= 127) {
            buffer.put((byte)ordinal);
        } else {
            buffer.put((byte)-1);
            buffer.putShort(ordinal);
        }
    }

    public static short readOrdinal(DataInput in) throws IOException {
        byte ordinal = in.readByte();
        if (ordinal != -1) {
            return ordinal;
        }
        return in.readShort();
    }

    public static Version readVersion(DataInput in, boolean returnNullForCurrent) throws UnsupportedGFXDVersionException, IOException {
        return Version.fromOrdinalCheck(Version.readOrdinal(in), returnNullForCurrent);
    }

    public static Version fromOrdinalCheck(short ordinal, boolean returnNullForCurrent) throws UnsupportedGFXDVersionException {
        if (ordinal >= Version.CURRENT.ordinal) {
            return returnNullForCurrent ? null : CURRENT;
        }
        return Version.fromOrdinal(ordinal, false);
    }

    public static short readOrdinalFromInputStream(InputStream is) throws IOException {
        int ordinal = is.read();
        if (ordinal != -1) {
            int ordinalPart2;
            if (ordinal != 255) {
                return (short)ordinal;
            }
            int ordinalPart1 = is.read();
            if ((ordinalPart1 | (ordinalPart2 = is.read())) >= 0) {
                return (short)(ordinalPart1 << 8 | ordinalPart2);
            }
            return -1;
        }
        return -1;
    }

    public Version getGemFireVersion() {
        return this.gemfireVersion != null ? this.gemfireVersion : this;
    }

    public final String getMethodSuffix() {
        return this.methodSuffix;
    }

    public final String getProductName() {
        return this.productName;
    }

    public final String getName() {
        return this.name;
    }

    public final short getMajorVersion() {
        return this.majorVersion;
    }

    public final short getMinorVersion() {
        return this.minorVersion;
    }

    public final short getRelease() {
        return this.release;
    }

    public final short getPatch() {
        return this.patch;
    }

    public final short ordinal() {
        return this.ordinal;
    }

    public boolean compatibleWith(Version version) {
        return true;
    }

    @Override
    public final int compareTo(short other) {
        try {
            Version v = Version.fromOrdinalCheck(other, false);
            return this.ordinal - v.ordinal;
        }
        catch (UnsupportedGFXDVersionException ugve) {
            return this.ordinal - other;
        }
    }

    @Override
    public final int compareTo(Version o) {
        if (o != null) {
            return this.ordinal - o.ordinal;
        }
        return 1;
    }

    public String toString() {
        if (this.gemfireVersion == null) {
            return this.productName + ' ' + this.name + '(' + this.ordinal + ')';
        }
        return this.productName + ' ' + this.name + '(' + this.ordinal + ")[" + this.gemfireVersion.toString() + ']';
    }

    public static String toString(short ordinal) {
        if (ordinal <= Version.CURRENT.ordinal) {
            try {
                return Version.fromOrdinal(ordinal, false).toString();
            }
            catch (UnsupportedGFXDVersionException unsupportedGFXDVersionException) {
                // empty catch block
            }
        }
        return "UNKNOWN[ordinal=" + ordinal + ']';
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[]{(byte)(this.ordinal >> 8), (byte)this.ordinal};
        return bytes;
    }

    public static Version fromBytes(byte[] bytes) throws UnsupportedGFXDVersionException {
        if (bytes.length != 2) {
            throw new IllegalArgumentException("Illegal length for bytes, should be 2: " + bytes.length);
        }
        short ordinal = (short)((bytes[0] << 8) + (bytes[1] & 0xFF));
        return Version.fromOrdinal(ordinal, false);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == Version.class) {
            return this.ordinal == ((Version)other).ordinal;
        }
        return false;
    }

    public boolean equals(Version other) {
        if (other != null) {
            return this.ordinal == other.ordinal;
        }
        return this.ordinal == Version.CURRENT.ordinal;
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + this.ordinal;
        return result;
    }

    static {
        Method m;
        VALUES = new Version[34];
        TOKEN = new Version("", "TOKEN", -1, 0, 0, 0, -1);
        GFE_56 = new Version("GFE", "5.6", 5, 6, 0, 0, 0);
        GFE_57 = new Version("GFE", "5.7", 5, 7, 0, 0, 1);
        GFE_58 = new Version("GFE", "5.8", 5, 8, 0, 0, 3);
        GFE_603 = new Version("GFE", "6.0.3", 6, 0, 3, 0, 4);
        GFE_61 = new Version("GFE", "6.1", 6, 1, 0, 0, 5);
        GFE_65 = new Version("GFE", "6.5", 6, 5, 0, 0, 6);
        GFE_651 = new Version("GFE", "6.5.1", 6, 5, 1, 0, 7);
        GFE_6516 = new Version("GFE", "6.5.1.6", 6, 5, 1, 6, 12);
        GFE_66 = new Version("GFE", "6.6", 6, 6, 0, 0, 16);
        GFE_662 = new Version("GFE", "6.6.2", 6, 6, 2, 0, 17);
        GFE_6622 = new Version("GFE", "6.6.2.2", 6, 6, 2, 2, 18);
        GFE_70 = new Version("GFE", "7.0", 7, 0, 0, 0, 19);
        GFE_701 = new Version("GFE", "7.0.1", 7, 0, 1, 0, 20);
        SQLF_1099 = new Version("SQLF", "1.0.99", 1, 0, 99, 0, 21, GFE_70);
        GFE_7099 = new Version("GFE", "7.0.99", 7, 0, 99, 0, 21);
        GFE_71 = new Version("GFE", "7.1", 7, 1, 0, 0, 22);
        SQLF_11 = new Version("SQLF", "1.1", 1, 1, 0, 0, 23, GFE_7099);
        GFE_75 = new Version("GFE", "7.5", 7, 5, 0, 0, 24);
        GFXD_10 = new Version("GFXD", "1.0", 1, 0, 0, 0, 25, GFE_75);
        GFXD_101 = new Version("GFXD", "1.0.1", 1, 0, 1, 0, 26, GFE_75);
        GFXD_1011 = new Version("GFXD", "1.0.1.1", 1, 0, 1, 1, 27, GFE_75);
        GFXD_13 = new Version("GFXD", "1.3", 1, 3, 0, 0, 28, GFE_75);
        GFXD_1302 = new Version("GFXD", "1.3.0.2", 1, 3, 0, 2, 29, GFE_75);
        GFXD_14 = new Version("GFXD", "1.4", 1, 4, 0, 0, 30, GFE_75);
        GFXD_20 = new Version("GFXD", "2.0", 2, 0, 0, 0, 31, GFE_75);
        GFE_80 = new Version("GFE", "8.0", 8, 0, 0, 0, 30, false);
        GFXD_155 = new Version("GFXD", "1.5.5", 1, 5, 5, 0, 32, GFE_80);
        CURRENT = STORE_162 = new Version("STORE", "1.6.2", 1, 6, 2, 0, 33, GFE_80);
        CURRENT_GFE = CURRENT.getGemFireVersion();
        CURRENT_ORDINAL = CURRENT.ordinal();
        CURRENT_GFE_ORDINAL = CURRENT_GFE.ordinal();
        TEST_VERSION = new Version("TEST", "VERSION", 0, 0, 0, 0, 2);
        try {
            Class<?> c = Class.forName("com.gemstone.org.jgroups.JGroupsVersion");
            Field f = c.getField("CURRENT_ORDINAL");
            f.setAccessible(true);
            f.setShort(null, CURRENT_ORDINAL);
        }
        catch (ClassNotFoundException c) {
        }
        catch (Exception e) {
            ClientSharedUtils.getLogger().warning("Failed to set JGroupsVersion.CURRENT_ORDINAL: " + e);
        }
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.CommandInitializer");
            m = cls.getMethod("getCommands", Version.class);
        }
        catch (Exception e) {
            m = null;
        }
        getGFEClientCommands = m;
    }
}

