/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.log4j.Logger;

public final class SystemProperties {
    public static final String KEEPALIVE_IDLE = "keepalive-idle";
    public static final String KEEPALIVE_INTVL = "keepalive-interval";
    public static final String KEEPALIVE_CNT = "keepalive-count";
    public static final int DEFAULT_KEEPALIVE_IDLE = 20;
    public static final int DEFAULT_KEEPALIVE_INTVL = 4;
    public static final int DEFAULT_KEEPALIVE_CNT = 10;
    public static final String DEFAULT_PROPERTY_NAME_PREFIX = "gemfire.";
    public static final String DEFAULT_GFXDCLIENT_PROPERTY_NAME_PREFIX = "snappydata.client.";
    public static final String SNAPPY_PREFIX = "snappydata.store.";
    public static final String SHADOW_SCHEMA_NAME = "SNAPPYSYS_INTERNAL";
    public static final String SHADOW_TABLE_SUFFIX = "_COLUMN_STORE_";
    public static final String SHADOW_SCHEMA_SEPARATOR = "____";
    public static final String SHADOW_SCHEMA_NAME_WITH_SEPARATOR = "SNAPPYSYS_INTERNAL____";
    public static final String SNAPPY_HIVE_METASTORE = "SNAPPY_HIVE_METASTORE";
    public static final String SNAPPY_HIVE_METASTORE_PATH = "/SNAPPY_HIVE_METASTORE";
    public static final String DDL_STMTS_REGION = "_DDL_STMTS_META_REGION";
    public static final String DDL_STMTS_REGION_PATH = "/_DDL_STMTS_META_REGION";
    public static final String GFXD_FACTORY_PROVIDER = "com.pivotal.gemfirexd.internal.engine.store.entry.GfxdObjectFactoriesProvider";
    public static final String SNAPPY_DEFAULT_COMPRESSION_CODEC = "lz4";
    public static final int SNAPPY_MIN_COLUMN_DELTA_ROWS = 200;
    private static final SystemProperties serverInstance;
    private static final SystemProperties clientInstance;
    private volatile Callbacks callbacks;

    public static boolean isUsingGemFireXDEntryPoint() {
        StackTraceElement[] stack;
        for (StackTraceElement frame : stack = Thread.currentThread().getStackTrace()) {
            String frameCls = frame.getClassName();
            if (!"com.pivotal.gemfirexd.internal.engine.store.GemFireStore".equals(frameCls) && !"com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor".equals(frameCls) && !"com.pivotal.gemfirexd.tools.internal.GfxdServerLauncher".equals(frameCls) && !"com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceImpl".equals(frameCls) && !"com.pivotal.gemfirexd.tools.GfxdDistributionLocator".equals(frameCls) && !"com.pivotal.gemfirexd.tools.GfxdAgentLauncher".equals(frameCls) && !"com.pivotal.gemfirexd.internal.engine.fabricservice.FabricAgentImpl".equals(frameCls) && !"com.pivotal.gemfirexd.tools.GfxdSystemAdmin".equals(frameCls) && !"com.pivotal.gemfirexd.internal.GemFireXDVersion".equals(frameCls) && !"io.snappydata.gemxd.SnappyDataVersion$".equals(frameCls) && !"io.snappydata.gemxd.SnappyDataVersion".equals(frameCls) && !"org.apache.spark.sql.SnappySession$".equals(frameCls) && !"org.apache.spark.sql.SnappySession".equals(frameCls) && !"io.snappydata.gemxd.ClusterCallbacksImpl$".equals(frameCls)) continue;
            return true;
        }
        return false;
    }

    private SystemProperties(Callbacks cb) {
        this.callbacks = cb;
    }

    public static SystemProperties getServerInstance() {
        return serverInstance;
    }

    public static SystemProperties getClientInstance() {
        return clientInstance;
    }

    public static Callbacks getGFXDServerCallbacks() {
        try {
            Class<?> factoryProvider = Class.forName(GFXD_FACTORY_PROVIDER);
            Method method = factoryProvider.getDeclaredMethod("getSystemCallbacksImpl", new Class[0]);
            return (Callbacks)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception in obtaining GemFireXD Objects Factory provider class", e);
        }
    }

    public synchronized void setCallbacks(Callbacks cb) {
        this.callbacks = cb;
    }

    public synchronized Callbacks getCallbacks() {
        return this.callbacks;
    }

    public String getString(String name, String defaultValue) {
        try {
            Callbacks cb = this.callbacks;
            String value = cb.getSystemProperty(name, this);
            if (value != null) {
                return value;
            }
            if (this == clientInstance) {
                return serverInstance.getString(name, defaultValue);
            }
            return defaultValue;
        }
        catch (SecurityException | PrivilegedActionException e) {
            Logger log = Logger.getLogger(this.getClass());
            log.warn((Object)("Could not read system property: " + name), (Throwable)e);
            return defaultValue;
        }
    }

    public int getInteger(String name, int defaultValue) {
        String value = this.getString(name, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw ClientSharedUtils.newRuntimeException("Expected integer value for system property [" + name + "] but found [" + value + "]", nfe);
            }
        }
        return defaultValue;
    }

    public long getLong(String name, long defaultValue) {
        String value = this.getString(name, null);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                throw ClientSharedUtils.newRuntimeException("Expected long value for system property [" + name + "] but found [" + value + "]", nfe);
            }
        }
        return defaultValue;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.getString(name, null);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public String getSystemPropertyNamePrefix() {
        return this.callbacks.getSystemPropertyNamePrefix();
    }

    static {
        Callbacks cb = SystemProperties.isUsingGemFireXDEntryPoint() ? SystemProperties.getGFXDServerCallbacks() : new DefaultCallbacks(DEFAULT_PROPERTY_NAME_PREFIX);
        serverInstance = new SystemProperties(cb);
        clientInstance = new SystemProperties(new DefaultCallbacks(DEFAULT_GFXDCLIENT_PROPERTY_NAME_PREFIX));
    }

    public static class DefaultCallbacks
    implements Callbacks,
    PrivilegedExceptionAction<String> {
        private final String propertyNamePrefix;
        private String _propertyName;

        public DefaultCallbacks(String propertyNamePrefix) {
            this.propertyNamePrefix = propertyNamePrefix;
        }

        @Override
        public String getSystemPropertyNamePrefix() {
            return this.propertyNamePrefix;
        }

        @Override
        public synchronized String getSystemProperty(String key, SystemProperties properties) throws PrivilegedActionException {
            this._propertyName = key.startsWith(this.propertyNamePrefix) ? key : this.propertyNamePrefix + key;
            String value = AccessController.doPrivileged(this);
            this._propertyName = null;
            return value;
        }

        @Override
        public String run() {
            String key = this._propertyName;
            if (key != null) {
                return System.getProperty(key);
            }
            return null;
        }
    }

    public static interface Callbacks {
        public String getSystemPropertyNamePrefix();

        public String getSystemProperty(String var1, SystemProperties var2) throws PrivilegedActionException;
    }
}

