/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.StreamChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class OutputStreamChannel
extends OutputStream
implements WritableByteChannel,
StreamChannel {
    protected final WritableByteChannel channel;
    private final boolean socketToSameHost;
    private volatile Thread parkedThread;
    protected volatile long bytesWritten;

    protected OutputStreamChannel(WritableByteChannel channel) {
        this.channel = channel;
        this.socketToSameHost = ClientSharedUtils.isSocketToSameHost(channel);
    }

    public final boolean isSocketToSameHost() {
        return this.socketToSameHost;
    }

    public final WritableByteChannel getUnderlyingChannel() {
        return this.channel;
    }

    @Override
    public abstract int write(ByteBuffer var1) throws IOException;

    public abstract void writeInt(int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int writeBuffered(ByteBuffer src, ByteBuffer channelBuffer) throws IOException {
        int srcLen = src.remaining();
        boolean flushBuffer = srcLen > channelBuffer.limit() >>> 1 && src.isDirect();
        int numWritten = 0;
        while (srcLen > 0) {
            int remaining = channelBuffer.remaining();
            if (srcLen <= remaining) {
                channelBuffer.put(src);
                return numWritten + srcLen;
            }
            if (flushBuffer && channelBuffer.position() == 0) {
                return numWritten + this.writeBufferNoWait(src, this.channel);
            }
            if (remaining > 0) {
                int srcPos = src.position();
                src.limit(srcPos + remaining);
                try {
                    channelBuffer.put(src);
                }
                finally {
                    src.limit(srcPos + srcLen);
                }
                numWritten += remaining;
                assert ((srcLen -= remaining) == src.remaining()) : "srcLen=" + srcLen + " srcRemaining=" + src.remaining();
            }
            if (!this.flushBufferNonBlockingBase(channelBuffer)) {
                return numWritten;
            }
            if (!flushBuffer) continue;
            return numWritten + this.writeBufferNoWait(src, this.channel);
        }
        return numWritten;
    }

    protected final boolean flushBufferNonBlockingBase(ByteBuffer buffer) throws IOException {
        boolean flushed;
        buffer.flip();
        try {
            this.writeBufferNoWait(buffer, this.channel);
        }
        finally {
            if (buffer.hasRemaining()) {
                buffer.compact();
                flushed = false;
            } else {
                buffer.clear();
                flushed = true;
            }
        }
        return flushed;
    }

    protected int writeBuffer(ByteBuffer buffer, WritableByteChannel channel) throws IOException {
        int numWritten;
        long parkedNanos = 0L;
        int numTries = 0;
        while ((numWritten = channel.write(buffer)) == 0 && buffer.hasRemaining()) {
            parkedNanos = ClientSharedUtils.parkThreadForAsyncOperationIfRequired(this, parkedNanos, ++numTries);
        }
        if (numWritten > 0) {
            this.bytesWritten += (long)numWritten;
        }
        return numWritten;
    }

    @Override
    public final Thread getParkedThread() {
        return this.parkedThread;
    }

    @Override
    public final void setParkedThread(Thread thread) {
        this.parkedThread = thread;
    }

    @Override
    public long getParkNanosMax() {
        return 30000000000L;
    }

    protected int writeBufferNoWait(ByteBuffer buffer, WritableByteChannel channel) throws IOException {
        int numWritten = channel.write(buffer);
        if (numWritten > 0) {
            this.bytesWritten += (long)numWritten;
        }
        return numWritten;
    }

    public final long getBytesWritten() {
        return this.bytesWritten;
    }
}

