/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.cache.Status;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.SystemProperties;
import java.io.Console;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class LauncherBase {
    public static final String LOG_FILE = "log-file";
    public static final String HOST_DATA = "host-data";
    public static final String THRESHOLD_THICKNESS_PROP = "gemfire.thresholdThickness";
    public static final String THRESHOLD_THICKNESS_EVICT_PROP = "gemfire.eviction-thresholdThickness";
    public static final String EVICTION_BURST_PERCENT_PROP = "gemfire.HeapLRUCapacityController.evictionBurstPercentage";
    public static final String CRITICAL_HEAP_PERCENTAGE = "critical-heap-percentage";
    public static final String EVICTION_HEAP_PERCENTAGE = "eviction-heap-percentage";
    public static final String CRITICAL_OFF_HEAP_PERCENTAGE = "critical-off-heap-percentage";
    public static final String EVICTION_OFF_HEAP_PERCENTAGE = "eviction-off-heap-percentage";
    public static final String POLLER_INTERVAL_PROP = "gemfire.heapPollerInterval";
    public static final String EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST_PROP = "gemfire.HeapLRUCapacityController.evictHighEntryCountBucketsFirst";
    public static final String EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST_FOR_EVICTOR_PROP = "gemfire.HeapLRUCapacityController.evictHighEntryCountBucketsFirstForEvictor";
    public static final String LAUNCHER_SEE_LOG_FILE = "See log file for details.";
    public static final String LAUNCHER_NO_AVAILABLE_STATUS = "No available status. Either status file \"{0}\" is not readable or reading the status file timed out.";
    public static final String LAUNCHER_STOPPED = "The {0} on {1} has stopped.";
    public static final String LAUNCHER_TIMEOUT_WAITING_FOR_SHUTDOWN = "Timeout waiting for {0} to shutdown on {1}, status is: {2}";
    public static final String LAUNCHER_NO_STATUS_FILE = "The specified working directory ({0}) on {1} contains no status file";
    public static final String LAUNCHER_UNREADABLE_STATUS_FILE = "The status file {0} cannot be read due to: {1}. Delete the file if no node is running in the directory.";
    public static final String LAUNCHER_UNKNOWN_ARGUMENT = "Unknown argument: {0}";
    public static final String LAUNCHER_WORKING_DIRECTORY_DOES_NOT_EXIST = "The input working directory does not exist:  {0}";
    public static final String LAUNCHER_LOGS_GENERATED_IN = "Logs generated in {0}";
    public static final String LAUNCH_IN_PROGRESS = "The server is still starting. {0} seconds have elapsed since the last log message: \n {1}";
    public static final String LAUNCHER_IS_ALREADY_RUNNING_IN_DIRECTORY = "WARN: A {0} is already running in directory \"{1}\"";
    private static final String LAUNCHER_EXPECTED_BOOLEAN = "Expected true or false for \"{0}=<value>\" but was \"{1}\"";
    protected static final String DIR = "dir";
    protected static final String CLASSPATH = "classpath";
    protected static final String HEAP_SIZE = "heap-size";
    protected static final String WAIT_FOR_SYNC = "sync";
    protected static final String VMARGS = "vmArgs";
    protected static final String ENVARGS = "envArgs";
    protected static final String ENV1 = "env_1";
    protected static final String ENV2 = "env_2";
    protected static final String ENV_MARKER = "PLAIN:";
    protected static final int FORCE_STATUS_FILE_READ_ITERATION_COUNT = 10;
    private static final long STATUS_WAIT_TIME = SystemProperties.getServerInstance().getLong("launcher.STATUS_WAIT_TIME_MS", 15000L);
    private static final long SHUTDOWN_WAIT_TIME = SystemProperties.getServerInstance().getLong("launcher.SHUTDOWN_WAIT_TIME_MS", 15000L);
    public static final long LARGE_RAM_LIMIT = 0x380000000L;
    public static final double oneGB = 1.073741824E9;
    private static final double twoGB = 2.147483648E9;
    protected final String baseName;
    protected final String defaultLogFileName;
    protected final String startLogFileName;
    protected final String pidFileName;
    protected final String statusName;
    protected final String hostName;
    protected volatile Status status;
    protected boolean waitForData;
    protected final String jvmVendor;
    protected String maxHeapSize;
    protected String initialHeapSize;
    protected boolean useThriftServerDefault = ClientSharedUtils.isThriftDefault();

    protected LauncherBase(String displayName, String baseName) {
        if (baseName == null) {
            baseName = this.getBaseName(displayName);
        }
        this.baseName = displayName;
        this.defaultLogFileName = baseName + ".log";
        this.startLogFileName = "start_" + this.defaultLogFileName;
        this.pidFileName = baseName + ".pid";
        this.statusName = "." + baseName + ".stat";
        InetAddress host = null;
        try {
            host = InetAddress.getLocalHost();
        }
        catch (Exception ex) {
            try {
                host = ClientSharedUtils.getLocalHost();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.hostName = host != null ? host.getCanonicalHostName() : "localhost";
        this.waitForData = true;
        this.jvmVendor = System.getProperty("java.vendor");
    }

    protected String getBaseName(String name) {
        return name != null ? name.toLowerCase().replace(" ", "") : null;
    }

    public static long getPhysicalRAMSize() {
        long totalMemory = 0L;
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        Object memSize = null;
        try {
            Method m = bean.getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]);
            m.setAccessible(true);
            memSize = m.invoke((Object)bean, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (memSize instanceof Number) {
            totalMemory = ((Number)memSize).longValue();
        }
        return totalMemory;
    }

    protected long getDefaultHeapSizeMB(boolean hostData) {
        return LauncherBase.getDefaultHeapSizeMB(LauncherBase.getPhysicalRAMSize(), hostData);
    }

    public static long getDefaultHeapSizeMB(long ramSize, boolean hostData) {
        int numProcs = Runtime.getRuntime().availableProcessors();
        if (hostData) {
            if (numProcs > 12 && ramSize > 0x400000000L) {
                return 8192L;
            }
            if (numProcs > 8 && ramSize > 0x380000000L) {
                return 6144L;
            }
            return 4096L;
        }
        if (numProcs > 16 && ramSize > 0x480000000L) {
            return 8192L;
        }
        if (numProcs > 12 && ramSize > 0x400000000L) {
            return 6144L;
        }
        if (numProcs > 2) {
            return 4096L;
        }
        return 2048L;
    }

    protected long getDefaultSmallHeapSizeMB(boolean hostData) {
        return hostData ? 2048L : 1024L;
    }

    protected void processHeapSize(String value, List<String> vmArgs) {
        if (this.maxHeapSize == null) {
            vmArgs.add("-Xmx" + value);
            this.maxHeapSize = value;
        }
        if (this.initialHeapSize == null) {
            vmArgs.add("-Xms" + value);
            this.initialHeapSize = value;
        }
    }

    protected void processWaitForSync(String value) {
        boolean isTrue = "true".equalsIgnoreCase(value);
        if (!isTrue && !"false".equalsIgnoreCase(value)) {
            throw new IllegalArgumentException(MessageFormat.format(LAUNCHER_EXPECTED_BOOLEAN, WAIT_FOR_SYNC, value));
        }
        this.waitForData = isTrue;
    }

    protected void processVMArg(String vmArg, List<String> vmArgs) {
        if (vmArg.startsWith("-Xmx")) {
            this.maxHeapSize = vmArg.substring(4);
        } else if (vmArg.startsWith("-Xms")) {
            this.initialHeapSize = vmArg.substring(4);
        } else {
            String thriftArg = "-D" + SystemProperties.getServerInstance().getSystemPropertyNamePrefix() + "thrift-default";
            if (vmArg.startsWith(thriftArg)) {
                int len = thriftArg.length();
                if (vmArg.length() > len + 1 && vmArg.charAt(len) == '=') {
                    this.useThriftServerDefault = Boolean.parseBoolean(vmArg.substring(len + 1).trim());
                }
            }
        }
        vmArgs.add(vmArg);
    }

    protected void setDefaultVMArgs(Map<String, Object> map, boolean hostData, List<String> vmArgs) {
        long totalMemory = LauncherBase.getPhysicalRAMSize();
        float evictPercent = 0.0f;
        float criticalPercent = 0.0f;
        if (this.maxHeapSize == null) {
            if (this.initialHeapSize != null) {
                vmArgs.add("-Xmx" + this.initialHeapSize);
                this.maxHeapSize = this.initialHeapSize;
            } else {
                long defaultMemoryMB = this.getDefaultHeapSizeMB(hostData);
                if (defaultMemoryMB > 0L && totalMemory > 0L) {
                    long defaultMemory = defaultMemoryMB * 1024L * 1024L;
                    if (totalMemory * 2L < defaultMemory * 3L && totalMemory * 2L < (defaultMemory = (defaultMemoryMB = this.getDefaultSmallHeapSizeMB(hostData)) * 1024L * 1024L) * 3L) {
                        defaultMemoryMB = 0L;
                    }
                    if (defaultMemoryMB > 0L) {
                        this.maxHeapSize = this.initialHeapSize = Long.toString(defaultMemoryMB) + 'm';
                        vmArgs.add("-Xmx" + this.maxHeapSize);
                        vmArgs.add("-Xms" + this.initialHeapSize);
                    }
                }
            }
        } else if (this.initialHeapSize == null) {
            vmArgs.add("-Xms" + this.maxHeapSize);
            this.initialHeapSize = this.maxHeapSize;
        }
        String maxHeapStr = this.maxHeapSize;
        if (maxHeapStr != null && maxHeapStr.equals(this.initialHeapSize)) {
            String criticalHeapStr = (String)map.get(CRITICAL_HEAP_PERCENTAGE);
            if (criticalHeapStr == null) {
                double heapSize = ClientSharedUtils.parseMemorySize(maxHeapStr, 0L, 0);
                if (heapSize > 4.294967296E10) {
                    criticalPercent = (float)(100.0 * (1.0 - 2.147483648E9 / heapSize));
                    if (criticalPercent > 98.0f) {
                        criticalPercent = 98.0f;
                    }
                } else {
                    criticalPercent = heapSize >= 2.147483648E9 ? 95.0f : 90.0f;
                }
                map.put(CRITICAL_HEAP_PERCENTAGE, "-critical-heap-percentage=" + criticalPercent);
            } else {
                criticalPercent = Float.parseFloat(criticalHeapStr.substring(criticalHeapStr.indexOf(61) + 1).trim());
            }
            String evictHeapStr = (String)map.get(EVICTION_HEAP_PERCENTAGE);
            if (evictHeapStr == null) {
                evictPercent = criticalPercent * 0.9f;
                map.put(EVICTION_HEAP_PERCENTAGE, "-eviction-heap-percentage=" + evictPercent);
            } else {
                evictPercent = Float.parseFloat(evictHeapStr.substring(evictHeapStr.indexOf(61) + 1).trim());
            }
        }
        if (this.jvmVendor != null && (this.jvmVendor.contains("Sun") || this.jvmVendor.contains("Oracle"))) {
            vmArgs.add("-XX:+UseParNewGC");
            vmArgs.add("-XX:+UseConcMarkSweepGC");
            vmArgs.add("-XX:CMSInitiatingOccupancyFraction=50");
            vmArgs.add("-XX:+CMSClassUnloadingEnabled");
            vmArgs.add("-XX:-DontCompileHugeMethods");
            vmArgs.add("-XX:CompileThreshold=2000");
            vmArgs.add("-XX:+UnlockDiagnosticVMOptions");
            vmArgs.add("-XX:ParGCCardsPerStrideChunk=4k");
            vmArgs.add("-Djdk.nio.maxCachedBufferSize=131072");
        }
        if (evictPercent != 0.0f) {
            float criticalThickness = criticalPercent * 0.05f;
            vmArgs.add("-Dgemfire.thresholdThickness=" + criticalThickness);
            float evictThickness = evictPercent * 0.1f;
            vmArgs.add("-Dgemfire.eviction-thresholdThickness=" + evictThickness);
            float evictBurstPercent = evictPercent * 0.02f;
            vmArgs.add("-Dgemfire.HeapLRUCapacityController.evictionBurstPercentage=" + evictBurstPercent);
            vmArgs.add("-Dgemfire.heapPollerInterval=200");
            vmArgs.add("-Dgemfire.HeapLRUCapacityController.evictHighEntryCountBucketsFirst=false");
            vmArgs.add("-Dgemfire.HeapLRUCapacityController.evictHighEntryCountBucketsFirstForEvictor=true");
        }
        vmArgs.add("-Dorg.codehaus.janino.source_debugging.enable=true");
    }

    protected abstract Path getWorkingDirPath();

    protected Path getStatusPath() {
        return this.getWorkingDirPath().resolve(this.statusName);
    }

    protected long getLastModifiedStatusNanos() throws IOException {
        return Files.getLastModifiedTime(this.getStatusPath(), new LinkOption[0]).to(TimeUnit.NANOSECONDS);
    }

    protected String verifyAndClearStatus() throws IOException {
        Status status = this.getStatus();
        if (status != null && status.state != 0) {
            return MessageFormat.format(LAUNCHER_IS_ALREADY_RUNNING_IN_DIRECTORY, this.baseName, this.getWorkingDirPath());
        }
        this.deleteStatus();
        return null;
    }

    protected final void setStatusField(Status s) {
        this.status = s;
    }

    protected final Status createStatus(int state, int pid) {
        return Status.create(this.baseName, state, pid, this.getStatusPath());
    }

    protected final Status createStatus(int state, int pid, String msg, Throwable t) {
        return Status.create(this.baseName, state, pid, msg, t, this.getStatusPath());
    }

    protected Status getStatus() {
        Path statusPath = this.getStatusPath();
        Status status = Files.exists(statusPath, new LinkOption[0]) ? this.spinReadStatus(statusPath) : this.createStatus(0, 0);
        return status;
    }

    protected Status spinReadStatus(Path statusPath) {
        return Status.spinRead(this.baseName, statusPath);
    }

    protected void deleteStatus() throws IOException {
        Status.delete(this.getStatusPath());
    }

    protected int waitForRunning(String logFilePath) throws IOException, InterruptedException {
        Path statusPath = this.getStatusPath();
        Status status = this.spinReadStatus(statusPath);
        String lastReadMessage = null;
        String lastReportedMessage = null;
        long lastReadTime = System.nanoTime();
        if (status == null) {
            throw new IOException(MessageFormat.format(LAUNCHER_NO_AVAILABLE_STATUS, this.statusName));
        }
        if (logFilePath != null) {
            System.out.println(MessageFormat.format(LAUNCHER_LOGS_GENERATED_IN, logFilePath));
        }
        if (this.checkStatusForWait(status)) {
            long oldModified = this.getLastModifiedStatusNanos();
            int count = 0;
            while (this.checkStatusForWait(status)) {
                long elapsed;
                Thread.sleep(100L);
                long lastModified = this.getLastModifiedStatusNanos();
                if (lastModified != oldModified || count++ == 10) {
                    count = 0;
                    oldModified = lastModified;
                    status = this.spinReadStatus(statusPath);
                }
                if (status == null) {
                    throw new IOException(MessageFormat.format(LAUNCHER_NO_AVAILABLE_STATUS, this.statusName));
                }
                if (status.dsMsg != null && !status.dsMsg.equals(lastReadMessage)) {
                    lastReadMessage = status.dsMsg;
                    lastReadTime = System.nanoTime();
                }
                if (TimeUnit.NANOSECONDS.toMillis(elapsed = System.nanoTime() - lastReadTime) <= STATUS_WAIT_TIME || lastReadMessage == null || lastReadMessage.equals(lastReportedMessage)) continue;
                long elapsedSec = TimeUnit.NANOSECONDS.toSeconds(elapsed);
                System.out.println(MessageFormat.format(LAUNCH_IN_PROGRESS, elapsedSec, status.dsMsg));
                lastReportedMessage = lastReadMessage;
            }
            if (status.state == 0) {
                System.out.println(status);
                return 1;
            }
        }
        this.writePidToFile(status);
        System.out.println(status);
        return 0;
    }

    private void writePidToFile(Status status) throws IOException {
        Path pidFile = this.getWorkingDirPath().resolve(this.pidFileName);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(pidFile, new OpenOption[0]));){
            writer.write(String.valueOf(status.pid));
            writer.flush();
        }
    }

    protected void pollCacheServerForShutdown(Path statusFile) throws IOException {
        long clock = System.currentTimeMillis();
        long end = clock + SHUTDOWN_WAIT_TIME;
        while (clock < end) {
            try {
                this.status = this.spinReadStatus(statusFile);
                if (this.status.state == 0) break;
                Thread.sleep(200L);
                clock = System.currentTimeMillis();
            }
            catch (InterruptedException ie) {
                break;
            }
        }
    }

    protected boolean checkStatusForWait(Status status) {
        return status.state == 1 || this.waitForData && status.state == 4;
    }

    public static String readPassword(String prompt) {
        Console cons = System.console();
        if (cons == null) {
            throw new IllegalStateException("No console found for reading the password.");
        }
        char[] pwd = cons.readPassword(prompt, new Object[0]);
        return pwd != null ? new String(pwd) : null;
    }
}

