/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.StreamChannel;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public abstract class InputStreamChannel
extends InputStream
implements ReadableByteChannel,
StreamChannel {
    protected final ReadableByteChannel channel;
    private volatile Thread parkedThread;
    protected volatile long bytesRead;

    protected InputStreamChannel(ReadableByteChannel channel) {
        this.channel = channel;
    }

    public final ReadableByteChannel getUnderlyingChannel() {
        return this.channel;
    }

    @Override
    public abstract int read(ByteBuffer var1) throws IOException;

    public abstract int readInt() throws IOException;

    public int readFrame() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ": readFrame not supported");
    }

    public int readFrameFragment(int fragmentSize) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ": readFrameFragment not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int readBuffered(ByteBuffer dst, ByteBuffer channelBuffer) throws IOException {
        int remaining;
        int dstLen = dst.remaining();
        if (dstLen <= (remaining = channelBuffer.remaining())) {
            if (dstLen > 0) {
                int pos = channelBuffer.position();
                channelBuffer.limit(pos + dstLen);
                try {
                    dst.put(channelBuffer);
                }
                finally {
                    channelBuffer.limit(pos + remaining);
                }
                return dstLen;
            }
            return 0;
        }
        int readBytes = 0;
        if (remaining > 0) {
            dst.put(channelBuffer);
            dstLen -= remaining;
            readBytes += remaining;
        }
        if (dstLen >= channelBuffer.limit() >>> 1 && dst.isDirect()) {
            int bufBytes = this.readIntoBufferNoWait(dst);
            if (bufBytes > 0) {
                return readBytes + bufBytes;
            }
            return readBytes > 0 ? readBytes : bufBytes;
        }
        int bufBytes = this.refillBufferBase(channelBuffer, -1, null);
        if (bufBytes > 0) {
            if (dstLen >= bufBytes) {
                dst.put(channelBuffer);
                return readBytes + bufBytes;
            }
            int pos = channelBuffer.position();
            channelBuffer.limit(pos + dstLen);
            try {
                dst.put(channelBuffer);
            }
            finally {
                channelBuffer.limit(pos + bufBytes);
            }
            return readBytes + dstLen;
        }
        return readBytes > 0 ? readBytes : bufBytes;
    }

    protected int refillBuffer(ByteBuffer channelBuffer, int tryReadBytes, String eofMessage) throws IOException {
        return this.refillBufferBase(channelBuffer, tryReadBytes, eofMessage);
    }

    protected final int refillBufferBase(ByteBuffer channelBuffer, int tryReadBytes, String eofMessage) throws IOException {
        int initPosition;
        this.resetAndCopyLeftOverBytes(channelBuffer);
        int totalReadBytes = initPosition = channelBuffer.position();
        int channelBytes = this.readIntoBuffer(channelBuffer);
        if (channelBytes > 0) {
            totalReadBytes += channelBytes;
        } else if (totalReadBytes == 0) {
            totalReadBytes = channelBytes;
        }
        while (tryReadBytes > totalReadBytes && channelBuffer.hasRemaining()) {
            int readBytes = this.readIntoBuffer(channelBuffer);
            if (readBytes < 0) {
                if (eofMessage != null) {
                    throw new EOFException(eofMessage);
                }
                if (totalReadBytes != 0) break;
                totalReadBytes = readBytes;
                break;
            }
            if (totalReadBytes < 0) {
                totalReadBytes = 0;
            }
            totalReadBytes += readBytes;
        }
        channelBuffer.flip();
        assert (totalReadBytes == channelBuffer.limit() || totalReadBytes == -1 && channelBuffer.limit() == 0) : "readBytes=" + totalReadBytes + " != limit=" + channelBuffer.limit();
        if (totalReadBytes > initPosition) {
            this.bytesRead += (long)(totalReadBytes - initPosition);
        }
        return totalReadBytes;
    }

    protected void resetAndCopyLeftOverBytes(ByteBuffer channelBuffer) {
        if (channelBuffer.hasRemaining()) {
            channelBuffer.compact();
        } else {
            channelBuffer.clear();
        }
    }

    protected int readIntoBuffer(ByteBuffer buffer) throws IOException {
        int numBytes;
        long parkedNanos = 0L;
        int numTries = 0;
        while ((numBytes = this.channel.read(buffer)) == 0 && buffer.hasRemaining()) {
            parkedNanos = ClientSharedUtils.parkThreadForAsyncOperationIfRequired(this, parkedNanos, ++numTries);
        }
        if (numBytes > 0) {
            this.bytesRead += (long)numBytes;
        }
        return numBytes;
    }

    @Override
    public final Thread getParkedThread() {
        return this.parkedThread;
    }

    @Override
    public final void setParkedThread(Thread thread) {
        this.parkedThread = thread;
    }

    @Override
    public long getParkNanosMax() {
        return 30000000000L;
    }

    protected int readIntoBufferNoWait(ByteBuffer buffer) throws IOException {
        int numBytes = this.channel.read(buffer);
        if (numBytes > 0) {
            this.bytesRead += (long)numBytes;
        }
        return numBytes;
    }

    public final long getBytesRead() {
        return this.bytesRead;
    }
}

