/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.BufferAllocator;
import java.nio.ByteBuffer;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.memory.MemoryAllocator;

public final class HeapBufferAllocator
extends BufferAllocator {
    private static final HeapBufferAllocator instance = new HeapBufferAllocator();

    public static HeapBufferAllocator instance() {
        return instance;
    }

    private HeapBufferAllocator() {
    }

    @Override
    public ByteBuffer allocate(int size, String owner) {
        return this.allocateForStorage(size);
    }

    @Override
    public ByteBuffer allocateForStorage(int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        if (MemoryAllocator.MEMORY_DEBUG_FILL_ENABLED) {
            this.fill(buffer, (byte)-91);
        }
        return buffer;
    }

    @Override
    public void clearPostAllocate(ByteBuffer buffer) {
        if (MemoryAllocator.MEMORY_DEBUG_FILL_ENABLED) {
            this.fill(buffer, (byte)0, 0, buffer.capacity());
        }
    }

    @Override
    public Object baseObject(ByteBuffer buffer) {
        return buffer.array();
    }

    @Override
    public long baseOffset(ByteBuffer buffer) {
        return Platform.BYTE_ARRAY_OFFSET + buffer.arrayOffset();
    }

    @Override
    public ByteBuffer expand(ByteBuffer buffer, int required, String owner) {
        assert (required > 0) : "expand: unexpected required = " + required;
        byte[] bytes = buffer.array();
        int currentUsed = buffer.limit();
        if (currentUsed + required > buffer.capacity()) {
            int newLength = BufferAllocator.expandedSize(currentUsed, required);
            byte[] newBytes = new byte[newLength];
            System.arraycopy(bytes, buffer.arrayOffset(), newBytes, 0, currentUsed);
            if (MemoryAllocator.MEMORY_DEBUG_FILL_ENABLED) {
                ByteBuffer buf = ByteBuffer.wrap(newBytes, currentUsed, newLength - currentUsed);
                this.fill(buf, (byte)-91);
            }
            return ByteBuffer.wrap(newBytes).order(buffer.order());
        }
        buffer.limit(currentUsed + required);
        return buffer;
    }

    @Override
    public byte[] toBytes(ByteBuffer buffer) {
        if (buffer.position() == 0 && buffer.arrayOffset() == 0 && buffer.limit() == buffer.capacity()) {
            return buffer.array();
        }
        return super.toBytes(buffer);
    }

    @Override
    public ByteBuffer fromBytesToStorage(byte[] bytes, int offset, int length) {
        return ByteBuffer.wrap(bytes, offset, length);
    }

    @Override
    public ByteBuffer transfer(ByteBuffer buffer, String owner) {
        if (buffer.hasArray()) {
            return buffer;
        }
        ByteBuffer newBuffer = super.transfer(buffer, owner);
        HeapBufferAllocator.releaseBuffer(buffer);
        return newBuffer;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public void close() {
    }
}

