/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.BufferAllocator;
import com.gemstone.gemfire.internal.shared.ClientRunTimeException;
import com.gemstone.gemfire.internal.shared.CommonRunTimeException;
import com.gemstone.gemfire.internal.shared.HeapBufferAllocator;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.gemstone.gemfire.internal.shared.StreamChannel;
import com.gemstone.gemfire.internal.shared.StringPrintWriter;
import com.gemstone.gemfire.internal.shared.SystemProperties;
import com.gemstone.gemfire.internal.shared.TCPSocketOptions;
import com.gemstone.gemfire.internal.shared.unsafe.DirectBufferAllocator;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.spark.unsafe.Platform;

public abstract class ClientSharedUtils {
    public static final String LOGGER_NAME = "snappystore";
    public static final String USE_LINK_LOCAL_ADDRESSES_PROPERTY = "net.useLinkLocalAddresses";
    private static final boolean useLinkLocalAddresses;
    public static final String USE_THRIFT_AS_DEFAULT_PROP = "thrift-default";
    private static boolean USE_THRIFT_AS_DEFAULT;
    private static final Object[] staticZeroLenObjectArray;
    private static boolean useIPv6Addresses;
    public static final String lineSeparator;
    public static final long PARK_NANOS_FOR_READ_WRITE = 100L;
    public static final int RETRIES_BEFORE_PARK = 20;
    public static final long PARK_NANOS_MAX = 30000000000L;
    private static final InetAddress localHost;
    private static CommonRunTimeException cre;
    private static boolean socketKeepAliveIdleWarningLogged;
    private static boolean socketKeepAliveIntvlWarningLogged;
    private static boolean socketKeepAliveCntWarningLogged;
    public static char[] HEX_DIGITS;
    public static char[] HEX_DIGITS_UCASE;
    private static final int SECONDS = 1000;
    private static final int MINUTES = 60000;
    private static final int HOURS = 3600000;
    private static final long DAYS = 86400000L;
    private static final long NORMAL_YEAR = 31536000000L;
    private static final long LEAP_YEAR = 31622400000L;
    private static final long FOURYEARS = 126230400000L;
    private static final long END_OF_FIRST_YEAR = 31536000000L;
    private static final long END_OF_SECOND_YEAR = 63158400000L;
    private static final long END_OF_THIRD_YEAR = 94694400000L;
    private static final int[] DAYS_IN_MONTH;
    private static final int FEBRUARY = 1;
    private static volatile Logger _DEFAULT_LOGGER;
    private static Logger logger;
    private static final Properties baseLoggerProperties;
    private static final Constructor<?> stringInternalConstructor;
    private static final int stringInternalConsVersion;
    private static final Field bigIntMagnitude;
    private static final int STRING_CONS_VER1 = 1;
    private static final int STRING_CONS_VER2 = 2;
    private static final int STRING_CONS_VER3 = 3;
    public static final TimeZone currentTimeZone;
    public static final long currentTimeZoneOffset;
    public static final String currentTZShortName;
    public static final String currentTZShortNameDST;
    private static DateTimeStatics currentDate;
    private static final long CALENDAR_REFRESH_INTERVAL = 60000L;
    public static final long MAG_MASK = 0xFFFFFFFFL;
    private static final int TOKEN_OUTSIDE = 0;
    private static final int TOKEN_INSIDE_SIMPLECOMMENT = 1;
    private static final int TOKEN_INSIDE_BRACKETED_COMMENT = 2;
    public static final ThreadLocal ALLOW_THREADCONTEXT_CLASSLOADER;

    private ClientSharedUtils() {
    }

    public static boolean isUsingThrift(boolean defaultValue) {
        return SystemProperties.getClientInstance().getBoolean(USE_THRIFT_AS_DEFAULT_PROP, defaultValue);
    }

    public static boolean isThriftDefault() {
        return USE_THRIFT_AS_DEFAULT;
    }

    public static void setThriftDefault(boolean defaultValue) {
        USE_THRIFT_AS_DEFAULT = ClientSharedUtils.isUsingThrift(defaultValue);
    }

    private static synchronized Logger DEFAULT_LOGGER() {
        Logger logger = _DEFAULT_LOGGER;
        if (logger != null) {
            return logger;
        }
        _DEFAULT_LOGGER = Logger.getLogger("");
        return _DEFAULT_LOGGER;
    }

    private static int getShiftMultipler(char unitChar) {
        switch (Character.toLowerCase(unitChar)) {
            case 'p': {
                return 50;
            }
            case 't': {
                return 40;
            }
            case 'g': {
                return 30;
            }
            case 'm': {
                return 20;
            }
            case 'k': {
                return 10;
            }
            case 'b': {
                return 0;
            }
        }
        return -1;
    }

    public static long parseMemorySize(String v, long defaultValue, int defaultShiftMultiplier) {
        int trimChars;
        if (v == null || v.length() == 0) {
            return defaultValue;
        }
        int len = v.length();
        int unitShiftMultiplier = ClientSharedUtils.getShiftMultipler(v.charAt(len - 1));
        int n = trimChars = unitShiftMultiplier >= 0 ? 1 : 0;
        if (unitShiftMultiplier == 0) {
            if (len > 1) {
                unitShiftMultiplier = ClientSharedUtils.getShiftMultipler(v.charAt(len - 2));
                if (unitShiftMultiplier > 0) {
                    trimChars = 2;
                } else {
                    unitShiftMultiplier = 0;
                }
            }
        } else if (unitShiftMultiplier < 0) {
            unitShiftMultiplier = defaultShiftMultiplier;
        }
        if (trimChars > 0) {
            v = v.substring(0, len - trimChars);
        }
        try {
            return Long.parseLong(v) << unitShiftMultiplier;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Memory size specification = " + v + ": memory size must be specified as <n>[p|t|g|m|k], where <n> is the size and and [p|t|g|m|k] specifies the units in peta|tera|giga|mega|kilobytes. No unit or with 'b' specifies in bytes. Each of these units can be followed optionally by 'b' i.e. pb|tb|gb|mb|kb.", nfe);
        }
    }

    public static boolean parseBoolean(String s) {
        if (s != null) {
            if (s.length() == 1) {
                return Integer.parseInt(s) != 0;
            }
            return Boolean.parseBoolean(s);
        }
        return false;
    }

    public static String newWrappedString(char[] chars, int offset, int size) {
        if (size >= 0) {
            try {
                switch (stringInternalConsVersion) {
                    case 1: {
                        return (String)stringInternalConstructor.newInstance(offset, size, chars);
                    }
                    case 2: {
                        if (offset == 0 && size == chars.length) {
                            return (String)stringInternalConstructor.newInstance(chars, true);
                        }
                        return new String(chars, offset, size);
                    }
                    case 3: {
                        return (String)stringInternalConstructor.newInstance(chars, offset, size, true);
                    }
                }
                return new String(chars, offset, size);
            }
            catch (Exception ex) {
                throw ClientSharedUtils.newRuntimeException("unexpected exception", ex);
            }
        }
        throw new AssertionError((Object)("unexpected size=" + size));
    }

    public static String readChars(InputStream in, boolean noecho) {
        Console console;
        if (noecho && (console = System.console()) != null) {
            return new String(console.readPassword());
        }
        StringBuilder sb = new StringBuilder();
        try {
            char c;
            int value = in.read();
            if (value != -1 && (c = (char)value) != '\n' && c != '\r') {
                sb.append(c);
            }
            while (in.available() > 0 && (value = in.read()) != -1 && (c = (char)value) != '\n' && c != '\r') {
                sb.append(c);
            }
        }
        catch (IOException ioe) {
            throw ClientSharedUtils.newRuntimeException(ioe.getMessage(), ioe);
        }
        return sb.toString();
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        if (localHost == null) {
            throw new UnknownHostException();
        }
        return localHost;
    }

    public static InetAddress getCachedLocalHost() {
        return localHost;
    }

    public static boolean preferIPv6Addresses() {
        return useIPv6Addresses;
    }

    private static InetAddress getHostAddress() throws UnknownHostException, SocketException {
        InetAddress lh = InetAddress.getLocalHost();
        if (lh.isLoopbackAddress()) {
            InetAddress addr;
            InetAddress ipv4Fallback = null;
            InetAddress ipv6Fallback = null;
            Set<InetAddress> myInterfaces = ClientSharedUtils.getMyAddresses(false);
            boolean preferIPv6 = useIPv6Addresses;
            String lhName = null;
            Iterator<InetAddress> it = myInterfaces.iterator();
            while (lhName == null && it.hasNext() && !(addr = it.next()).isLoopbackAddress() && !addr.isAnyLocalAddress()) {
                boolean ipv6 = addr instanceof Inet6Address;
                boolean ipv4 = addr instanceof Inet4Address;
                if (preferIPv6 && ipv6 || !preferIPv6 && ipv4) {
                    String addrName = ClientSharedUtils.reverseDNS(addr);
                    if (lh.isLoopbackAddress()) {
                        lh = addr;
                        lhName = addrName;
                        continue;
                    }
                    if (addrName == null) continue;
                    lh = addr;
                    lhName = addrName;
                    continue;
                }
                if (preferIPv6 && ipv4 && ipv4Fallback == null) {
                    ipv4Fallback = addr;
                    continue;
                }
                if (preferIPv6 || !ipv6 || ipv6Fallback != null) continue;
                ipv6Fallback = addr;
            }
            if (lh.isLoopbackAddress()) {
                if (ipv4Fallback != null) {
                    lh = ipv4Fallback;
                    useIPv6Addresses = false;
                } else if (ipv6Fallback != null) {
                    lh = ipv6Fallback;
                    useIPv6Addresses = true;
                }
            }
        }
        return lh;
    }

    public static Method getAnyMethod(Class<?> c, String name, Class<?> returnType, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        NoSuchMethodException firstEx = null;
        Method method = null;
        while (true) {
            try {
                method = c.getDeclaredMethod(name, parameterTypes);
                if (returnType == null || returnType != null && method.getReturnType().equals(returnType)) {
                    return method;
                }
                throw new NoSuchMethodException();
            }
            catch (NoSuchMethodException nsme) {
                if (firstEx != null) continue;
                firstEx = nsme;
                if ((c = c.getSuperclass()) != null) continue;
                throw firstEx;
            }
            break;
        }
    }

    public static Field getAnyField(Class<?> c, String name) throws NoSuchFieldException, SecurityException {
        NoSuchFieldException firstEx = null;
        while (true) {
            try {
                return c.getDeclaredField(name);
            }
            catch (NoSuchFieldException nsfe) {
                if (firstEx != null) continue;
                firstEx = nsfe;
                if ((c = c.getSuperclass()) != null) continue;
                throw firstEx;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reverseDNS(InetAddress addr) {
        byte[] addrBytes = addr.getAddress();
        StringBuilder lookupsb = new StringBuilder();
        for (int index = addrBytes.length - 1; index >= 0; --index) {
            lookupsb.append(addrBytes[index] & 0xFF).append('.');
        }
        lookupsb.append("in-addr.arpa");
        String lookup = lookupsb.toString();
        Context ctx = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            ctx = new InitialDirContext(env);
            Attributes attrs = ctx.getAttributes(lookup, new String[]{"PTR"});
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMoreElements()) {
                Attribute attr = ae.next();
                NamingEnumeration<?> vals = attr.getAll();
                while (vals.hasMoreElements()) {
                    Object elem = vals.nextElement();
                    if (!"PTR".equals(attr.getID()) || elem == null) continue;
                    String string = elem.toString();
                    return string;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public static Set<InetAddress> getMyAddresses(boolean includeLocal) throws SocketException {
        HashSet<InetAddress> result = new HashSet<InetAddress>();
        HashSet<InetAddress> locals = new HashSet<InetAddress>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            boolean faceIsUp;
            NetworkInterface face;
            block7: {
                face = interfaces.nextElement();
                faceIsUp = false;
                try {
                    faceIsUp = face.isUp();
                }
                catch (SocketException se) {
                    Logger log = ClientSharedUtils.getLogger();
                    if (log == null) break block7;
                    LogRecord lr = new LogRecord(Level.INFO, "Failed to check if network interface is up. Skipping " + face);
                    lr.setThrown(se);
                    log.log(lr);
                }
            }
            if (!faceIsUp) continue;
            Enumeration<InetAddress> addrs = face.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || !useLinkLocalAddresses && addr.isLinkLocalAddress()) {
                    locals.add(addr);
                    continue;
                }
                result.add(addr);
            }
        }
        if (result.size() == 0) {
            return locals;
        }
        if (includeLocal) {
            result.addAll(locals);
        }
        return result;
    }

    public static void setKeepAliveOptionsServer(Socket socket, InputStream socketStream) throws SocketException {
        SystemProperties props = SystemProperties.getServerInstance();
        int defaultIdle = props.getInteger("keepalive-idle", 20);
        int defaultInterval = props.getInteger("keepalive-interval", 4);
        int defaultCount = props.getInteger("keepalive-count", 10);
        ClientSharedUtils.setKeepAliveOptions(socket, socketStream, defaultIdle, defaultInterval, defaultCount);
    }

    public static void setKeepAliveOptions(Socket sock, InputStream sockStream, int keepIdle, int keepInterval, int keepCount) throws SocketException {
        Map<TCPSocketOptions, Throwable> failed;
        Logger log = ClientSharedUtils.getLogger();
        if (log != null && log.isLoggable(Level.FINE)) {
            log.fine("setKeepAliveOptions: setting keepIdle=" + keepIdle + ", keepInterval=" + keepInterval + ", keepCount=" + keepCount + " for " + sock);
        }
        sock.setKeepAlive(true);
        NativeCalls nc = NativeCalls.getInstance();
        HashMap<TCPSocketOptions, Object> optValueMap = new HashMap<TCPSocketOptions, Object>(4);
        if (keepIdle >= 0) {
            optValueMap.put(TCPSocketOptions.OPT_KEEPIDLE, keepIdle);
        }
        if (keepInterval >= 0) {
            optValueMap.put(TCPSocketOptions.OPT_KEEPINTVL, keepInterval);
        }
        if (keepCount >= 0) {
            optValueMap.put(TCPSocketOptions.OPT_KEEPCNT, keepCount);
        }
        try {
            failed = nc.setSocketOptions(sock, sockStream, optValueMap);
        }
        catch (UnsupportedOperationException e) {
            if (!socketKeepAliveIdleWarningLogged) {
                socketKeepAliveIdleWarningLogged = true;
                if (log != null) {
                    log.warning("Failed to set options " + optValueMap + " on socket: " + e);
                    if (log.isLoggable(Level.FINE)) {
                        LogRecord lr = new LogRecord(Level.FINE, "Exception trace:");
                        lr.setThrown(e);
                        log.log(lr);
                    }
                }
            }
            return;
        }
        if (failed != null && failed.size() > 0) {
            if (log != null) {
                for (Map.Entry<TCPSocketOptions, Throwable> e : failed.entrySet()) {
                    TCPSocketOptions opt = e.getKey();
                    Throwable ex = e.getValue();
                    int doLogWarning = 0;
                    switch (opt) {
                        case OPT_KEEPIDLE: {
                            if (ex instanceof UnsupportedOperationException) {
                                if (socketKeepAliveIdleWarningLogged) break;
                                socketKeepAliveIdleWarningLogged = true;
                                doLogWarning = 1;
                                break;
                            }
                            doLogWarning = 1;
                            break;
                        }
                        case OPT_KEEPINTVL: {
                            if (ex instanceof UnsupportedOperationException) {
                                if (!socketKeepAliveIntvlWarningLogged) {
                                    socketKeepAliveIntvlWarningLogged = true;
                                    doLogWarning = 2;
                                }
                            } else {
                                doLogWarning = 2;
                            }
                            if (keepInterval != 4) break;
                            doLogWarning = 0;
                            break;
                        }
                        case OPT_KEEPCNT: {
                            if (ex instanceof UnsupportedOperationException) {
                                if (!socketKeepAliveCntWarningLogged) {
                                    socketKeepAliveCntWarningLogged = true;
                                    doLogWarning = 2;
                                }
                            } else {
                                doLogWarning = 2;
                            }
                            if (keepCount != 10) break;
                            doLogWarning = 0;
                        }
                    }
                    if (doLogWarning <= 0) continue;
                    if (doLogWarning == 1) {
                        log.warning("Failed to set " + (Object)((Object)opt) + " on socket: " + ex);
                    } else if (log != ClientSharedUtils.DEFAULT_LOGGER()) {
                        log.info("Failed to set " + (Object)((Object)opt) + " on socket: " + ex.getMessage());
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    LogRecord lr = new LogRecord(Level.FINE, "Exception trace:");
                    lr.setThrown(ex);
                    log.log(lr);
                }
            }
        } else if (log != null && log.isLoggable(Level.FINE)) {
            log.fine("setKeepAliveOptions(): successful for " + sock);
        }
    }

    public static void getStackTrace(Throwable t, StringBuilder sb, String lineSep) {
        t.printStackTrace(new StringPrintWriter(sb, lineSep));
    }

    public static void dumpThreadStack(ThreadInfo tInfo, StringBuilder msg, String lineSeparator) {
        msg.append('\"').append(tInfo.getThreadName()).append('\"').append(" Id=").append(tInfo.getThreadId()).append(' ').append((Object)tInfo.getThreadState());
        if (tInfo.getLockName() != null) {
            msg.append(" on ").append(tInfo.getLockName());
        }
        if (tInfo.getLockOwnerName() != null) {
            msg.append(" owned by \"").append(tInfo.getLockOwnerName()).append("\" Id=").append(tInfo.getLockOwnerId());
        }
        if (tInfo.isSuspended()) {
            msg.append(" (suspended)");
        }
        if (tInfo.isInNative()) {
            msg.append(" (in native)");
        }
        msg.append(lineSeparator);
        StackTraceElement[] stackTrace = tInfo.getStackTrace();
        for (int index = 0; index < stackTrace.length; ++index) {
            msg.append("\tat ").append(stackTrace[index].toString()).append(lineSeparator);
            if (index == 0 && tInfo.getLockInfo() != null) {
                Thread.State ts = tInfo.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        msg.append("\t-  blocked on ").append(tInfo.getLockInfo()).append(lineSeparator);
                        break;
                    }
                    case WAITING: {
                        msg.append("\t-  waiting on ").append(tInfo.getLockInfo()).append(lineSeparator);
                        break;
                    }
                    case TIMED_WAITING: {
                        msg.append("\t-  waiting on ").append(tInfo.getLockInfo()).append(lineSeparator);
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : tInfo.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != index) continue;
                msg.append("\t-  locked ").append(lockInfo).append(lineSeparator);
            }
        }
        LockInfo[] locks = tInfo.getLockedSynchronizers();
        if (locks.length > 0) {
            msg.append(lineSeparator).append("\tNumber of locked synchronizers = ").append(locks.length).append(lineSeparator);
            for (LockInfo lockInfo : locks) {
                msg.append("\t- ").append(lockInfo).append(lineSeparator);
            }
        }
        msg.append(lineSeparator);
    }

    public static Object[] getZeroLenObjectArray() {
        return staticZeroLenObjectArray;
    }

    public static void formatDate(long currentTimeInMillis, StringBuilder sb) {
        try {
            int newTzOffset;
            DateTimeStatics dts = currentDate;
            int tzOffset = dts.tzOffset;
            String tzDisplayName = dts.tzDisplayName;
            if (currentTimeInMillis > dts.lastUpdatedTime + 60000L && tzOffset != (newTzOffset = currentTimeZone.getOffset(currentTimeInMillis))) {
                tzOffset = newTzOffset;
                tzDisplayName = currentTimeZoneOffset == (long)tzOffset ? currentTZShortName : currentTZShortNameDST;
                currentDate = new DateTimeStatics(tzOffset, currentTimeInMillis, tzDisplayName);
            }
            ClientSharedUtils.formatDate(currentTimeInMillis, tzOffset, sb);
            sb.append(' ').append(tzDisplayName);
        }
        catch (Exception e1) {
            try {
                sb.append(new Date(currentTimeInMillis).toString());
            }
            catch (Exception e2) {
                try {
                    sb.append(Long.toString(currentTimeInMillis));
                }
                catch (Exception e3) {
                    sb.append("timestampFormatFailed");
                }
            }
        }
    }

    public static void formatDate(long time, int tzOffset, StringBuilder sb) {
        int daysInMonth;
        long leftover;
        boolean leapYear = false;
        int year = (int)((time += (long)tzOffset) / 126230400000L) * 4;
        time = leftover = time % 126230400000L;
        year += 1970;
        if (leftover >= 31536000000L) {
            ++year;
            time -= 31536000000L;
        }
        if (leftover >= 63158400000L) {
            ++year;
            time -= 31536000000L;
        }
        if (leftover >= 94694400000L) {
            ++year;
            time -= 31622400000L;
        }
        if (year % 4 == 0) {
            if (year % 100 == 0) {
                if (year % 400 == 0) {
                    leapYear = true;
                }
            } else {
                leapYear = true;
            }
        }
        int days = (int)(time / 86400000L) + 1;
        int month = 1;
        for (int i = 0; i < DAYS_IN_MONTH.length && days > (daysInMonth = leapYear && i == 1 ? 29 : DAYS_IN_MONTH[i]); days -= daysInMonth, ++i) {
            ++month;
        }
        int remaining = (int)(time % 86400000L);
        int hours = remaining / 3600000;
        int minutes = (remaining %= 3600000) / 60000;
        int seconds = (remaining %= 60000) / 1000;
        remaining %= 1000;
        sb.append(year).append('/');
        ClientSharedUtils.twoDigits(month, sb);
        sb.append('/');
        ClientSharedUtils.twoDigits(days, sb);
        sb.append(' ');
        ClientSharedUtils.twoDigits(hours, sb);
        sb.append(':');
        ClientSharedUtils.twoDigits(minutes, sb);
        sb.append(':');
        ClientSharedUtils.twoDigits(seconds, sb);
        sb.append('.');
        ClientSharedUtils.threeDigits(remaining, sb);
    }

    private static void twoDigits(int val, StringBuilder sb) {
        if (val < 10) {
            sb.append('0').append(val);
        } else {
            sb.append(val);
        }
    }

    private static void threeDigits(int val, StringBuilder sb) {
        if (val < 10) {
            sb.append("00").append(val);
        } else if (val < 100) {
            sb.append('0').append(val);
        } else {
            sb.append(val);
        }
    }

    public static String toHexString(byte[] data, int offset, int length) {
        char[] chars = ClientSharedUtils.toHexChars(data, offset, length);
        return ClientSharedUtils.newWrappedString(chars, 0, chars.length);
    }

    public static String toHexStringUpperCase(byte[] data, int offset, int length) {
        char[] chars = new char[length << 1];
        int end = offset + length;
        int index = -1;
        while (offset < end) {
            byte b = data[offset];
            int highByte = (b & 0xF0) >>> 4;
            int lowByte = b & 0xF;
            chars[++index] = HEX_DIGITS_UCASE[highByte];
            chars[++index] = HEX_DIGITS_UCASE[lowByte];
            ++offset;
        }
        return ClientSharedUtils.newWrappedString(chars, 0, chars.length);
    }

    public static char[] toHexChars(byte[] data, int offset, int length) {
        char[] chars = new char[length << 1];
        int end = offset + length;
        int index = 0;
        while (offset < end) {
            index = ClientSharedUtils.toHexChars(data[offset], chars, index);
            ++offset;
        }
        return chars;
    }

    public static String toHexString(ByteBuffer buffer) {
        int pos;
        if (ClientSharedUtils.wrapsFullArray(buffer)) {
            byte[] bytes = buffer.array();
            return ClientSharedUtils.toHexString(bytes, 0, bytes.length);
        }
        int limit = buffer.limit();
        char[] chars = new char[limit - pos << 1];
        int index = 0;
        for (pos = buffer.position(); pos < limit; ++pos) {
            byte b = buffer.get(pos);
            index = ClientSharedUtils.toHexChars(b, chars, index);
        }
        return ClientSharedUtils.newWrappedString(chars, 0, chars.length);
    }

    public static boolean wrapsFullArray(ByteBuffer byteBuffer) {
        return byteBuffer.hasArray() && byteBuffer.position() == 0 && byteBuffer.arrayOffset() == 0 && byteBuffer.remaining() == byteBuffer.capacity();
    }

    public static String toString(ByteBuffer buffer) {
        if (buffer != null) {
            StringBuilder sb = new StringBuilder();
            int len = buffer.remaining();
            for (int i = buffer.position(); i < len; ++i) {
                if (i > 131072) {
                    sb.append(" ...");
                    break;
                }
                sb.append(buffer.get(i)).append(", ");
            }
            return sb.toString();
        }
        return "null";
    }

    public static void toHexString(ByteBuffer buffer, StringBuilder sb) {
        if (ClientSharedUtils.wrapsFullArray(buffer)) {
            byte[] bytes = buffer.array();
            sb.append(ClientSharedUtils.toHexChars(bytes, 0, bytes.length));
        } else {
            int limit = buffer.limit();
            for (int pos = buffer.position(); pos < limit; ++pos) {
                byte b = buffer.get(pos);
                ClientSharedUtils.toHexChars(b, sb);
            }
        }
    }

    static int toHexChars(byte b, char[] chars, int index) {
        int highByte = (b & 0xF0) >>> 4;
        int lowByte = b & 0xF;
        chars[index] = HEX_DIGITS[highByte];
        chars[++index] = HEX_DIGITS[lowByte];
        return index + 1;
    }

    static void toHexChars(byte b, StringBuilder sb) {
        int highByte = (b & 0xF0) >>> 4;
        int lowByte = b & 0xF;
        sb.append(HEX_DIGITS[highByte]);
        sb.append(HEX_DIGITS[lowByte]);
    }

    public static byte[] fromHexString(String s, int offset, int length) {
        byte[] bytes;
        int j = 0;
        if (length % 2 != 0) {
            bytes = new byte[length + 1 >>> 1];
            int lowByte = ClientSharedUtils.hexDigitToBinary(s.charAt(offset));
            bytes[j++] = (byte)(lowByte & 0xF);
            ++offset;
        } else {
            bytes = new byte[length >>> 1];
        }
        int end = offset + length;
        while (offset < end) {
            int highByte = ClientSharedUtils.hexDigitToBinary(s.charAt(offset++));
            int lowByte = ClientSharedUtils.hexDigitToBinary(s.charAt(offset++));
            bytes[j++] = (byte)(highByte << 4 & 0xF0 | lowByte & 0xF);
        }
        return bytes;
    }

    static final int hexDigitToBinary(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Illegal hexadecimal char=" + c);
    }

    public static void setCommonRuntimeException(CommonRunTimeException e) {
        cre = e;
    }

    public static RuntimeException newRuntimeException(String message, Throwable cause) {
        return cre.newRunTimeException(message, cause);
    }

    public static Path getProductJarsDirectory(Class<?> c) throws IOException {
        URL jarURL;
        CodeSource cs = c.getProtectionDomain().getCodeSource();
        URL uRL = jarURL = cs != null ? cs.getLocation() : null;
        if (jarURL != null) {
            return Paths.get(URLDecoder.decode(jarURL.getFile(), "UTF-8"), new String[0]).getParent().toRealPath(LinkOption.NOFOLLOW_LINKS);
        }
        String productHome = System.getenv("SNAPPY_HOME");
        if (productHome == null) {
            productHome = System.getenv("SPARK_HOME");
        }
        if (productHome != null) {
            return Paths.get(productHome, "jars").toRealPath(LinkOption.NOFOLLOW_LINKS);
        }
        throw new IllegalStateException("Unable to locate product install location. Set SNAPPY_HOME or SPARK_HOME explicitly if not using the standard scripts.");
    }

    public static Level convertToJavaLogLevel(org.apache.log4j.Level log4jLevel) {
        Level javaLevel = Level.CONFIG;
        if (log4jLevel != null) {
            if (log4jLevel == org.apache.log4j.Level.ERROR || log4jLevel == org.apache.log4j.Level.FATAL) {
                javaLevel = Level.SEVERE;
            } else if (log4jLevel == org.apache.log4j.Level.WARN) {
                javaLevel = Level.WARNING;
            } else if (log4jLevel == org.apache.log4j.Level.INFO) {
                javaLevel = Level.INFO;
            } else if (log4jLevel == org.apache.log4j.Level.DEBUG) {
                javaLevel = Level.FINE;
            } else if (log4jLevel == org.apache.log4j.Level.TRACE) {
                javaLevel = Level.FINEST;
            } else if (log4jLevel == org.apache.log4j.Level.ALL) {
                javaLevel = Level.ALL;
            } else if (log4jLevel == org.apache.log4j.Level.OFF) {
                javaLevel = Level.OFF;
            }
        }
        return javaLevel;
    }

    public static org.apache.log4j.Level convertToLog4LogLevel(String level) throws IllegalArgumentException {
        org.apache.log4j.Level logLevel = null;
        if (level != null && !level.isEmpty() && (logLevel = org.apache.log4j.Level.toLevel((String)(level = level.trim().toUpperCase(Locale.ENGLISH)), null)) == null) {
            logLevel = ClientSharedUtils.convertToLog4LogLevel(Level.parse(level));
        }
        return logLevel;
    }

    public static org.apache.log4j.Level convertToLog4LogLevel(Level level) {
        org.apache.log4j.Level log4Level = org.apache.log4j.Level.INFO;
        if (level == Level.SEVERE) {
            log4Level = org.apache.log4j.Level.FATAL;
        } else if (level == Level.WARNING) {
            log4Level = org.apache.log4j.Level.WARN;
        } else if (level == Level.INFO || level == Level.CONFIG) {
            log4Level = org.apache.log4j.Level.INFO;
        } else if (level == Level.FINE) {
            log4Level = org.apache.log4j.Level.DEBUG;
        } else if (level == Level.FINER || level == Level.FINEST) {
            log4Level = org.apache.log4j.Level.TRACE;
        } else if (level == Level.ALL) {
            log4Level = org.apache.log4j.Level.ALL;
        } else if (level == Level.OFF) {
            log4Level = org.apache.log4j.Level.OFF;
        } else if ("ERROR".equalsIgnoreCase(level.getName())) {
            log4Level = org.apache.log4j.Level.ERROR;
        }
        return log4Level;
    }

    public static void initLog4j(String logFile, org.apache.log4j.Level level) throws IOException {
        ClientSharedUtils.initLog4j(logFile, null, level);
    }

    public static String getLog4jLogFile(org.apache.log4j.Logger rootLogger) {
        if (rootLogger != null) {
            Enumeration e = rootLogger.getAllAppenders();
            while (e.hasMoreElements()) {
                Appender appender = (Appender)e.nextElement();
                if (!(appender instanceof FileAppender)) continue;
                return ((FileAppender)appender).getFile();
            }
        }
        return null;
    }

    public static Properties getLog4jConfProperties(String snappyHome) throws IOException {
        Path confFile = Paths.get(snappyHome, "conf", "log4j.properties");
        if (Files.isReadable(confFile)) {
            try (InputStream in = Files.newInputStream(confFile, new OpenOption[0]);){
                Properties props = new Properties();
                props.load(in);
                Properties properties = props;
                return properties;
            }
        }
        return null;
    }

    private static Properties getLog4jProperties(String logFile, org.apache.log4j.Level level) throws IOException {
        Properties props;
        String snappyHome = NativeCalls.getInstance().getEnvironment("SNAPPY_HOME");
        if (snappyHome != null && (props = ClientSharedUtils.getLog4jConfProperties(snappyHome)) != null) {
            return props;
        }
        props = new Properties();
        try (InputStream in = ClientSharedUtils.class.getResourceAsStream("/store-log4j.properties");){
            props.load(in);
        }
        if (level != null) {
            if (logFile != null) {
                props.setProperty("log4j.rootCategory", level + ", file");
            } else {
                props.setProperty("log4j.rootCategory", level + ", console");
            }
        }
        if (logFile != null) {
            props.setProperty("log4j.appender.file.file", logFile);
        }
        in = ClientSharedUtils.class.getResourceAsStream("/log4j.properties");
        var5_5 = null;
        try {
            if (in != null) {
                Properties setProps = new Properties();
                setProps.load(in);
                props.putAll((Map<?, ?>)setProps);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        return props;
    }

    public static synchronized void initLog4j(String logFile, Properties userProps, org.apache.log4j.Level level) throws IOException {
        Properties props;
        if (baseLoggerProperties.isEmpty() || logFile != null) {
            props = ClientSharedUtils.getLog4jProperties(logFile, level);
            baseLoggerProperties.clear();
            baseLoggerProperties.putAll((Map<?, ?>)props);
        } else {
            props = (Properties)baseLoggerProperties.clone();
        }
        if (userProps != null) {
            props.putAll((Map<?, ?>)userProps);
        }
        LogManager.resetConfiguration();
        PropertyConfigurator.configure((Properties)props);
        String rootLogLevel = props.getProperty("log4j.rootCategory");
        if (rootLogLevel != null) {
            int idx = rootLogLevel.indexOf(44);
            if (idx != -1) {
                rootLogLevel = rootLogLevel.substring(0, idx).trim();
            }
            LogManager.getRootLogger().setLevel(org.apache.log4j.Level.toLevel((String)rootLogLevel));
        }
    }

    public static synchronized void initLogger(String loggerName, String logFile, boolean initLog4j, boolean skipIfInitialized, Level level, Handler handler) {
        Logger log = logger;
        if (skipIfInitialized && log != null && log != ClientSharedUtils.DEFAULT_LOGGER()) {
            return;
        }
        ClientSharedUtils.clearLogger();
        if (initLog4j) {
            try {
                ClientSharedUtils.initLog4j(logFile, ClientSharedUtils.convertToLog4LogLevel(level));
            }
            catch (IOException ioe) {
                throw ClientSharedUtils.newRuntimeException(ioe.getMessage(), ioe);
            }
        }
        log = Logger.getLogger(loggerName);
        log.addHandler(handler);
        log.setLevel(level);
        log.setUseParentHandlers(false);
        logger = log;
    }

    public static synchronized void setLogger(Logger log) {
        ClientSharedUtils.clearLogger();
        logger = log;
    }

    public static boolean isLoggerInitialized() {
        Logger log = logger;
        return log != null && log != ClientSharedUtils.DEFAULT_LOGGER();
    }

    public static Logger getLogger() {
        Logger log = logger;
        if (log == null) {
            logger = log = ClientSharedUtils.DEFAULT_LOGGER();
        }
        return log;
    }

    public static int[] getBigIntInternalMagnitude(BigInteger val) {
        if (bigIntMagnitude != null) {
            try {
                return (int[])bigIntMagnitude.get(val);
            }
            catch (Exception ex) {
                throw ClientSharedUtils.newRuntimeException("unexpected exception", ex);
            }
        }
        return null;
    }

    public static int getBigIntMagnitudeSizeInBytes(int[] magnitude) {
        int size_1 = magnitude.length - 1;
        if (size_1 >= 0) {
            int numBytes = size_1 << 2;
            long firstInt = (long)magnitude[0] & 0xFFFFFFFFL;
            return numBytes + ClientSharedUtils.numBytesWithoutZeros(firstInt);
        }
        return 0;
    }

    public static final int numBytesWithoutZeros(long value) {
        if (value <= 255L) {
            return 1;
        }
        if (value <= 65535L) {
            return 2;
        }
        if (value <= 0xFFFFFFL) {
            return 3;
        }
        return 4;
    }

    public static void clear() {
        ClientSharedUtils.clearLogger();
        socketKeepAliveIdleWarningLogged = false;
        socketKeepAliveIntvlWarningLogged = false;
        socketKeepAliveCntWarningLogged = false;
    }

    private static synchronized void clearLogger() {
        Logger log = logger;
        if (log != null && log != ClientSharedUtils.DEFAULT_LOGGER()) {
            for (Handler h : log.getHandlers()) {
                log.removeHandler(h);
                try {
                    h.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        logger = null;
        baseLoggerProperties.clear();
    }

    public static void objectStringNonRecursive(Object obj, StringBuilder sb) {
        if (obj instanceof Object[]) {
            sb.append('(');
            boolean first = true;
            for (Object o : (Object[])obj) {
                if (!first) {
                    sb.append(',');
                    sb.append(o);
                    continue;
                }
                first = false;
                ClientSharedUtils.objectStringWithBytes(o, sb);
            }
            sb.append(')');
        } else {
            ClientSharedUtils.objectStringWithBytes(obj, sb);
        }
    }

    public static void objectString(Object obj, StringBuilder sb) {
        if (obj instanceof Object[]) {
            sb.append('(');
            boolean first = true;
            for (Object o : (Object[])obj) {
                if (!first) {
                    sb.append(',');
                } else {
                    first = false;
                }
                ClientSharedUtils.objectString(o, sb);
            }
            sb.append(')');
        } else {
            ClientSharedUtils.objectStringWithBytes(obj, sb);
        }
    }

    private static void objectStringWithBytes(Object obj, StringBuilder sb) {
        if (obj instanceof byte[]) {
            sb.append('(');
            boolean first = true;
            byte[] bytes = (byte[])obj;
            int numBytes = 0;
            for (byte b : bytes) {
                if (!first) {
                    sb.append(',');
                } else {
                    first = false;
                }
                sb.append(b);
                if (numBytes++ < 5000 || numBytes >= bytes.length) continue;
                sb.append(" ...");
                break;
            }
            sb.append(')');
        } else {
            sb.append(obj);
        }
    }

    public static byte[] toBytes(ByteBuffer buffer) {
        int bufferSize = buffer.remaining();
        return ClientSharedUtils.toBytes(buffer, bufferSize, bufferSize);
    }

    public static byte[] toBytes(ByteBuffer buffer, int bufferSize, int length) {
        if (length >= bufferSize && ClientSharedUtils.wrapsFullArray(buffer)) {
            return buffer.array();
        }
        return ClientSharedUtils.toBytesCopy(buffer, bufferSize, length);
    }

    public static byte[] toBytesCopy(ByteBuffer buffer, int bufferSize, int length) {
        int numBytes = Math.min(bufferSize, length);
        byte[] bytes = new byte[numBytes];
        int initPosition = buffer.position();
        buffer.get(bytes, 0, numBytes);
        buffer.position(initPosition);
        return bytes;
    }

    private static String isolateAnyInitialIdentifier(String sql) {
        char ch;
        int idx;
        for (idx = 0; idx < sql.length() && (Character.isLetter(ch = sql.charAt(idx)) || ch == '<'); ++idx) {
        }
        return idx > 0 ? sql.substring(0, idx) : sql;
    }

    public static String getStatementToken(String sql, int idx) {
        int bracketNesting = 0;
        int state = 0;
        String tokenFound = null;
        int sqlLen = sql.length();
        block17: while (idx < sqlLen && tokenFound == null) {
            char next = sql.charAt(idx);
            switch (state) {
                case 0: {
                    switch (next) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case '(': 
                        case '=': 
                        case '?': 
                        case '{': {
                            ++idx;
                            continue block17;
                        }
                        case '/': {
                            if (idx == sql.length() - 1) {
                                tokenFound = "/";
                            } else if (sql.charAt(idx + 1) == '*') {
                                state = 2;
                                ++bracketNesting;
                                ++idx;
                            }
                            ++idx;
                            continue block17;
                        }
                        case '-': {
                            if (idx == sql.length() - 1) {
                                tokenFound = "/";
                            } else if (sql.charAt(idx + 1) == '-') {
                                state = 1;
                                ++idx;
                            }
                            ++idx;
                            continue block17;
                        }
                    }
                    tokenFound = ClientSharedUtils.isolateAnyInitialIdentifier(sql.substring(idx));
                    continue block17;
                }
                case 1: {
                    switch (next) {
                        case '\n': 
                        case '\f': 
                        case '\r': {
                            state = 0;
                            ++idx;
                            continue block17;
                        }
                    }
                    ++idx;
                    continue block17;
                }
                case 2: {
                    switch (next) {
                        case '/': {
                            if (idx != sql.length() - 1 && sql.charAt(idx + 1) == '*') {
                                ++bracketNesting;
                                ++idx;
                            }
                            ++idx;
                            continue block17;
                        }
                        case '*': {
                            if (idx != sql.length() - 1 && sql.charAt(idx + 1) == '/' && --bracketNesting == 0) {
                                state = 0;
                                ++idx;
                            }
                            ++idx;
                            continue block17;
                        }
                    }
                    ++idx;
                    continue block17;
                }
            }
        }
        return tokenFound;
    }

    public static boolean equalBuffers(byte[] bytes, ByteBuffer buffer) {
        int len = bytes.length;
        if (len != buffer.remaining()) {
            return false;
        }
        int pos = buffer.position();
        int endPos = pos + len;
        boolean sameOrder = ByteOrder.nativeOrder() == buffer.order();
        int endRound8Pos = len % 8 != 0 ? endPos - 8 : endPos;
        long indexPos = Platform.BYTE_ARRAY_OFFSET;
        while (pos < endRound8Pos) {
            long s = Platform.getLong((Object)bytes, (long)indexPos);
            long v = buffer.getLong(pos);
            if (sameOrder ? s != v : s != Long.reverseBytes(v)) {
                return false;
            }
            pos += 8;
            indexPos += 8L;
        }
        while (pos < endPos) {
            if (Platform.getByte((Object)bytes, (long)indexPos) != buffer.get(pos)) {
                return false;
            }
            ++pos;
            ++indexPos;
        }
        return true;
    }

    public static ByteBuffer ensureCapacity(ByteBuffer buffer, int newLength, boolean useDirectBuffer, String owner) {
        if (newLength <= buffer.capacity()) {
            return buffer;
        }
        BufferAllocator allocator = useDirectBuffer ? DirectBufferAllocator.instance() : HeapBufferAllocator.instance();
        ByteBuffer newBuffer = allocator.allocateWithFallback(newLength, owner);
        newBuffer.order(buffer.order());
        buffer.flip();
        newBuffer.put(buffer);
        allocator.release(buffer);
        return newBuffer;
    }

    public static int getUTFLength(String str, int strLen) {
        int utfLen = strLen;
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') continue;
            if (c > '\u07ff') {
                utfLen += 2;
                continue;
            }
            ++utfLen;
        }
        return utfLen;
    }

    public static boolean isSocketToSameHost(Channel channel) {
        try {
            if (channel instanceof SocketChannel) {
                SocketChannel socketChannel = (SocketChannel)channel;
                return ClientSharedUtils.isSocketToSameHost(socketChannel.getLocalAddress(), socketChannel.getRemoteAddress());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isSocketToSameHost(SocketAddress localSockAddress, SocketAddress remoteSockAddress) {
        if (localSockAddress instanceof InetSocketAddress && remoteSockAddress instanceof InetSocketAddress) {
            InetAddress localAddress = ((InetSocketAddress)localSockAddress).getAddress();
            return localAddress != null && localAddress.equals(((InetSocketAddress)remoteSockAddress).getAddress());
        }
        return false;
    }

    public static long parkThreadForAsyncOperationIfRequired(StreamChannel channel, long parkedNanos, int numTries) throws SocketTimeoutException {
        if (numTries % 20 == 0) {
            if (channel != null) {
                channel.setParkedThread(Thread.currentThread());
            }
            LockSupport.parkNanos(100L);
            if (channel != null) {
                channel.setParkedThread(null);
                if ((parkedNanos += 100L) > channel.getParkNanosMax()) {
                    throw new SocketTimeoutException("Connection operation timed out.");
                }
            }
        }
        return parkedNanos;
    }

    static {
        Field mag;
        useLinkLocalAddresses = SystemProperties.getClientInstance().getBoolean(USE_LINK_LOCAL_ADDRESSES_PROPERTY, false);
        USE_THRIFT_AS_DEFAULT = ClientSharedUtils.isUsingThrift(true);
        staticZeroLenObjectArray = new Object[0];
        useIPv6Addresses = !Boolean.getBoolean("java.net.preferIPv4Stack") && Boolean.getBoolean("java.net.preferIPv6Addresses");
        lineSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("line.separator");
            }
        });
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        HEX_DIGITS_UCASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        DAYS_IN_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        baseLoggerProperties = new Properties();
        InetAddress lh = null;
        try {
            lh = ClientSharedUtils.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            // empty catch block
        }
        localHost = lh;
        cre = new ClientRunTimeException();
        Constructor constructor = null;
        int version = 0;
        try {
            constructor = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            constructor.setAccessible(true);
            version = 2;
        }
        catch (Exception e1) {
            try {
                constructor = String.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class);
                constructor.setAccessible(true);
                version = 1;
            }
            catch (Exception e2) {
                try {
                    constructor = String.class.getDeclaredConstructor(char[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    constructor.setAccessible(true);
                    version = 3;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        stringInternalConstructor = constructor;
        stringInternalConsVersion = version;
        try {
            mag = BigInteger.class.getDeclaredField("mag");
            mag.setAccessible(true);
            if (mag.getType() != int[].class) {
                mag = null;
            }
        }
        catch (Exception e) {
            try {
                mag = BigInteger.class.getDeclaredField("words");
                mag.setAccessible(true);
                if (mag.getType() != int[].class) {
                    mag = null;
                }
            }
            catch (Exception ex) {
                mag = null;
            }
        }
        bigIntMagnitude = mag;
        currentTimeZone = TimeZone.getDefault();
        currentTimeZoneOffset = currentTimeZone.getRawOffset();
        currentTZShortName = currentTimeZone.getDisplayName(false, 0);
        currentTZShortNameDST = currentTimeZone.getDisplayName(true, 0);
        currentDate = new DateTimeStatics(System.currentTimeMillis());
        ALLOW_THREADCONTEXT_CLASSLOADER = new ThreadLocal();
    }

    public static final class ThreadContextObjectInputStream
    extends ObjectInputStream {
        protected ThreadContextObjectInputStream() throws IOException, SecurityException {
        }

        public ThreadContextObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return super.resolveClass(desc);
            }
            catch (ClassNotFoundException cnfe) {
                Object allowTCCL = ALLOW_THREADCONTEXT_CLASSLOADER.get();
                if (allowTCCL == null || !Boolean.TRUE.equals(allowTCCL)) {
                    throw cnfe;
                }
                return Thread.currentThread().getContextClassLoader().loadClass(desc.getName());
            }
        }
    }

    private static final class DateTimeStatics {
        final int tzOffset;
        final long lastUpdatedTime;
        final String tzDisplayName;

        DateTimeStatics(long currentTime) {
            this(currentTimeZone.getOffset(currentTime), currentTime);
        }

        DateTimeStatics(int tzOffset, long currentTime) {
            this(tzOffset, currentTime, currentTimeZoneOffset == (long)tzOffset ? currentTZShortName : currentTZShortNameDST);
        }

        DateTimeStatics(int tzOffset, long currentTime, String tzDisplayName) {
            this.tzOffset = tzOffset;
            this.lastUpdatedTime = currentTime;
            this.tzDisplayName = tzDisplayName;
        }
    }
}

