/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.unsafe.FreeMemory;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import java.io.Closeable;
import java.nio.ByteBuffer;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.memory.MemoryAllocator;

public abstract class BufferAllocator
implements Closeable {
    public static final String STORE_DATA_FRAME_OUTPUT = "STORE_DATA_FRAME_OUTPUT";
    public static final String EXECUTION = "EXECUTION";

    public abstract ByteBuffer allocate(int var1, String var2);

    public ByteBuffer allocateWithFallback(int size, String owner) {
        return this.allocate(size, owner);
    }

    public abstract ByteBuffer allocateForStorage(int var1);

    public abstract void clearPostAllocate(ByteBuffer var1);

    public final void fill(ByteBuffer buffer, byte b, int position, int numBytes) {
        Platform.setMemory((Object)this.baseObject(buffer), (long)(this.baseOffset(buffer) + (long)position), (long)numBytes, (byte)b);
    }

    public final void fill(ByteBuffer buffer, byte b) {
        int position = buffer.position();
        this.fill(buffer, b, position, buffer.capacity() - position);
    }

    public abstract Object baseObject(ByteBuffer var1);

    public abstract long baseOffset(ByteBuffer var1);

    public abstract ByteBuffer expand(ByteBuffer var1, int var2, String var3);

    public byte[] toBytes(ByteBuffer buffer) {
        int bufferSize = buffer.remaining();
        return ClientSharedUtils.toBytesCopy(buffer, bufferSize, bufferSize);
    }

    public abstract ByteBuffer fromBytesToStorage(byte[] var1, int var2, int var3);

    public ByteBuffer transfer(ByteBuffer buffer, String owner) {
        int position = buffer.position();
        ByteBuffer newBuffer = this.allocate(buffer.limit(), owner);
        buffer.rewind();
        newBuffer.order(buffer.order());
        newBuffer.put(buffer);
        buffer.position(position);
        newBuffer.position(position);
        return newBuffer;
    }

    public final void release(ByteBuffer buffer) {
        BufferAllocator.releaseBuffer(buffer);
    }

    public static boolean releaseBuffer(ByteBuffer buffer) {
        boolean hasArray = buffer.hasArray();
        if (MemoryAllocator.MEMORY_DEBUG_FILL_ENABLED) {
            long baseOffset;
            byte[] baseObject;
            if (hasArray) {
                baseObject = buffer.array();
                baseOffset = Platform.BYTE_ARRAY_OFFSET + buffer.arrayOffset();
            } else {
                baseObject = null;
                baseOffset = UnsafeHolder.getDirectBufferAddress(buffer);
            }
            Platform.setMemory((Object)baseObject, (long)baseOffset, (long)buffer.capacity(), (byte)90);
        }
        if (hasArray) {
            buffer.rewind().limit(0);
            return false;
        }
        UnsafeHolder.releaseDirectBuffer(buffer);
        return true;
    }

    public abstract boolean isDirect();

    public boolean isManagedDirect() {
        return false;
    }

    public ByteBuffer allocateCustom(int size, FreeMemory.Factory factory) {
        throw new UnsupportedOperationException("Not supported for " + this.toString());
    }

    @Override
    public abstract void close();

    protected static int expandedSize(int currentUsed, int required) {
        long minRequired = (long)currentUsed + (long)required;
        int newLength = (int)Math.min(Math.max((long)(currentUsed * 3 >>> 1), minRequired), 0x7FFFFFFEL);
        if ((long)newLength >= minRequired) {
            return newLength;
        }
        throw new IndexOutOfBoundsException("Cannot allocate more than " + newLength + " bytes but required " + minRequired);
    }
}

