/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.concurrent;

import com.gemstone.gemfire.internal.concurrent.ConcurrentTHashSegment;
import com.gemstone.gemfire.internal.concurrent.MapCallback;
import com.gemstone.gemfire.internal.concurrent.THashParameters;
import com.gemstone.gemfire.internal.size.SingleObjectSizer;
import com.gemstone.gnu.trove.HashingStats;
import com.gemstone.gnu.trove.PrimeFinder;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TIntArrayList;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.gemstone.gnu.trove.TObjectProcedure;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrentTHashSet<T>
extends THashParameters
implements Set<T> {
    public static final int DEFAULT_CONCURRENCY = 16;
    protected final ConcurrentTHashSegment<T>[] segments;
    protected final int numSegments;
    private final AtomicLong totalSize;

    public ConcurrentTHashSet() {
        this(16, 10, 0.5f, null, null);
    }

    public ConcurrentTHashSet(TObjectHashingStrategy strategy) {
        this(16, 10, 0.5f, strategy, null);
    }

    public ConcurrentTHashSet(int concurrency) {
        this(concurrency, 10, 0.5f, null, null);
    }

    public ConcurrentTHashSet(int concurrency, int initialCapacity) {
        this(concurrency, initialCapacity, 0.5f, null, null);
    }

    public ConcurrentTHashSet(TObjectHashingStrategy strategy, HashingStats stats) {
        this(16, 10, 0.5f, strategy, stats);
    }

    public ConcurrentTHashSet(int concurrency, int initialCapacity, float loadFactor, TObjectHashingStrategy strategy, HashingStats stats) {
        super(loadFactor, strategy, stats);
        int segSize;
        if (concurrency <= 0 || !(loadFactor > 0.0f) || initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (concurrency > 1) {
            concurrency = PrimeFinder.nextPrime((int)concurrency);
        }
        if ((segSize = initialCapacity / concurrency) < 2) {
            segSize = 2;
        }
        this.totalSize = new AtomicLong(0L);
        this.segments = new ConcurrentTHashSegment[concurrency];
        this.numSegments = concurrency;
        for (int index = 0; index < concurrency; ++index) {
            this.segments[index] = new ConcurrentTHashSegment(segSize, (THashParameters)this, this.totalSize);
        }
    }

    public final long longSize() {
        return this.totalSize.get();
    }

    @Override
    public final int size() {
        long size = this.totalSize.get();
        return size < Integer.MAX_VALUE ? (int)size : Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long capacity() {
        long capacity = 0L;
        this.acquireAllLocks(false);
        try {
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                capacity += (long)seg.capacity();
            }
        }
        finally {
            this.releaseAllLocks(false);
        }
        return capacity;
    }

    @Override
    public final boolean isEmpty() {
        return this.totalSize.get() == 0L;
    }

    @Override
    public final boolean contains(Object o) {
        if (o != null) {
            int hash = ConcurrentTHashSet.computeHashCode((Object)o, (TObjectHashingStrategy)this.hashingStrategy);
            return this.segmentFor(hash).contains(o, hash);
        }
        throw new NullPointerException("null element");
    }

    public final T get(Object o) {
        if (o != null) {
            int hash = ConcurrentTHashSet.computeHashCode((Object)o, (TObjectHashingStrategy)this.hashingStrategy);
            return (T)this.segmentFor(hash).getKey(o, hash);
        }
        throw new NullPointerException("null element");
    }

    public final T getUnsafe(Object o) {
        if (o != null) {
            int hash = ConcurrentTHashSet.computeHashCode((Object)o, (TObjectHashingStrategy)this.hashingStrategy);
            Object result = this.segmentFor(hash).getKeyNoLock(o, hash);
            if (result != null && result != ConcurrentTHashSegment.REMOVED && this.hashingStrategy.equals(result, o)) {
                return (T)result;
            }
            return null;
        }
        throw new NullPointerException("null element");
    }

    @Override
    public final boolean add(T e) {
        if (e != null) {
            int hash = ConcurrentTHashSet.computeHashCode(e, (TObjectHashingStrategy)this.hashingStrategy);
            return this.segmentFor(hash).add(e, hash) == null;
        }
        throw new NullPointerException("null element");
    }

    public final Object addKey(T e) {
        if (e != null) {
            int hash = ConcurrentTHashSet.computeHashCode(e, (TObjectHashingStrategy)this.hashingStrategy);
            return this.segmentFor(hash).add(e, hash);
        }
        throw new NullPointerException("null element");
    }

    public final Object put(T e) {
        if (e != null) {
            int hash = ConcurrentTHashSet.computeHashCode(e, (TObjectHashingStrategy)this.hashingStrategy);
            return this.segmentFor(hash).put(e, hash);
        }
        throw new NullPointerException("null element");
    }

    public final <K, C, P> T create(K key, MapCallback<K, T, C, P> valueCreator, C context, P createParams) {
        if (key != null) {
            int hash = ConcurrentTHashSet.computeHashCode(key, (TObjectHashingStrategy)this.hashingStrategy);
            return (T)this.segmentFor(hash).create(key, valueCreator, context, createParams, hash);
        }
        throw new NullPointerException("null element");
    }

    @Override
    public final boolean remove(Object o) {
        if (o != null) {
            int hash = ConcurrentTHashSet.computeHashCode((Object)o, (TObjectHashingStrategy)this.hashingStrategy);
            return this.segmentFor(hash).remove(o, hash) != null;
        }
        throw new NullPointerException("null element");
    }

    public final T removeKey(Object o) {
        if (o != null) {
            int hash = ConcurrentTHashSet.computeHashCode((Object)o, (TObjectHashingStrategy)this.hashingStrategy);
            return (T)this.segmentFor(hash).remove(o, hash);
        }
        throw new NullPointerException("null element");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean replace(Object o, T e) {
        boolean result;
        int segNewIndex;
        if (o == null || e == null) throw new NullPointerException(o == null ? "null old value" : "null new value");
        int hashOld = ConcurrentTHashSet.computeHashCode((Object)o, (TObjectHashingStrategy)this.hashingStrategy);
        int hashNew = ConcurrentTHashSet.computeHashCode(e, (TObjectHashingStrategy)this.hashingStrategy);
        int segOldIndex = this.segmentIndex(hashOld);
        if (segOldIndex != (segNewIndex = this.segmentIndex(hashNew))) {
            ConcurrentTHashSegment<T> segLock2;
            ConcurrentTHashSegment<T> segLock1;
            ConcurrentTHashSegment<T> segOld = this.segments[segOldIndex];
            ConcurrentTHashSegment<T> segNew = this.segments[segNewIndex];
            if (segOldIndex < segNewIndex) {
                segLock1 = segOld;
                segLock2 = segNew;
            } else {
                segLock1 = segNew;
                segLock2 = segOld;
            }
            segLock1.writeLock().lock();
            try {
                segLock2.writeLock().lock();
                try {
                    result = segOld.removeP(o, hashOld) != null;
                    if (!result) return result;
                    segNew.addP(e, hashNew);
                    return result;
                }
                finally {
                    segLock2.writeLock().unlock();
                }
            }
            finally {
                segLock1.writeLock().unlock();
            }
        }
        ConcurrentTHashSegment<T> seg = this.segments[segOldIndex];
        seg.writeLock().lock();
        try {
            result = seg.removeP(o, hashOld) != null;
            if (!result) return result;
            seg.addP(e, hashNew);
            return result;
        }
        finally {
            seg.writeLock().unlock();
        }
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        for (T e : c) {
            result |= this.add(e);
        }
        return result;
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        int segIndex;
        boolean result = false;
        int nsegs = this.numSegments;
        ArrayList[] cs = new ArrayList[nsegs];
        for (Object o : c) {
            if (o != null) {
                int hash = ConcurrentTHashSet.computeHashCode(o, (TObjectHashingStrategy)this.hashingStrategy);
                segIndex = hash % nsegs;
                if (cs[segIndex] == null) {
                    cs[segIndex] = new ArrayList();
                }
                cs[segIndex].add(o);
                continue;
            }
            throw new NullPointerException("null element");
        }
        for (segIndex = 0; segIndex < nsegs; ++segIndex) {
            ArrayList a = cs[segIndex];
            ConcurrentTHashSegment<T> seg = this.segments[segIndex];
            if (a != null) {
                result |= seg.retainAll((Collection)a);
                continue;
            }
            result |= seg.clear();
        }
        return result;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(o);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean bulkRemoveAll(Collection<?> c) {
        if (c != null) {
            boolean result = false;
            int nsegs = this.numSegments;
            int arrInitSize = c.size() / nsegs + 1;
            ArrayList[] objectsBySeg = new ArrayList[nsegs];
            TIntArrayList[] hashesBySeg = new TIntArrayList[nsegs];
            for (Object o : c) {
                if (o != null) {
                    int hash = ConcurrentTHashSet.computeHashCode(o, (TObjectHashingStrategy)this.hashingStrategy);
                    int segIndex = this.segmentIndex(hash);
                    TIntArrayList segHashes = hashesBySeg[segIndex];
                    if (segHashes == null) {
                        hashesBySeg[segIndex] = segHashes = new TIntArrayList(arrInitSize);
                        objectsBySeg[segIndex] = new ArrayList(arrInitSize);
                    }
                    segHashes.add(hash);
                    objectsBySeg[segIndex].add(o);
                    continue;
                }
                throw new NullPointerException("null element");
            }
            for (int segIndex = 0; segIndex < nsegs; ++segIndex) {
                TIntArrayList segHashes = hashesBySeg[segIndex];
                if (segHashes == null) continue;
                ConcurrentTHashSegment<T> seg = this.segments[segIndex];
                Iterator segObjectsItr = objectsBySeg[segIndex].iterator();
                int size = segHashes.size();
                seg.writeLock().lock();
                try {
                    for (int index = 0; index < size; ++index) {
                        result |= seg.removeP(segObjectsItr.next(), segHashes.getQuick(index)) != null;
                    }
                    continue;
                }
                finally {
                    seg.writeLock().unlock();
                }
            }
            return result;
        }
        throw new NullPointerException("null collection");
    }

    @Override
    public void clear() {
        for (ConcurrentTHashSegment<T> seg : this.segments) {
            seg.clear();
        }
    }

    public final Itr iterator() {
        return new Itr();
    }

    public void lockAllSegmentsForRead() {
        this.acquireAllLocks(false);
    }

    public void unlockAllSegmentsAfterRead() {
        this.releaseAllLocks(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean forEach(TObjectProcedure proc) {
        this.acquireAllLocks(false);
        try {
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                for (Object o : seg.set) {
                    if (o == null || o == ConcurrentTHashSegment.REMOVED || proc.execute(o)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.releaseAllLocks(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object[] result;
        int size = 0;
        int offset = 0;
        this.acquireAllLocks(false);
        try {
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                size += seg.size;
            }
            result = new Object[size];
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                offset = seg.toArray(result, seg.set, offset);
            }
        }
        finally {
            this.releaseAllLocks(false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E, C> E[] toArray(E[] a, MapCallback<?, T, C, ?> callback, C context) {
        Object[] result;
        int size = 0;
        int offset = 0;
        this.acquireAllLocks(false);
        try {
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                size += seg.size;
            }
            if (a.length >= size) {
                result = a;
            } else {
                Class<?> c = a.getClass();
                Object object = result = c == Object[].class ? new Object[size] : Array.newInstance(c.getComponentType(), size);
            }
            if (callback != null) {
                callback.onToArray(context);
            }
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                offset = seg.toArray(result, seg.set, offset);
            }
        }
        finally {
            this.releaseAllLocks(false);
        }
        return result;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.toArray(a, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E[] drainTo(E[] a) {
        Object result;
        int size = 0;
        int offset = 0;
        this.acquireAllLocks(true);
        try {
            Class<?> c;
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                size += seg.size;
            }
            result = a.length >= size ? a : ((c = a.getClass()) == Object[].class ? new Object[size] : Array.newInstance(c.getComponentType(), size));
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                offset = seg.toArray((Object[])result, seg.set, offset);
                seg.clear();
            }
        }
        finally {
            this.releaseAllLocks(true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public THashSet toSet() {
        THashSet result;
        int size = 0;
        this.acquireAllLocks(false);
        try {
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                size += seg.size;
            }
            result = new THashSet(size);
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                seg.toCollection((Collection)result, seg.set);
            }
        }
        finally {
            this.releaseAllLocks(false);
        }
        return result;
    }

    public <E> void toCollectionUnsafe(Collection<E> result) {
        for (ConcurrentTHashSegment<T> seg : this.segments) {
            seg.toCollection(result, seg.set);
        }
    }

    public String toString() {
        Itr it = this.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append("SET[");
        boolean firstItem = true;
        while (it.hasNext()) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append(it.next());
        }
        sb.append(']');
        return sb.toString();
    }

    public long estimateMemoryOverhead(SingleObjectSizer sizer) {
        long totalOverhead = sizer.sizeof(this);
        for (ConcurrentTHashSegment<T> seg : this.segments) {
            totalOverhead += sizer.sizeof(seg);
        }
        return totalOverhead;
    }

    private final ConcurrentTHashSegment<T> segmentFor(int hash) {
        return this.segments[hash % this.numSegments];
    }

    private final int segmentIndex(int hash) {
        return hash % this.numSegments;
    }

    private final void acquireAllLocks(boolean forWrite) {
        if (forWrite) {
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                seg.writeLock().lock();
            }
        } else {
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                seg.readLock().lock();
            }
        }
    }

    private final void releaseAllLocks(boolean forWrite) {
        if (forWrite) {
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                seg.writeLock().unlock();
            }
        } else {
            for (ConcurrentTHashSegment<T> seg : this.segments) {
                seg.readLock().unlock();
            }
        }
    }

    public final class Itr
    implements Iterator<T> {
        private ConcurrentTHashSegment<T> seg;
        private int segIndex;
        private Object[] set;
        private Object currentObj;
        private Object nextObj;
        private int nextIndex;

        Itr() {
            this.setSet(ConcurrentTHashSet.this.segments[0]);
            this.moveNext();
        }

        private final void setSet(ConcurrentTHashSegment<T> segment) {
            this.seg = segment;
            this.set = segment.set;
            this.currentObj = null;
            this.nextIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.nextObj != null;
        }

        @Override
        public T next() {
            this.currentObj = this.nextObj;
            Object o = this.currentObj;
            if (o != null) {
                this.moveNext();
                return o;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            Object o = this.currentObj;
            if (o == null) {
                throw new NoSuchElementException();
            }
            int hash = THashParameters.computeHashCode((Object)o, (TObjectHashingStrategy)ConcurrentTHashSet.this.hashingStrategy);
            this.seg.remove(o, hash);
        }

        private void moveNext() {
            this.nextObj = null;
            while (true) {
                Object[] set = this.set;
                int size = set.length;
                for (int i = this.nextIndex; i < size; ++i) {
                    Object o = set[i];
                    if (o == null || o == ConcurrentTHashSegment.REMOVED) continue;
                    this.nextIndex = i + 1;
                    this.nextObj = o;
                    return;
                }
                if (this.nextObj != null) {
                    return;
                }
                if (++this.segIndex >= ConcurrentTHashSet.this.numSegments) break;
                this.setSet(ConcurrentTHashSet.this.segments[this.segIndex]);
            }
        }
    }
}

