/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.gemstone.gemfire.internal.shared.StringPrintWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class Status {
    public static final int SHUTDOWN = 0;
    public static final int STARTING = 1;
    public static final int RUNNING = 2;
    public static final int SHUTDOWN_PENDING = 3;
    public static final int WAITING = 4;
    public static final int STANDBY = 5;
    private static final int CLASS_VERSION = 1;
    public int state;
    public int pid;
    private final String baseName;
    public String msg;
    public String dsMsg;
    public String exceptionStr;
    private transient Path statusFile;

    private Status(String baseName, int state, int pid, String msg, Throwable t, Path statusFile) {
        this.baseName = baseName;
        this.state = state;
        this.pid = pid;
        this.msg = msg;
        if (t != null) {
            StringPrintWriter pw = new StringPrintWriter();
            t.printStackTrace(pw);
            this.exceptionStr = pw.toString();
        }
        this.statusFile = statusFile;
    }

    public static Status create(String baseName, int state, int pid, Path statusFile) {
        return Status.create(baseName, state, pid, null, null, statusFile);
    }

    public static Status create(String baseName, int state, int pid, String msg, Throwable t, Path statusFile) {
        return new Status(baseName, state, pid, msg, t, statusFile);
    }

    private static void writeString(String s, DataOutputStream out) throws IOException {
        if (s != null) {
            out.writeBoolean(true);
            out.writeUTF(s);
        } else {
            out.writeBoolean(false);
        }
    }

    private static String readString(DataInputStream in) throws IOException {
        return in.readBoolean() ? in.readUTF() : null;
    }

    public void write() throws IOException {
        try (OutputStream stream = Files.newOutputStream(this.statusFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC);){
            if (!Files.exists(this.statusFile, new LinkOption[0])) {
                NativeCalls.getInstance().preBlow(this.statusFile.toString(), 2048L, true);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bos);
            out.writeInt(1);
            out.writeInt(this.state);
            out.writeInt(this.pid);
            out.writeUTF(this.baseName);
            Status.writeString(this.msg, out);
            Status.writeString(this.dsMsg, out);
            Status.writeString(this.exceptionStr, out);
            out.flush();
            stream.write(bos.toByteArray());
            stream.flush();
        }
    }

    /*
     * Exception decompiling
     */
    public static Status read(String baseName, Path statusFile) throws InterruptedException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Status spinRead(String baseName, Path statusFile) {
        long timeout = System.currentTimeMillis() + 60000L;
        Status status = null;
        while (status == null && System.currentTimeMillis() < timeout) {
            try {
                status = Status.read(baseName, statusFile);
            }
            catch (Exception e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    status = null;
                    break;
                }
            }
        }
        return status;
    }

    public static void delete(Path statusFile) throws IOException {
        Files.deleteIfExists(statusFile);
    }

    public static void delete(String workingDir, String statusFileName) throws IOException {
        Status.delete(Paths.get(workingDir, statusFileName));
    }

    public static boolean isExistingProcess(int pid) {
        try {
            return NativeCalls.getInstance().isProcessActive(pid);
        }
        catch (UnsupportedOperationException uoe) {
            return true;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.shortStatus());
        if (this.dsMsg != null) {
            buffer.append('\n').append(this.dsMsg);
        }
        return buffer.toString();
    }

    public String shortStatus() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.baseName).append(" pid: ").append(this.pid).append(" status: ");
        switch (this.state) {
            case 0: {
                buffer.append("stopped");
                break;
            }
            case 1: {
                buffer.append("starting");
                break;
            }
            case 2: {
                buffer.append("running");
                break;
            }
            case 3: {
                buffer.append("stopping");
                break;
            }
            case 4: {
                buffer.append("waiting");
                break;
            }
            case 5: {
                buffer.append("standby");
                break;
            }
            default: {
                buffer.append("unknown");
            }
        }
        if (this.exceptionStr != null || this.msg != null) {
            if (this.msg != null) {
                buffer.append("\n").append(this.msg);
            } else {
                buffer.append("\nException in ").append(this.baseName);
            }
            if (this.state != 4 && this.state != 2 || this.msg == null) {
                buffer.append(" - ").append("See log file for details.");
            }
        }
        return buffer.toString();
    }
}

