/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.ChannelBufferFramedInputStream;
import com.gemstone.gemfire.internal.shared.ChannelBufferFramedOutputStream;
import com.gemstone.gemfire.internal.shared.ChannelBufferInputStream;
import com.gemstone.gemfire.internal.shared.ChannelBufferOutputStream;
import com.gemstone.gemfire.internal.shared.InputStreamChannel;
import com.gemstone.gemfire.internal.shared.OutputStreamChannel;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeFramedInputStream;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeFramedOutputStream;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeInputStream;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.spark.unsafe.Platform;
import sun.misc.Cleaner;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public abstract class UnsafeHolder {
    private static final boolean hasUnsafe;

    private UnsafeHolder() {
    }

    public static boolean hasUnsafe() {
        return hasUnsafe;
    }

    public static int getAllocationSize(int size) {
        if ((size = size + 7 >>> 3 << 3) > 0) {
            return size;
        }
        throw new BufferOverflowException();
    }

    public static ByteBuffer allocateDirectBuffer(int size, FreeMemoryFactory factory) {
        int allocSize = UnsafeHolder.getAllocationSize(size);
        ByteBuffer buffer = UnsafeHolder.allocateDirectBuffer(Platform.allocateMemory((long)allocSize), allocSize, factory);
        buffer.limit(size);
        return buffer;
    }

    private static ByteBuffer allocateDirectBuffer(long address, int size, FreeMemoryFactory factory) {
        try {
            ByteBuffer buffer = (ByteBuffer)Wrapper.directBufferConstructor.newInstance(address, size);
            Cleaner cleaner = Cleaner.create((Object)buffer, (Runnable)factory.newFreeMemory(address, size));
            Wrapper.cleanerField.set(buffer, cleaner);
            return buffer;
        }
        catch (Exception e) {
            Platform.throwException((Throwable)e);
            throw new IllegalStateException("unreachable");
        }
    }

    public static long getDirectBufferAddress(ByteBuffer buffer) {
        return ((DirectBuffer)((Object)buffer)).address();
    }

    public static ByteBuffer reallocateDirectBuffer(ByteBuffer buffer, int newSize, Class<?> expectedClass, FreeMemoryFactory factory) {
        DirectBuffer directBuffer = (DirectBuffer)((Object)buffer);
        long address = directBuffer.address();
        long newAddress = 0L;
        newSize = UnsafeHolder.getAllocationSize(newSize);
        Cleaner cleaner = directBuffer.cleaner();
        if (cleaner != null) {
            try {
                Object freeMemory = Wrapper.cleanerRunnableField.get(cleaner);
                if (!(expectedClass == null || freeMemory != null && expectedClass.isInstance(freeMemory))) {
                    throw new IllegalStateException("Expected class to be " + expectedClass.getName() + " in reallocate but was " + (freeMemory != null ? freeMemory.getClass().getName() : "null"));
                }
                if (freeMemory instanceof FreeMemory && ((FreeMemory)freeMemory).tryFree() != 0L) {
                    newAddress = UnsafeHolder.getUnsafe().reallocateMemory(address, newSize);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (newAddress == 0L) {
            if (expectedClass != null) {
                throw new IllegalStateException("Expected class to be " + expectedClass.getName() + " in reallocate but was non-runnable");
            }
            newAddress = Platform.allocateMemory((long)newSize);
            Platform.copyMemory(null, (long)address, null, (long)newAddress, (long)Math.min(newSize, buffer.limit()));
        }
        if (cleaner != null) {
            cleaner.clean();
            cleaner.clear();
        }
        return UnsafeHolder.allocateDirectBuffer(newAddress, newSize, factory).order(buffer.order());
    }

    public static void changeDirectBufferCleaner(ByteBuffer buffer, int size, Class<? extends FreeMemory> from, Class<? extends FreeMemory> to, FreeMemoryFactory factory, Consumer<String> changeOwner) throws IllegalAccessException {
        DirectBuffer directBuffer = (DirectBuffer)((Object)buffer);
        Cleaner cleaner = directBuffer.cleaner();
        if (cleaner != null) {
            Field runnableField = Wrapper.cleanerRunnableField;
            Object runnable = runnableField.get(cleaner);
            if (!to.isInstance(runnable)) {
                if (changeOwner != null) {
                    if (from.isInstance(runnable)) {
                        changeOwner.accept(((FreeMemory)runnable).objectName());
                    } else {
                        changeOwner.accept(null);
                    }
                }
                FreeMemory newFree = factory.newFreeMemory(directBuffer.address(), size);
                runnableField.set(cleaner, newFree);
            }
        } else {
            throw new IllegalAccessException("ByteBuffer without a Cleaner cannot be marked for storage");
        }
    }

    public static void releaseIfDirectBuffer(ByteBuffer buffer) {
        if (buffer != null && buffer.isDirect()) {
            UnsafeHolder.releaseDirectBuffer(buffer);
        }
    }

    static void releaseDirectBuffer(ByteBuffer buffer) {
        Cleaner cleaner = ((DirectBuffer)((Object)buffer)).cleaner();
        if (cleaner != null) {
            cleaner.clean();
            cleaner.clear();
        }
    }

    public static void releasePendingReferences() {
        Method handlePendingRefs = Wrapper.handlePendingRefs;
        if (handlePendingRefs != null) {
            try {
                while (((Boolean)handlePendingRefs.invoke(Wrapper.javaLangRefAccess, new Object[0])).booleanValue()) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Unsafe getUnsafe() {
        return Wrapper.unsafe;
    }

    public static InputStreamChannel newChannelBufferInputStream(ReadableByteChannel channel, int bufferSize) throws IOException {
        return hasUnsafe ? new ChannelBufferUnsafeInputStream(channel, bufferSize) : new ChannelBufferInputStream(channel, bufferSize);
    }

    public static OutputStreamChannel newChannelBufferOutputStream(WritableByteChannel channel, int bufferSize) throws IOException {
        return hasUnsafe ? new ChannelBufferUnsafeOutputStream(channel, bufferSize) : new ChannelBufferOutputStream(channel, bufferSize);
    }

    public static InputStreamChannel newChannelBufferFramedInputStream(ReadableByteChannel channel, int bufferSize) throws IOException {
        return hasUnsafe ? new ChannelBufferUnsafeFramedInputStream(channel, bufferSize) : new ChannelBufferFramedInputStream(channel, bufferSize);
    }

    public static OutputStreamChannel newChannelBufferFramedOutputStream(WritableByteChannel channel, int bufferSize) throws IOException {
        return hasUnsafe ? new ChannelBufferUnsafeFramedOutputStream(channel, bufferSize) : new ChannelBufferFramedOutputStream(channel, bufferSize);
    }

    public static void checkBounds(int arrayLength, int offset, int len) {
        if ((offset | len) < 0 || offset > arrayLength || arrayLength - offset < len) {
            throw new ArrayIndexOutOfBoundsException("Array index out of range: length=" + arrayLength + " offset=" + offset + " length=" + len);
        }
    }

    static {
        boolean v;
        try {
            Wrapper.init();
            v = true;
        }
        catch (LinkageError le) {
            le.printStackTrace();
            v = false;
        }
        hasUnsafe = v;
    }

    public static interface FreeMemoryFactory {
        public FreeMemory newFreeMemory(long var1, int var3);
    }

    public static abstract class FreeMemory
    extends AtomicLong
    implements Runnable {
        protected FreeMemory(long address) {
            super(address);
        }

        protected final long tryFree() {
            long address = this.get();
            return address != 0L && this.compareAndSet(address, 0L) ? address : 0L;
        }

        protected abstract String objectName();

        @Override
        public void run() {
            long address = this.tryFree();
            if (address != 0L) {
                Platform.freeMemory((long)address);
            }
        }
    }

    private static final class Wrapper {
        static final Unsafe unsafe;
        static final Constructor<?> directBufferConstructor;
        static final Field cleanerField;
        static final Field cleanerRunnableField;
        static final Object javaLangRefAccess;
        static final Method handlePendingRefs;

        private Wrapper() {
        }

        static void init() {
        }

        static {
            Object langRefAccess;
            Method m;
            Field cleaner;
            Constructor<?> dbConstructor;
            Unsafe v;
            Field runnableField = null;
            try {
                Field[] fields;
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                v = (Unsafe)field.get(null);
                Class<?> cls = Class.forName("java.nio.DirectByteBuffer");
                dbConstructor = cls.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                dbConstructor.setAccessible(true);
                cleaner = cls.getDeclaredField("cleaner");
                cleaner.setAccessible(true);
                Class<Runnable> runnableClass = Runnable.class;
                for (Field f : fields = Cleaner.class.getDeclaredFields()) {
                    if (!runnableClass.isAssignableFrom(f.getType()) || runnableField != null && !f.getName().contains("thunk")) continue;
                    f.setAccessible(true);
                    runnableField = f;
                }
            }
            catch (LinkageError le) {
                throw le;
            }
            catch (Throwable t) {
                throw new ExceptionInInitializerError(t);
            }
            if (v == null) {
                throw new ExceptionInInitializerError("theUnsafe not found");
            }
            if (runnableField == null) {
                throw new ExceptionInInitializerError("DirectByteBuffer cleaner thunk runnable field not found");
            }
            unsafe = v;
            directBufferConstructor = dbConstructor;
            cleanerField = cleaner;
            cleanerRunnableField = runnableField;
            try {
                m = SharedSecrets.class.getMethod("getJavaLangRefAccess", new Class[0]);
                m.setAccessible(true);
                langRefAccess = m.invoke(null, new Object[0]);
                m = langRefAccess.getClass().getMethod("tryHandlePendingReference", new Class[0]);
                m.setAccessible(true);
                m.invoke(langRefAccess, new Object[0]);
            }
            catch (Throwable ignored) {
                langRefAccess = null;
                m = null;
            }
            javaLangRefAccess = langRefAccess;
            handlePendingRefs = m;
        }
    }
}

