/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.BufferAllocator;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import java.nio.ByteBuffer;
import java.util.function.Consumer;

public class DirectBufferAllocator
extends BufferAllocator {
    public static final int DIRECT_OBJECT_OVERHEAD = 8;
    public static final String DIRECT_STORE_OBJECT_OWNER = "SNAPPYDATA_DIRECT_STORE_OBJECTS";
    public static final String DIRECT_STORE_DATA_FRAME_OUTPUT = "DIRECT_STORE_DATA_FRAME_OUTPUT";
    private static final DirectBufferAllocator globalInstance;
    private static DirectBufferAllocator instance;

    public static DirectBufferAllocator instance() {
        return instance;
    }

    public DirectBufferAllocator initialize() {
        DirectBufferAllocator.setInstance(this);
        return this;
    }

    public static synchronized void setInstance(DirectBufferAllocator allocator) {
        instance = allocator;
    }

    public static synchronized void resetInstance() {
        instance = globalInstance;
    }

    protected DirectBufferAllocator() {
    }

    public RuntimeException lowMemoryException(String op, int required) {
        return new RuntimeException();
    }

    public void changeOwnerToStorage(ByteBuffer buffer, int capacity, Consumer<String> changeOwner) {
    }

    @Override
    public ByteBuffer allocate(int size, String owner) {
        return ByteBuffer.allocateDirect(size);
    }

    @Override
    public ByteBuffer allocateForStorage(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    @Override
    public void clearPostAllocate(ByteBuffer buffer) {
        this.clearBuffer(buffer, 0, buffer.capacity());
    }

    @Override
    public Object baseObject(ByteBuffer buffer) {
        return null;
    }

    @Override
    public long baseOffset(ByteBuffer buffer) {
        return UnsafeHolder.getDirectBufferAddress(buffer);
    }

    @Override
    public ByteBuffer expand(ByteBuffer buffer, int required, String owner) {
        assert (required > 0) : "expand: unexpected required = " + required;
        int currentUsed = buffer.limit();
        if (currentUsed + required > buffer.capacity()) {
            int newLength = BufferAllocator.expandedSize(currentUsed, required);
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newLength).order(buffer.order());
            buffer.rewind();
            newBuffer.put(buffer);
            UnsafeHolder.releaseDirectBuffer(buffer);
            newBuffer.rewind();
            return newBuffer;
        }
        buffer.limit(currentUsed + required);
        return buffer;
    }

    @Override
    public ByteBuffer fromBytesToStorage(byte[] bytes, int offset, int length) {
        ByteBuffer buffer = this.allocateForStorage(length);
        buffer.put(bytes, offset, length);
        buffer.rewind();
        return buffer;
    }

    @Override
    public ByteBuffer transfer(ByteBuffer buffer, String owner) {
        if (buffer.isDirect()) {
            return buffer;
        }
        return super.transfer(buffer, owner);
    }

    @Override
    public void release(ByteBuffer buffer) {
        UnsafeHolder.releaseDirectBuffer(buffer);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public void close() {
        UnsafeHolder.releasePendingReferences();
    }

    static {
        instance = globalInstance = new DirectBufferAllocator();
    }
}

