/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeDataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public final class ChannelBufferUnsafeFramedInputStream
extends ChannelBufferUnsafeDataInputStream {
    protected final int maxFrameBufferSize;

    public ChannelBufferUnsafeFramedInputStream(ReadableByteChannel channel) throws IOException {
        super(channel);
        this.maxFrameBufferSize = this.buffer.capacity() - 4;
    }

    public ChannelBufferUnsafeFramedInputStream(ReadableByteChannel channel, int bufferSize) throws IOException {
        super(channel, bufferSize);
        this.maxFrameBufferSize = this.buffer.capacity() - 4;
    }

    @Override
    public final int readFrame() throws IOException {
        long addrLimit;
        int available;
        int maxFrameBufferSize;
        int frameSize = this.readInt();
        if (frameSize > (maxFrameBufferSize = this.maxFrameBufferSize)) {
            frameSize = maxFrameBufferSize;
        }
        if ((available = (int)((addrLimit = this.addrLimit) - this.addrPosition)) >= frameSize) {
            return 0;
        }
        ByteBuffer buffer = this.buffer;
        int capacity = buffer.capacity();
        int position = (int)(this.addrPosition - this.baseAddress);
        int limit = position + available;
        int freeSpace = capacity - position;
        if (frameSize > freeSpace) {
            buffer.position(position);
            buffer.limit(limit);
            buffer.compact();
        } else {
            buffer.position(limit);
            buffer.limit(capacity);
        }
        return frameSize - available;
    }

    @Override
    public final int readFrameFragment(int fragmentSize) throws IOException {
        int numBytes = this.channel.read(this.buffer);
        if (numBytes >= 0) {
            this.bytesRead += (long)numBytes;
            if ((fragmentSize -= numBytes) <= 0) {
                this.addrLimit = this.baseAddress + (long)this.buffer.position();
                return 0;
            }
            return fragmentSize;
        }
        throw new EOFException("readFrameFragment: premature end of stream while reading " + fragmentSize + " bytes");
    }
}

