/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.jna;

import com.gemstone.gemfire.internal.shared.NativeErrorException;
import com.gemstone.gemfire.internal.shared.TCPSocketOptions;
import com.gemstone.gemfire.internal.shared.jna.OSType;
import com.gemstone.gemfire.internal.shared.jna.POSIXNativeCalls;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;

final class SolarisNativeCalls
extends POSIXNativeCalls {
    private static final int OPT_TCP_KEEPALIVE_THRESHOLD = 22;
    private static final int OPT_TCP_KEEPALIVE_ABORT_THRESHOLD = 23;
    private static final int ENOPROTOOPT = 99;

    SolarisNativeCalls() {
    }

    @Override
    public OSType getOSType() {
        return OSType.SOLARIS;
    }

    @Override
    protected int getPlatformOption(TCPSocketOptions opt) throws UnsupportedOperationException {
        switch (opt) {
            case OPT_KEEPIDLE: {
                return 22;
            }
            case OPT_KEEPINTVL: 
            case OPT_KEEPCNT: {
                return Integer.MIN_VALUE;
            }
        }
        throw new UnsupportedOperationException("unknown option " + (Object)((Object)opt));
    }

    @Override
    protected int setPlatformSocketOption(int sockfd, int level, int optName, TCPSocketOptions opt, Integer optVal, int optSize) throws NativeErrorException {
        try {
            switch (optName) {
                case 22: {
                    IntByReference timeout = new IntByReference(optVal * 1000);
                    int result = SolarisNativeCalls.setsockopt(sockfd, level, optName, timeout, optSize);
                    if (result == 0) {
                        return SolarisNativeCalls.setsockopt(sockfd, level, 23, timeout, optSize);
                    }
                    return result;
                }
            }
            throw new UnsupportedOperationException("unsupported option " + (Object)((Object)opt));
        }
        catch (LastErrorException le) {
            throw new NativeErrorException(le.getMessage(), le.getErrorCode(), le.getCause());
        }
    }

    @Override
    protected boolean isNoProtocolOptionCode(int errno) {
        return errno == 99;
    }

    static {
        Native.register((String)"nsl");
        Native.register((String)"socket");
    }
}

