/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class StringPrintWriter
extends PrintWriter {
    private final StringBuilder sb;
    private static final Writer dummyLock = new StringWriter();
    private final String lineSep;

    public StringPrintWriter() {
        this(new StringBuilder(), null);
    }

    public StringPrintWriter(StringBuilder sb) {
        this(sb, null);
    }

    public StringPrintWriter(StringBuilder sb, String lineSep) {
        super(dummyLock, false);
        this.sb = sb;
        this.lineSep = lineSep != null ? lineSep : ClientSharedUtils.lineSeparator;
    }

    @Override
    public void write(int c) {
        this.sb.append((char)c);
    }

    @Override
    public void write(char[] cbuf) {
        this.sb.append(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.sb.append(cbuf, off, len);
    }

    @Override
    public void write(String str) {
        this.sb.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.sb.append(str.substring(off, off + len));
    }

    @Override
    public void print(boolean b) {
        this.sb.append(b);
    }

    @Override
    public void print(int i) {
        this.sb.append(i);
    }

    @Override
    public void print(long l) {
        this.sb.append(l);
    }

    @Override
    public void print(float f) {
        this.sb.append(f);
    }

    @Override
    public void print(double d) {
        this.sb.append(d);
    }

    @Override
    public void print(char[] s) {
        this.sb.append(s);
    }

    @Override
    public void print(String s) {
        this.sb.append(s);
    }

    @Override
    public void print(Object obj) {
        this.sb.append(obj);
    }

    @Override
    public void println() {
        this.sb.append(this.lineSep);
    }

    @Override
    public void println(boolean b) {
        this.sb.append(b).append(this.lineSep);
    }

    @Override
    public void println(int i) {
        this.sb.append(i).append(this.lineSep);
    }

    @Override
    public void println(long l) {
        this.sb.append(l).append(this.lineSep);
    }

    @Override
    public void println(float f) {
        this.sb.append(f).append(this.lineSep);
    }

    @Override
    public void println(double d) {
        this.sb.append(d).append(this.lineSep);
    }

    @Override
    public void println(char[] s) {
        this.sb.append(s).append(this.lineSep);
    }

    @Override
    public void println(String s) {
        this.sb.append(s).append(this.lineSep);
    }

    @Override
    public void println(Object obj) {
        this.sb.append(obj).append(this.lineSep);
    }

    @Override
    public StringPrintWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public StringPrintWriter append(CharSequence csq) {
        this.write(csq != null ? csq.toString() : "null");
        return this;
    }

    @Override
    public StringPrintWriter append(CharSequence csq, int start, int end) {
        this.write(csq != null ? csq.subSequence(start, end).toString() : "null");
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    public StringBuilder getBuilder() {
        return this.sb;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

