/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.locks.LockSupport;

public abstract class OutputStreamChannel
extends OutputStream
implements WritableByteChannel,
Closeable {
    protected final WritableByteChannel channel;
    protected volatile Thread parkedThread;
    protected volatile long bytesWritten;
    protected static final long PARK_NANOS_MAX = 15000000000L;

    protected OutputStreamChannel(WritableByteChannel channel) {
        this.channel = channel;
    }

    public final WritableByteChannel getUnderlyingChannel() {
        return this.channel;
    }

    @Override
    public abstract int write(ByteBuffer var1) throws IOException;

    public abstract void writeInt(int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int writeBuffered(ByteBuffer src, ByteBuffer channelBuffer) throws IOException {
        int srcLen = src.remaining();
        boolean flushBuffer = srcLen > channelBuffer.limit() >>> 1 && src.isDirect();
        int numWritten = 0;
        while (srcLen > 0) {
            int remaining = channelBuffer.remaining();
            if (srcLen <= remaining) {
                channelBuffer.put(src);
                return numWritten + srcLen;
            }
            if (flushBuffer && channelBuffer.position() == 0) {
                return numWritten + this.writeBufferNonBlocking(src, this.channel);
            }
            if (remaining > 0) {
                int srcPos = src.position();
                src.limit(srcPos + remaining);
                try {
                    channelBuffer.put(src);
                }
                finally {
                    src.limit(srcPos + srcLen);
                }
                numWritten += remaining;
                assert ((srcLen -= remaining) == src.remaining()) : "srcLen=" + srcLen + " srcRemaining=" + src.remaining();
            }
            if (!this.flushBufferNonBlockingBase(channelBuffer)) {
                return numWritten;
            }
            if (!flushBuffer) continue;
            return numWritten + this.writeBufferNonBlocking(src, this.channel);
        }
        return numWritten;
    }

    protected final boolean flushBufferNonBlockingBase(ByteBuffer buffer) throws IOException {
        boolean flushed;
        buffer.flip();
        try {
            this.writeBufferNonBlocking(buffer, this.channel);
        }
        finally {
            if (buffer.hasRemaining()) {
                buffer.compact();
                flushed = false;
            } else {
                buffer.clear();
                flushed = true;
            }
        }
        return flushed;
    }

    protected int writeBuffer(ByteBuffer buffer, WritableByteChannel channel) throws IOException {
        int numWritten;
        long parkNanos = 0L;
        while ((numWritten = channel.write(buffer)) == 0) {
            this.parkedThread = Thread.currentThread();
            LockSupport.parkNanos(50L);
            this.parkedThread = null;
            if ((parkNanos += 50L) <= this.getParkNanosMax()) continue;
            throw new SocketTimeoutException("Connection write timed out.");
        }
        if (numWritten > 0) {
            this.bytesWritten += (long)numWritten;
        }
        return numWritten;
    }

    protected long getParkNanosMax() {
        return 15000000000L;
    }

    protected int writeBufferNonBlocking(ByteBuffer buffer, WritableByteChannel channel) throws IOException {
        int numWritten = channel.write(buffer);
        if (numWritten > 0) {
            this.bytesWritten += (long)numWritten;
        }
        return numWritten;
    }

    public final Thread getParkedThread() {
        return this.parkedThread;
    }

    public final long getBytesWritten() {
        return this.bytesWritten;
    }
}

