/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.concurrent.MapCallback;
import com.gemstone.gemfire.internal.concurrent.MapResult;
import com.gemstone.gemfire.internal.concurrent.THashParameters;
import com.gemstone.gemfire.internal.shared.ClientResolverUtils;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;

public class OpenHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2837689134511263091L;
    public static final Object REMOVED = new Object();
    protected static final int MAX_CAPACITY = 0x40000000;
    protected final float loadFactor;
    protected final TObjectHashingStrategy hashingStrategy;
    protected int size;
    protected int occupied;
    protected int growThreshold;
    protected int mask;
    protected Object[] data;
    protected Function<OpenHashSet<E>, Void> postRehashHook;

    public OpenHashSet() {
        this(32, 0.7f);
    }

    public OpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.7f, (TObjectHashingStrategy)THashParameters.DEFAULT_HASHING);
    }

    public OpenHashSet(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, (TObjectHashingStrategy)THashParameters.DEFAULT_HASHING);
    }

    public OpenHashSet(int initialCapacity, float loadFactor, TObjectHashingStrategy hashingStrategy) {
        int capacity = OpenHashSet.nextPowerOf2(initialCapacity);
        this.loadFactor = loadFactor;
        this.growThreshold = (int)(loadFactor * (float)capacity);
        this.mask = capacity - 1;
        this.data = new Object[capacity];
        this.hashingStrategy = hashingStrategy != null ? hashingStrategy : THashParameters.DEFAULT_HASHING;
    }

    public static int keyHash(Object k, TObjectHashingStrategy hashingStrategy) {
        return ClientResolverUtils.fastHashInt(hashingStrategy.computeHashCode(k));
    }

    protected final int insertionIndex(Object[] data, Object key, int hash, TObjectHashingStrategy hashingStrategy) {
        boolean slotIsNull;
        Object mapKey;
        int mask = this.mask;
        int pos = hash & mask;
        int removedPos = -1;
        int delta = 1;
        while ((mapKey = data[pos]) != null) {
            if (mapKey == REMOVED) {
                removedPos = pos;
            } else if (hashingStrategy.equals(mapKey, key)) {
                return -pos - 1;
            }
            pos = pos + delta & mask;
            ++delta;
        }
        boolean bl = slotIsNull = removedPos == -1;
        if (slotIsNull) {
            ++this.occupied;
            return pos;
        }
        return removedPos;
    }

    protected boolean doInsert(Object[] data, Object key, int pos) {
        data[pos] = key;
        return this.handleNewInsert();
    }

    protected boolean doRemove(Object[] data, int pos) {
        data[pos] = REMOVED;
        return this.handleRemove();
    }

    protected final int index(Object[] data, Object key, int hash, TObjectHashingStrategy hashingStrategy) {
        Object mapKey;
        int mask = this.mask;
        int pos = hash & mask;
        int delta = 1;
        while ((mapKey = data[pos]) != null) {
            if (mapKey != REMOVED && hashingStrategy.equals(mapKey, key)) {
                return pos;
            }
            pos = pos + delta & mask;
            ++delta;
        }
        return -1;
    }

    protected final <K, C, P> Object create(K key, MapCallback<K, E, C, P> creator, C context, P params, MapResult result, int hash, TObjectHashingStrategy hashingStrategy) {
        Object mapKey;
        Object[] data = this.data;
        int mask = this.mask;
        int pos = hash & mask;
        int removedPos = -1;
        int delta = 1;
        while ((mapKey = data[pos]) != null) {
            if (mapKey == REMOVED) {
                removedPos = pos;
            } else if (hashingStrategy.equals(mapKey, key)) {
                return mapKey;
            }
            pos = pos + delta & mask;
            ++delta;
        }
        result.setNewValueCreated(true);
        Object newKey = creator.newValue(key, context, params, result);
        if (result.isNewValueCreated()) {
            if (removedPos == -1) {
                ++this.occupied;
            } else {
                pos = removedPos;
            }
            this.doInsert(data, newKey, pos);
            return newKey;
        }
        return null;
    }

    public void setPostRehashHook(Function<OpenHashSet<E>, Void> hook) {
        this.postRehashHook = hook;
    }

    public final Object addKey(Object key, boolean replace, int hash, TObjectHashingStrategy hashingStrategy) {
        Object[] data = this.data;
        int pos = this.insertionIndex(data, key, hash, hashingStrategy);
        if (pos >= 0) {
            this.doInsert(data, key, pos);
            return null;
        }
        int currentPos = -pos - 1;
        Object mapKey = data[currentPos];
        if (replace) {
            data[currentPos] = key;
        }
        return mapKey;
    }

    public final Object getKey(Object key, int hash, TObjectHashingStrategy hashingStrategy) {
        Object[] data = this.data;
        int pos = this.index(data, key, hash, hashingStrategy);
        if (pos >= 0) {
            return data[pos];
        }
        return null;
    }

    public Object removeKey(Object key, int hash, TObjectHashingStrategy hashingStrategy) {
        Object[] data = this.data;
        int pos = this.index(data, key, hash, hashingStrategy);
        if (pos >= 0) {
            Object mapKey = data[pos];
            this.doRemove(data, pos);
            return mapKey;
        }
        return null;
    }

    @Override
    public boolean contains(Object key) {
        TObjectHashingStrategy hashingStrategy = this.hashingStrategy;
        return this.index(this.data, key, OpenHashSet.keyHash(key, hashingStrategy), hashingStrategy) >= 0;
    }

    @Override
    public boolean add(E key) {
        Object[] data = this.data;
        TObjectHashingStrategy hashingStrategy = this.hashingStrategy;
        int pos = this.insertionIndex(data, key, OpenHashSet.keyHash(key, hashingStrategy), hashingStrategy);
        if (pos >= 0) {
            this.doInsert(data, key, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object key) {
        TObjectHashingStrategy hashingStrategy = this.hashingStrategy;
        return this.removeKey(key, OpenHashSet.keyHash(key, hashingStrategy), hashingStrategy) != null;
    }

    @Override
    public Itr<E> iterator() {
        return new Itr(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public final int capacity() {
        return this.data.length;
    }

    public final TObjectHashingStrategy getHashingStrategy() {
        return this.hashingStrategy;
    }

    @Override
    public void clear() {
        Object[] data = this.data;
        int size = data.length;
        for (int i = 0; i < size; ++i) {
            data[i] = null;
        }
        this.size = 0;
        this.occupied = 0;
    }

    protected final boolean handleNewInsert() {
        ++this.size;
        if (this.occupied <= this.growThreshold) {
            return false;
        }
        this.rehash(OpenHashSet.checkCapacity(this.data.length << 1));
        return true;
    }

    protected final boolean handleRemove() {
        if (--this.size > this.occupied >>> 1 || this.data.length <= 128) {
            return false;
        }
        this.rehash(this.data.length >>> 1);
        return true;
    }

    protected final void rehash(int newCapacity) {
        Object[] data = this.data;
        int capacity = data.length;
        Object[] newData = new Object[newCapacity];
        int newMask = newCapacity - 1;
        TObjectHashingStrategy hashingStrategy = this.hashingStrategy;
        block0: for (int oldPos = 0; oldPos < capacity; ++oldPos) {
            Object d = data[oldPos];
            if (d == null || d == REMOVED) continue;
            int newHash = OpenHashSet.keyHash(d, hashingStrategy);
            int newPos = newHash & newMask;
            int delta = 1;
            while (true) {
                if (newData[newPos] == null) {
                    newData[newPos] = d;
                    continue block0;
                }
                newPos = newPos + delta & newMask;
                ++delta;
            }
        }
        this.occupied = this.size;
        this.data = newData;
        this.mask = newMask;
        this.growThreshold = (int)(this.loadFactor * (float)newCapacity);
        if (this.postRehashHook != null) {
            this.postRehashHook.apply(this);
        }
    }

    protected static int checkCapacity(int capacity) {
        if (capacity > 0 && capacity <= 0x40000000) {
            return capacity;
        }
        throw new IllegalStateException("Can't contain more than 1073741824 elements");
    }

    public static int nextPowerOf2(int n) {
        int highBit = Integer.highestOneBit(n);
        return OpenHashSet.checkCapacity(highBit == n ? n : highBit << 1);
    }

    public static final class Itr<E>
    implements Iterator<E> {
        private final Object[] data;
        private Object result;
        private int pos;
        private int prevPos;
        private final OpenHashSet<?> set;

        Itr(OpenHashSet<?> set) {
            this.data = set.data;
            this.result = null;
            this.pos = -1;
            this.prevPos = -1;
            this.set = set;
            this.advance(this.data);
        }

        private void advance(Object[] data) {
            int size = data.length;
            for (int pos = this.pos + 1; pos < size; ++pos) {
                Object d = data[pos];
                if (d == null || d == REMOVED) continue;
                this.result = d;
                this.pos = pos;
                return;
            }
            this.result = null;
            this.pos = -1;
        }

        @Override
        public boolean hasNext() {
            return this.result != null;
        }

        @Override
        public E next() {
            Object result = this.result;
            if (result != null) {
                Object[] data = this.data;
                this.prevPos = this.pos;
                this.advance(data);
                return (E)result;
            }
            throw new NoSuchElementException("invalid iterator position");
        }

        @Override
        public void remove() {
            int pos = this.prevPos;
            if (pos >= 0) {
                Object[] data = this.data;
                OpenHashSet<?> set = this.set;
                if (data == set.data) {
                    set.doRemove(data, pos);
                } else {
                    set.remove(data[pos]);
                }
            } else {
                throw new NoSuchElementException("invalid iterator position");
            }
        }
    }
}

