/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.NativeCallsInst;
import com.gemstone.gemfire.internal.shared.NativeErrorException;
import com.gemstone.gemfire.internal.shared.TCPSocketOptions;
import com.gemstone.gemfire.internal.shared.jna.OSType;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class NativeCalls {
    public static final int CLOCKID_REALTIME = 0;
    public static final int CLOCKID_MONOTONIC = 1;
    public static final int CLOCKID_PROCESS_CPUTIME_ID = 2;
    public static final int CLOCKID_THREAD_CPUTIME_ID = 3;
    public static final int CLOCKID_MONOTONIC_RAW = 4;
    public static volatile HashSet<String> TEST_CHK_FALLOC_DIRS;
    public static volatile HashSet<String> TEST_NO_FALLOC_DIRS;
    protected static final int OPT_IPPROTO_TCP = 6;
    protected static final int UNSUPPORTED_OPTION = Integer.MIN_VALUE;

    public static NativeCalls getInstance() {
        return NativeCallsInst.instance;
    }

    protected static final Map<String, String> getModifiableJavaEnv() {
        Map<String, String> env = System.getenv();
        try {
            Field m = env.getClass().getDeclaredField("m");
            m.setAccessible(true);
            return (Map)m.get(env);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected static final Map<String, String> getModifiableJavaEnvWIN() {
        try {
            Field envField = Class.forName("java.lang.ProcessEnvironment").getDeclaredField("theCaseInsensitiveEnvironment");
            envField.setAccessible(true);
            return (Map)envField.get(null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected int getSocketKernelDescriptor(Socket sock, InputStream sockStream) throws UnsupportedOperationException {
        Field f;
        FileDescriptor fd = null;
        try {
            f = ClientSharedUtils.getAnyField(sock.getClass(), "self");
            if (f != null) {
                f.setAccessible(true);
                Object self = f.get(sock);
                if (self instanceof Socket) {
                    sock = (Socket)self;
                    sockStream = sock.getInputStream();
                }
            }
        }
        catch (NoSuchFieldException self) {
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException(ex);
        }
        if (sockStream instanceof FileInputStream) {
            try {
                fd = ((FileInputStream)sockStream).getFD();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            Method m;
            SocketChannel channel;
            if (fd == null && (channel = sock.getChannel()) != null) {
                try {
                    m = ClientSharedUtils.getAnyMethod(channel.getClass(), "getFDVal", null, new Class[0]);
                    if (m != null) {
                        m.setAccessible(true);
                        return (Integer)m.invoke((Object)channel, new Object[0]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fd == null) {
                block31: {
                    try {
                        m = ClientSharedUtils.getAnyMethod(sock.getClass(), "getImpl", null, new Class[0]);
                    }
                    catch (Exception ex) {
                        try {
                            m = ClientSharedUtils.getAnyMethod(sock.getClass(), "getPlainSocketImpl", null, new Class[0]);
                        }
                        catch (Exception e) {
                            m = null;
                            if (sockStream == null) {
                                sockStream = sock.getInputStream();
                                if (sockStream instanceof FileInputStream) {
                                    fd = ((FileInputStream)sockStream).getFD();
                                }
                                break block31;
                            }
                            throw e;
                        }
                    }
                }
                if (m != null) {
                    m.setAccessible(true);
                    SocketImpl sockImpl = (SocketImpl)m.invoke((Object)sock, new Object[0]);
                    if (sockImpl != null) {
                        try {
                            m = ClientSharedUtils.getAnyMethod(sockImpl.getClass(), "getFileDescriptor", null, new Class[0]);
                            if (m != null) {
                                m.setAccessible(true);
                                fd = (FileDescriptor)m.invoke((Object)sockImpl, new Object[0]);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (fd != null && (f = ClientSharedUtils.getAnyField(fd.getClass(), "fd")) != null) {
                f.setAccessible(true);
                Object obj = f.get(fd);
                if (obj instanceof Integer) {
                    return (Integer)obj;
                }
            }
            throw new UnsupportedOperationException();
        }
        catch (SecurityException se) {
            throw new UnsupportedOperationException(se);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    protected String getUnsupportedSocketOptionMessage(TCPSocketOptions opt) {
        return "setSocketOption(): socket option " + (Object)((Object)opt) + " not supported by current platform " + (Object)((Object)this.getOSType());
    }

    public abstract OSType getOSType();

    public abstract String getEnvironment(String var1);

    public abstract void setEnvironment(String var1, String var2);

    public abstract void setCurrentWorkingDirectory(String var1);

    public abstract int getProcessId();

    public abstract boolean isProcessActive(int var1) throws UnsupportedOperationException;

    public abstract boolean killProcess(int var1) throws UnsupportedOperationException;

    public void daemonize(RehashServerOnSIGHUP callback) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("daemonize() not available in base implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preBlow(String path, long maxSize, boolean preAllocate) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(path, "rw");){
            raf.setLength(maxSize);
        }
    }

    public boolean isOnLocalFileSystem(String path) {
        return false;
    }

    public abstract Map<TCPSocketOptions, Throwable> setSocketOptions(Socket var1, InputStream var2, Map<TCPSocketOptions, Object> var3) throws UnsupportedOperationException;

    public void lockCurrentMemory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("lockCurrentMemory() not available in base implementation");
    }

    protected final Map<TCPSocketOptions, Throwable> setGenericSocketOptions(Socket sock, InputStream sockStream, Map<TCPSocketOptions, Object> optValueMap) throws UnsupportedOperationException {
        Set<Map.Entry<TCPSocketOptions, Object>> optValueEntries = optValueMap.entrySet();
        for (Map.Entry<TCPSocketOptions, Object> e : optValueEntries) {
            TCPSocketOptions opt = e.getKey();
            Object value = e.getValue();
            this.getPlatformOption(opt);
            if (value != null && value instanceof Integer) continue;
            throw new IllegalArgumentException("bad argument type " + (value != null ? value.getClass().getName() : "NULL") + " for " + (Object)((Object)opt));
        }
        HashMap<TCPSocketOptions, Throwable> failures = new HashMap<TCPSocketOptions, Throwable>(4);
        int sockfd = this.getSocketKernelDescriptor(sock, sockStream);
        for (Map.Entry<TCPSocketOptions, Object> e : optValueEntries) {
            TCPSocketOptions opt = e.getKey();
            Object value = e.getValue();
            int optName = this.getPlatformOption(opt);
            if (optName == Integer.MIN_VALUE) {
                failures.put(opt, new UnsupportedOperationException(this.getUnsupportedSocketOptionMessage(opt)));
                continue;
            }
            int optSize = 4;
            try {
                if (this.setPlatformSocketOption(sockfd, 6, optName, opt, (Integer)value, 4) == 0) continue;
                failures.put(opt, new SocketException((Object)((Object)this.getOSType()) + ": error setting option " + (Object)((Object)opt) + " to " + value));
            }
            catch (NativeErrorException ne) {
                if (this.isNoProtocolOptionCode(ne.getErrorCode())) {
                    failures.put(opt, new UnsupportedOperationException(this.getUnsupportedSocketOptionMessage(opt), ne));
                    continue;
                }
                SocketException se = new SocketException((Object)((Object)this.getOSType()) + ": failed to set " + (Object)((Object)opt) + " to " + value);
                se.initCause(ne);
                failures.put(opt, se);
            }
        }
        return failures.size() > 0 ? failures : null;
    }

    protected int getPlatformOption(TCPSocketOptions opt) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setSocketOption not supported for generic POSIX platform");
    }

    protected int setPlatformSocketOption(int sockfd, int level, int optName, TCPSocketOptions opt, Integer optVal, int optSize) throws UnsupportedOperationException, NativeErrorException {
        throw new UnsupportedOperationException("setSocketOption not supported for generic POSIX platform");
    }

    protected boolean isNoProtocolOptionCode(int errno) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setSocketOption not supported for generic POSIX platform");
    }

    public boolean loadNativeLibrary() {
        return false;
    }

    public boolean isNativeTimerEnabled() {
        return false;
    }

    public long nanoTime(int clock_id) {
        return System.nanoTime();
    }

    public long clockResolution(int clock_id) {
        return 0L;
    }

    public boolean isTTY() {
        return false;
    }

    public long getSessionThreadLimit() {
        return 0L;
    }

    public static class NativeCallsGeneric
    extends NativeCalls {
        private static final Map<String, String> javaEnv;
        private static final boolean isWin;

        @Override
        public OSType getOSType() {
            return isWin ? OSType.WIN : OSType.GENERIC;
        }

        @Override
        public String getEnvironment(String name) {
            return System.getenv(name);
        }

        @Override
        public void setEnvironment(String name, String value) {
            if (javaEnv != null) {
                if (value != null) {
                    javaEnv.put(name, value);
                } else {
                    javaEnv.remove(name);
                }
            }
        }

        @Override
        public void setCurrentWorkingDirectory(String path) {
            System.setProperty("user.dir", path);
        }

        @Override
        public int getProcessId() {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            int idx = name.indexOf(64);
            if (idx > 0) {
                try {
                    return Integer.parseInt(name.substring(0, idx));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0;
        }

        @Override
        public boolean isProcessActive(int processId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("isProcessActive() not available in generic implementation");
        }

        @Override
        public boolean killProcess(int processId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("killProcess() not available in generic implementation");
        }

        @Override
        public Map<TCPSocketOptions, Throwable> setSocketOptions(Socket sock, InputStream sockStream, Map<TCPSocketOptions, Object> optValueMap) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("setting native socket options " + optValueMap.keySet() + " not possible in generic implementation");
        }

        static {
            isWin = System.getProperty("os.name").indexOf("Windows") >= 0;
            javaEnv = isWin ? NativeCallsGeneric.getModifiableJavaEnvWIN() : NativeCallsGeneric.getModifiableJavaEnv();
        }
    }

    public static interface RehashServerOnSIGHUP {
        public void rehash();
    }
}

