/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ChannelBufferInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public final class ChannelBufferFramedInputStream
extends ChannelBufferInputStream {
    protected final int maxFrameBufferSize;

    public ChannelBufferFramedInputStream(ReadableByteChannel channel) throws IOException {
        super(channel);
        this.maxFrameBufferSize = this.buffer.capacity() - 4;
    }

    public ChannelBufferFramedInputStream(ReadableByteChannel channel, int bufferSize) throws IOException {
        super(channel, bufferSize);
        this.maxFrameBufferSize = this.buffer.capacity() - 4;
    }

    @Override
    public final int readFrame() throws IOException {
        int position;
        ByteBuffer buffer;
        int available;
        int maxFrameBufferSize;
        int frameSize = this.readInt();
        if (frameSize > (maxFrameBufferSize = this.maxFrameBufferSize)) {
            frameSize = maxFrameBufferSize;
        }
        if ((available = (buffer = this.buffer).remaining()) >= frameSize) {
            return 0;
        }
        int capacity = buffer.capacity();
        if (frameSize > capacity - (position = buffer.position())) {
            buffer.compact();
            position = buffer.position();
            buffer.rewind();
            buffer.mark();
            buffer.position(position);
        } else {
            buffer.mark();
            buffer.position(buffer.limit());
            buffer.limit(capacity);
        }
        return frameSize - available;
    }

    @Override
    public final int readFrameFragment(int fragmentSize) throws IOException {
        int numBytes = this.channel.read(this.buffer);
        if (numBytes >= 0) {
            this.bytesRead += (long)numBytes;
            if ((fragmentSize -= numBytes) <= 0) {
                int limit = this.buffer.position();
                this.buffer.reset();
                this.buffer.limit(limit);
                return 0;
            }
            return fragmentSize;
        }
        throw new EOFException("readFrameFragment: premature end of stream while reading " + fragmentSize + " bytes");
    }
}

