/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import java.io.Closeable;
import java.nio.ByteBuffer;

public abstract class BufferAllocator
implements Closeable {
    public static final String STORE_DATA_FRAME_OUTPUT = "STORE_DATA_FRAME_OUTPUT";

    public abstract ByteBuffer allocate(int var1, String var2);

    public abstract ByteBuffer allocateForStorage(int var1);

    public abstract void clearPostAllocate(ByteBuffer var1);

    public final void clearBuffer(ByteBuffer buffer, int position, int numBytes) {
        UnsafeHolder.getUnsafe().setMemory(this.baseObject(buffer), this.baseOffset(buffer) + (long)position, numBytes, (byte)0);
    }

    public abstract Object baseObject(ByteBuffer var1);

    public abstract long baseOffset(ByteBuffer var1);

    public abstract ByteBuffer expand(ByteBuffer var1, int var2, String var3);

    public byte[] toBytes(ByteBuffer buffer) {
        int bufferSize = buffer.remaining();
        return ClientSharedUtils.toBytesCopy(buffer, bufferSize, bufferSize);
    }

    public abstract ByteBuffer fromBytesToStorage(byte[] var1, int var2, int var3);

    public ByteBuffer transfer(ByteBuffer buffer, String owner) {
        int position = buffer.position();
        ByteBuffer newBuffer = this.allocate(buffer.limit(), owner);
        buffer.rewind();
        newBuffer.put(buffer);
        buffer.position(position);
        newBuffer.position(position);
        return newBuffer;
    }

    public abstract void release(ByteBuffer var1);

    public abstract boolean isDirect();

    @Override
    public abstract void close();

    public static int expandedSize(int currentUsed, int required) {
        long minRequired = (long)currentUsed + (long)required;
        int newLength = (int)Math.min(Math.max((long)(currentUsed * 3 >>> 1), minRequired), 0x7FFFFFFEL);
        if ((long)newLength >= minRequired) {
            return newLength;
        }
        throw new IndexOutOfBoundsException("Cannot allocate more than " + newLength + " bytes but required " + minRequired);
    }
}

