/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.concurrent;

import com.gemstone.gemfire.internal.concurrent.ConcurrentTLongObjectHashSegment;
import com.gemstone.gemfire.internal.concurrent.THashParameters;
import com.gemstone.gemfire.internal.size.SingleObjectSizer;
import com.gemstone.gnu.trove.HashingStats;
import com.gemstone.gnu.trove.PrimeFinder;
import com.gemstone.gnu.trove.TLongObjectProcedure;
import com.gemstone.gnu.trove.TLongProcedure;
import com.gemstone.gnu.trove.TObjectProcedure;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public final class ConcurrentTLongObjectHashMap<T>
extends THashParameters
implements Map<Long, T> {
    public static final int DEFAULT_CONCURRENCY = 16;
    private final ConcurrentTLongObjectHashSegment<T>[] segments;
    private final AtomicLong totalSize;
    private transient Set<Long> keySet;
    private transient Collection<T> values;
    private transient Set<Map.Entry<Long, T>> entrySet;

    public ConcurrentTLongObjectHashMap() {
        this(16, 10, 0.5f, null);
    }

    public ConcurrentTLongObjectHashMap(int concurrency) {
        this(concurrency, 10, 0.5f, null);
    }

    public ConcurrentTLongObjectHashMap(int concurrency, int initialCapacity) {
        this(concurrency, initialCapacity, 0.5f, null);
    }

    public ConcurrentTLongObjectHashMap(int concurrency, int initialCapacity, float loadFactor, HashingStats stats) {
        super(loadFactor, null, stats);
        int segSize;
        if (concurrency <= 0 || !(loadFactor > 0.0f) || initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (concurrency > 1) {
            concurrency = PrimeFinder.nextPrime((int)concurrency);
        }
        if ((segSize = initialCapacity / concurrency) < 2) {
            segSize = 2;
        }
        this.totalSize = new AtomicLong(0L);
        this.segments = new ConcurrentTLongObjectHashSegment[concurrency];
        for (int index = 0; index < concurrency; ++index) {
            this.segments[index] = new ConcurrentTLongObjectHashSegment(segSize, (THashParameters)this, this.totalSize);
        }
    }

    @Override
    public T get(Object key) {
        if (key != null) {
            long k = (Long)key;
            int hash = ConcurrentTLongObjectHashSegment.computeHashCode((long)k);
            return (T)this.segmentFor(hash).get(k, hash);
        }
        throw new NullPointerException("null key");
    }

    public T getPrimitive(long key) {
        int hash = ConcurrentTLongObjectHashSegment.computeHashCode((long)key);
        return (T)this.segmentFor(hash).get(key, hash);
    }

    @Override
    public T put(Long key, T value) {
        if (key != null) {
            long k = key;
            int hash = ConcurrentTLongObjectHashSegment.computeHashCode((long)k);
            return (T)this.segmentFor(hash).put(k, value, hash);
        }
        throw new NullPointerException("null key");
    }

    public Object putPrimitive(long key, T value) {
        int hash = ConcurrentTLongObjectHashSegment.computeHashCode((long)key);
        return this.segmentFor(hash).put(key, value, hash);
    }

    @Override
    public Object putIfAbsent(long key, T value) {
        int hash = ConcurrentTLongObjectHashSegment.computeHashCode((long)key);
        return this.segmentFor(hash).putIfAbsent(key, value, hash);
    }

    @Override
    public T remove(Object key) {
        if (key != null) {
            long k = (Long)key;
            int hash = ConcurrentTLongObjectHashSegment.computeHashCode((long)k);
            return (T)this.segmentFor(hash).remove(k, hash);
        }
        throw new NullPointerException("null key");
    }

    public Object removePrimitive(long key) {
        int hash = ConcurrentTLongObjectHashSegment.computeHashCode((long)key);
        return this.segmentFor(hash).remove(key, hash);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends T> m) {
        if (m != null) {
            for (Map.Entry<Long, T> e : m.entrySet()) {
                Long key = e.getKey();
                T value = e.getValue();
                if (key != null) {
                    this.putPrimitive(key, value);
                    continue;
                }
                throw new NullPointerException("null key");
            }
        } else {
            throw new NullPointerException("null collection");
        }
    }

    public final long longSize() {
        return this.totalSize.get();
    }

    @Override
    public int size() {
        long size = this.totalSize.get();
        return size < Integer.MAX_VALUE ? (int)size : Integer.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return this.totalSize.get() == 0L;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key != null) {
            long k = (Long)key;
            int hash = ConcurrentTLongObjectHashSegment.computeHashCode((long)k);
            return this.segmentFor(hash).contains(k, hash);
        }
        throw new NullPointerException("null key");
    }

    public boolean containsKeyPrimitive(long key) {
        int hash = ConcurrentTLongObjectHashSegment.computeHashCode((long)key);
        return this.segmentFor(hash).contains(key, hash);
    }

    @Override
    public boolean containsValue(Object value) {
        for (ConcurrentTLongObjectHashSegment<T> seg : this.segments) {
            if (!seg.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (ConcurrentTLongObjectHashSegment<T> seg : this.segments) {
            seg.clear();
        }
    }

    @Override
    public Set<Long> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<Long>(){

                @Override
                public Iterator<Long> iterator() {
                    return new HashIterator<Long>(){

                        @Override
                        public Long next() {
                            return this.nextKey();
                        }
                    };
                }

                @Override
                public boolean contains(Object k) {
                    return ConcurrentTLongObjectHashMap.this.containsKey(k);
                }

                @Override
                public boolean remove(Object k) {
                    return ConcurrentTLongObjectHashMap.this.remove(k) != null;
                }

                @Override
                public int size() {
                    return ConcurrentTLongObjectHashMap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return ConcurrentTLongObjectHashMap.this.isEmpty();
                }

                @Override
                public void clear() {
                    ConcurrentTLongObjectHashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] keys() {
        long[] resultKeys;
        this.acquireAllLocks(false);
        try {
            int size = 0;
            for (ConcurrentTLongObjectHashSegment<T> seg : this.segments) {
                size += seg.size;
            }
            resultKeys = new long[size];
            int index = 0;
            for (ConcurrentTLongObjectHashSegment<T> seg : this.segments) {
                long[] keys = seg.keys;
                Object[] vals = seg.values;
                int sz = keys.length;
                for (int i = 0; i < sz; ++i) {
                    Object val = vals[i];
                    if (val == null || val == ConcurrentTLongObjectHashSegment.REMOVED) continue;
                    resultKeys[index++] = keys[i];
                }
            }
        }
        finally {
            this.releaseAllLocks(false);
        }
        return resultKeys;
    }

    @Override
    public Collection<T> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<T>(){

                @Override
                public Iterator<T> iterator() {
                    return new HashIterator<T>(){

                        @Override
                        public T next() {
                            return this.nextValue();
                        }
                    };
                }

                @Override
                public boolean contains(Object v) {
                    return ConcurrentTLongObjectHashMap.this.containsValue(v);
                }

                @Override
                public int size() {
                    return ConcurrentTLongObjectHashMap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return ConcurrentTLongObjectHashMap.this.isEmpty();
                }

                @Override
                public void clear() {
                    ConcurrentTLongObjectHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, T>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Long, T>>(){

                @Override
                public Iterator<Map.Entry<Long, T>> iterator() {
                    return new HashIterator<Map.Entry<Long, T>>(){

                        @Override
                        public Map.Entry<Long, T> next() {
                            return this.nextEntry();
                        }
                    };
                }

                @Override
                public boolean contains(Object o) {
                    if (o instanceof Map.Entry) {
                        Map.Entry e = (Map.Entry)o;
                        return ConcurrentTLongObjectHashMap.this.containsKey(e.getKey());
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    if (o instanceof Map.Entry) {
                        Map.Entry e = (Map.Entry)o;
                        return ConcurrentTLongObjectHashMap.this.remove(e.getKey()) != null;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return ConcurrentTLongObjectHashMap.this.size();
                }

                @Override
                public void clear() {
                    ConcurrentTLongObjectHashMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    public long estimateMemoryOverhead(SingleObjectSizer sizer) {
        long totalOverhead = sizer.sizeof(this);
        for (ConcurrentTLongObjectHashSegment<T> seg : this.segments) {
            totalOverhead += sizer.sizeof(seg);
        }
        return totalOverhead;
    }

    private ConcurrentTLongObjectHashSegment<T> segmentFor(int hash) {
        return this.segments[hash % this.segments.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEachKey(TLongProcedure proc) {
        this.acquireAllLocks(false);
        try {
            for (ConcurrentTLongObjectHashSegment<T> seg : this.segments) {
                int size = seg.size;
                for (int index = 0; index < size; ++index) {
                    long key = seg.keys[index];
                    Object value = seg.values[index];
                    if (value == null || value == ConcurrentTLongObjectHashSegment.REMOVED || proc.execute(key)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.releaseAllLocks(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEachValue(TObjectProcedure proc) {
        this.acquireAllLocks(false);
        try {
            for (ConcurrentTLongObjectHashSegment<T> seg : this.segments) {
                for (Object o : seg.values) {
                    if (o == null || o == ConcurrentTLongObjectHashSegment.REMOVED || proc.execute(o)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.releaseAllLocks(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEachEntry(TLongObjectProcedure proc) {
        this.acquireAllLocks(false);
        try {
            for (ConcurrentTLongObjectHashSegment<T> seg : this.segments) {
                int size = seg.size;
                for (int index = 0; index < size; ++index) {
                    long key = seg.keys[index];
                    Object value = seg.values[index];
                    if (value == null || value == ConcurrentTLongObjectHashSegment.REMOVED || proc.execute(key, value)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.releaseAllLocks(false);
        }
        return true;
    }

    private void acquireAllLocks(boolean forWrite) {
        if (forWrite) {
            for (ConcurrentTLongObjectHashSegment<T> seg : this.segments) {
                seg.writeLock().lock();
            }
        } else {
            for (ConcurrentTLongObjectHashSegment<T> seg : this.segments) {
                seg.readLock().lock();
            }
        }
    }

    private void releaseAllLocks(boolean forWrite) {
        if (forWrite) {
            for (ConcurrentTLongObjectHashSegment<T> seg : this.segments) {
                seg.writeLock().unlock();
            }
        } else {
            for (ConcurrentTLongObjectHashSegment<T> seg : this.segments) {
                seg.readLock().unlock();
            }
        }
    }

    abstract class HashIterator<K>
    implements Iterator<K> {
        private ConcurrentTLongObjectHashSegment<T> seg;
        private int segIndex;
        private long[] keys;
        private Object[] values;
        private long currentKey;
        private Object currentObj;
        private long nextKey;
        private Object nextObj;
        private int nextIndex;

        HashIterator() {
            this.setMap(ConcurrentTLongObjectHashMap.this.segments[0]);
        }

        final void setMap(ConcurrentTLongObjectHashSegment<T> segment) {
            this.seg = segment;
            segment.readLock().lock();
            this.keys = segment.keys;
            this.values = segment.values;
            segment.readLock().unlock();
            this.currentKey = 0L;
            this.currentObj = null;
            this.moveNext();
        }

        @Override
        public final boolean hasNext() {
            return this.nextObj != null;
        }

        final long nextKey() {
            this.currentObj = this.nextObj;
            Object o = this.currentObj;
            if (o != null) {
                long k = this.currentKey = this.nextKey;
                this.moveNext();
                return k;
            }
            throw new NoSuchElementException();
        }

        final T nextValue() {
            Object o = this.currentObj = this.nextObj;
            this.currentKey = this.nextKey;
            if (o != null) {
                this.moveNext();
                return o;
            }
            throw new NoSuchElementException();
        }

        final Map.Entry<Long, T> nextEntry() {
            this.currentObj = this.nextObj;
            Object o = this.currentObj;
            if (o != null) {
                long k = this.currentKey = this.nextKey;
                this.moveNext();
                return new AbstractMap.SimpleEntry<Long, Object>(k, o);
            }
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            if (this.currentObj == null) {
                throw new NoSuchElementException();
            }
            long key = this.currentKey;
            int hash = ConcurrentTLongObjectHashSegment.computeHashCode((long)key);
            this.seg.remove(key, hash);
        }

        final void moveNext() {
            int size = this.values.length;
            this.nextObj = null;
            for (int i = this.nextIndex; i < size; ++i) {
                Object o = this.values[i];
                if (o == null || o == ConcurrentTLongObjectHashSegment.REMOVED) continue;
                this.nextIndex = i + 1;
                this.nextKey = this.keys[i];
                this.nextObj = o;
                break;
            }
            if (this.nextObj == null && ++this.segIndex < ConcurrentTLongObjectHashMap.this.segments.length) {
                this.setMap(ConcurrentTLongObjectHashMap.this.segments[this.segIndex]);
            }
        }
    }
}

