/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import javax.annotation.Nonnull;
import org.apache.spark.unsafe.Platform;

public class ChannelBufferUnsafeDataInputStream
extends ChannelBufferUnsafeInputStream
implements DataInput {
    public ChannelBufferUnsafeDataInputStream(ReadableByteChannel channel) {
        super(channel);
    }

    public ChannelBufferUnsafeDataInputStream(ReadableByteChannel channel, int bufferSize) {
        super(channel, bufferSize);
    }

    @Override
    public final void readFully(@Nonnull byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(@Nonnull byte[] b, int off, int len) throws IOException {
        while (true) {
            int readBytes;
            if ((readBytes = super.read(b, off, len)) >= len) {
                return;
            }
            if (readBytes < 0) break;
            len -= readBytes;
            off += readBytes;
        }
        throw new EOFException();
    }

    @Override
    public int skipBytes(int n) {
        return (int)this.skip(n);
    }

    @Override
    public long skip(long n) {
        n = Math.max(0L, Math.min(n, this.addrLimit - this.addrPosition));
        this.addrPosition += n;
        return n;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        if (this.addrPosition >= this.addrLimit) {
            this.refillBuffer(this.buffer, 1, "readByte: premature end of stream");
        }
        return Platform.getByte(null, (long)this.addrPosition++);
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public final short readShort() throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos < 2L) {
            this.refillBuffer(this.buffer, 2, "readShort: premature end of stream");
            addrPos = this.addrPosition;
        }
        this.addrPosition += 2L;
        if (ClientSharedUtils.isLittleEndian) {
            return Short.reverseBytes(Platform.getShort(null, (long)addrPos));
        }
        return Platform.getShort(null, (long)addrPos);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public final char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public final long readLong() throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos < 8L) {
            this.refillBuffer(this.buffer, 8, "readLong: premature end of stream");
            addrPos = this.addrPosition;
        }
        this.addrPosition += 8L;
        if (ClientSharedUtils.isLittleEndian) {
            return Long.reverseBytes(Platform.getLong(null, (long)addrPos));
        }
        return Platform.getLong(null, (long)addrPos);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

