/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.jna;

import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.gemstone.gemfire.internal.shared.NativeErrorException;
import com.gemstone.gemfire.internal.shared.TCPSocketOptions;
import com.gemstone.gemfire.internal.shared.jna.OSType;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class WinNativeCalls
extends NativeCalls {
    private static final int WSAENOPROTOOPT = 10042;
    private static final int SIO_KEEPALIVE_VALS = -1744830460;
    private static final Map<String, String> javaEnv;

    WinNativeCalls() {
    }

    public static native int WSAIoctl(NativeLong var0, int var1, TcpKeepAlive var2, int var3, Pointer var4, int var5, IntByReference var6, Pointer var7, Pointer var8) throws LastErrorException;

    @Override
    public OSType getOSType() {
        return OSType.WIN;
    }

    @Override
    public synchronized void setEnvironment(String name, String value) {
        if (name == null) {
            throw new UnsupportedOperationException("setEnvironment() for name=NULL");
        }
        boolean res = false;
        NativeErrorException cause = null;
        try {
            res = Kernel32.SetEnvironmentVariableA(name, value);
        }
        catch (LastErrorException le) {
            if (value == null && le.getErrorCode() == 203) {
                res = true;
            }
            cause = new NativeErrorException(le.getMessage(), le.getErrorCode(), le.getCause());
        }
        if (!res) {
            throw new IllegalArgumentException("setEnvironment: given name=" + name + " (value=" + value + ')', cause);
        }
        if (javaEnv != null) {
            if (value != null) {
                javaEnv.put(name, value);
            } else {
                javaEnv.remove(name);
            }
        }
    }

    @Override
    public void setCurrentWorkingDirectory(String path) throws LastErrorException {
        System.setProperty("user.dir", path);
        Kernel32.SetCurrentDirectory(path);
    }

    @Override
    public synchronized String getEnvironment(String name) {
        if (name == null) {
            throw new UnsupportedOperationException("getEnvironment() for name=NULL");
        }
        int psize = Kernel32.GetEnvironmentVariableA(name, null, 0);
        if (psize > 0) {
            do {
                byte[] result;
                if ((psize = Kernel32.GetEnvironmentVariableA(name, result = new byte[psize], psize)) != result.length - 1) continue;
                return new String(result, 0, psize);
            } while (psize > 0);
            return null;
        }
        return null;
    }

    @Override
    public int getProcessId() {
        return Kernel32.GetCurrentProcessId();
    }

    @Override
    public boolean isProcessActive(int processId) {
        try {
            long hval;
            Pointer procHandle = Kernel32.OpenProcess(1024, false, processId);
            if (procHandle == null || (hval = Pointer.nativeValue((Pointer)procHandle)) == -1L || hval == 0L) {
                return false;
            }
            IntByReference status = new IntByReference();
            boolean result = Kernel32.GetExitCodeProcess(procHandle, status) && status.getValue() == 259;
            Kernel32.CloseHandle(procHandle);
            return result;
        }
        catch (LastErrorException le) {
            return false;
        }
    }

    @Override
    public boolean killProcess(int processId) {
        try {
            long hval;
            Pointer procHandle = Kernel32.OpenProcess(1, false, processId);
            if (procHandle == null || (hval = Pointer.nativeValue((Pointer)procHandle)) == -1L || hval == 0L) {
                return false;
            }
            boolean result = Kernel32.TerminateProcess(procHandle, -1);
            Kernel32.CloseHandle(procHandle);
            return result;
        }
        catch (LastErrorException le) {
            return false;
        }
    }

    @Override
    public void daemonize(NativeCalls.RehashServerOnSIGHUP callback) throws UnsupportedOperationException, IllegalStateException {
        throw new IllegalStateException("daemonize() not applicable for Windows platform");
    }

    @Override
    public Map<TCPSocketOptions, Throwable> setSocketOptions(Socket sock, InputStream sockStream, Map<TCPSocketOptions, Object> optValueMap) throws UnsupportedOperationException {
        TcpKeepAlive optValue = new TcpKeepAlive();
        int optSize = 12;
        TCPSocketOptions errorOpt = null;
        Exception error = null;
        block7: for (Map.Entry<TCPSocketOptions, Object> e : optValueMap.entrySet()) {
            TCPSocketOptions opt = e.getKey();
            Object value = e.getValue();
            if (value == null || !(value instanceof Integer)) {
                throw new IllegalArgumentException("bad argument type " + (value != null ? value.getClass().getName() : "NULL") + " for " + (Object)((Object)opt));
            }
            switch (opt) {
                case OPT_KEEPIDLE: {
                    optValue.enabled = 1;
                    optValue.keepalivetime = (Integer)value * 1000;
                    continue block7;
                }
                case OPT_KEEPINTVL: {
                    optValue.enabled = 1;
                    optValue.keepaliveinterval = (Integer)value * 1000;
                    continue block7;
                }
                case OPT_KEEPCNT: {
                    errorOpt = opt;
                    error = new UnsupportedOperationException(this.getUnsupportedSocketOptionMessage(opt));
                    continue block7;
                }
            }
            throw new UnsupportedOperationException("unknown option " + (Object)((Object)opt));
        }
        int sockfd = this.getSocketKernelDescriptor(sock, sockStream);
        IntByReference nBytes = new IntByReference(0);
        try {
            if (WinNativeCalls.WSAIoctl(new NativeLong((long)sockfd), -1744830460, optValue, 12, null, 0, nBytes, null, null) != 0) {
                errorOpt = TCPSocketOptions.OPT_KEEPIDLE;
                error = new SocketException((Object)((Object)this.getOSType()) + ": error setting options: " + optValueMap);
            }
        }
        catch (LastErrorException le) {
            errorOpt = TCPSocketOptions.OPT_KEEPIDLE;
            if (le.getErrorCode() == 10042) {
                error = new UnsupportedOperationException(this.getUnsupportedSocketOptionMessage(errorOpt), new NativeErrorException(le.getMessage(), le.getErrorCode(), le.getCause()));
            }
            SocketException se = new SocketException((Object)((Object)this.getOSType()) + ": failed to set options: " + optValueMap);
            se.initCause(le);
            error = se;
        }
        return errorOpt != null ? Collections.singletonMap(errorOpt, error) : null;
    }

    static {
        Native.register((String)"Ws2_32");
        javaEnv = WinNativeCalls.getModifiableJavaEnvWIN();
    }

    private static final class Kernel32 {
        static final int PROCESS_QUERY_INFORMATION = 1024;
        static final int PROCESS_TERMINATE = 1;
        static final int STILL_ACTIVE = 259;
        static final int INVALID_HANDLE = -1;

        private Kernel32() {
        }

        public static native boolean SetEnvironmentVariableA(String var0, String var1) throws LastErrorException;

        public static native int GetEnvironmentVariableA(String var0, byte[] var1, int var2);

        public static native boolean SetCurrentDirectory(String var0) throws LastErrorException;

        public static native int GetCurrentProcessId();

        public static native Pointer OpenProcess(int var0, boolean var1, int var2) throws LastErrorException;

        public static native boolean TerminateProcess(Pointer var0, int var1) throws LastErrorException;

        public static native boolean GetExitCodeProcess(Pointer var0, IntByReference var1) throws LastErrorException;

        public static native boolean CloseHandle(Pointer var0) throws LastErrorException;

        static {
            NativeLibrary kernel32Lib = NativeLibrary.getInstance((String)"kernel32", (Map)W32APIOptions.DEFAULT_OPTIONS);
            Native.register((NativeLibrary)kernel32Lib);
        }
    }

    public static final class TcpKeepAlive
    extends Structure {
        public int enabled;
        public int keepalivetime;
        public int keepaliveinterval;

        protected List<?> getFieldOrder() {
            return Arrays.asList("enabled", "keepalivetime", "keepaliveinterval");
        }
    }
}

