/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.FinalizeHolder;
import com.gemstone.gnu.trove.TLinkable;
import java.lang.ref.WeakReference;

public abstract class FinalizeObject
extends WeakReference<Object>
implements TLinkable {
    private static volatile FinalizeHolder serverHolder = new FinalizeHolder();
    private static volatile FinalizeHolder clientHolder = new FinalizeHolder();
    private TLinkable next;
    private TLinkable prev;

    public static FinalizeHolder getServerHolder() {
        return serverHolder;
    }

    public static FinalizeHolder getClientHolder() {
        return clientHolder;
    }

    public static synchronized void clearFinalizationQueues() {
        serverHolder.clearFinalizeQueue();
        clientHolder.clearFinalizeQueue();
        serverHolder = new FinalizeHolder();
        clientHolder = new FinalizeHolder();
    }

    FinalizeObject(Object referent, FinalizeHolder holder) {
        super(referent, holder.referenceQueue);
        holder.initializeFinalizer(this);
    }

    protected FinalizeObject(Object referent, boolean server) {
        this(referent, server ? serverHolder : clientHolder);
    }

    @Override
    public final void clear() {
        if (super.get() != null) {
            super.clear();
            this.getHolder().removeFromFinalizerQueue(this);
        }
    }

    final void clearSuper() {
        super.clear();
    }

    public final void clearAll() {
        this.clear();
        this.clearThis();
    }

    public final TLinkable getNext() {
        return this.next;
    }

    public final TLinkable getPrevious() {
        return this.prev;
    }

    public final void setNext(TLinkable linkable) {
        this.next = linkable;
    }

    public final void setPrevious(TLinkable linkable) {
        this.prev = linkable;
    }

    public abstract FinalizeHolder getHolder();

    protected abstract void clearThis();

    protected abstract boolean doFinalize() throws Exception;

    public static interface BatchFinalize {
        public BatchFinalize merge(BatchFinalize var1);
    }

    public static final class State {
        public byte state;

        public State(byte b) {
            this.state = b;
        }
    }
}

