/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import sun.misc.Unsafe;

public class ChannelBufferUnsafeDataInputStream
extends ChannelBufferUnsafeInputStream
implements DataInput {
    public ChannelBufferUnsafeDataInputStream(ReadableByteChannel channel) throws IOException {
        super(channel);
    }

    public ChannelBufferUnsafeDataInputStream(ReadableByteChannel channel, int bufferSize) throws IOException {
        super(channel, bufferSize);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        while (true) {
            int readBytes;
            if ((readBytes = super.read(b, off, len)) >= len) {
                return;
            }
            if (readBytes < 0) break;
            len -= readBytes;
            off += readBytes;
        }
        throw new EOFException();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        long addrPos;
        if ((addrPos = this.addrPosition++) < this.addrLimit) {
            return unsafe.getByte(addrPos);
        }
        this.refillBuffer(this.buffer, 1, "readByte: premature end of stream");
        return unsafe.getByte(this.addrPosition++);
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public final short readShort() throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos >= 2L) {
            return this.getShort(addrPos);
        }
        this.refillBuffer(this.buffer, 2, "readShort: premature end of stream");
        return this.getShort(this.addrPosition);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public final char readChar() throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos >= 2L) {
            return (char)this.getShort(addrPos);
        }
        this.refillBuffer(this.buffer, 2, "readChar: premature end of stream");
        return (char)this.getShort(this.addrPosition);
    }

    @Override
    public final long readLong() throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos >= 8L) {
            this.addrPosition += 8L;
            return this.buffer.getLong((int)(addrPos - this.baseAddress));
        }
        this.refillBuffer(this.buffer, 8, "readLong: premature end of stream");
        addrPos = this.addrPosition;
        this.addrPosition += 8L;
        return this.buffer.getLong((int)(addrPos - this.baseAddress));
    }

    @Override
    public final float readFloat() throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos >= 4L) {
            return Float.intBitsToFloat(this.getInt(addrPos));
        }
        this.refillBuffer(this.buffer, 4, "readFloat: premature end of stream");
        return Float.intBitsToFloat(this.getInt(this.addrPosition));
    }

    @Override
    public final double readDouble() throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos >= 8L) {
            this.addrPosition += 8L;
            return this.buffer.getDouble((int)(addrPos - this.baseAddress));
        }
        this.refillBuffer(this.buffer, 8, "readDouble: premature end of stream");
        addrPos = this.addrPosition;
        this.addrPosition += 8L;
        return this.buffer.getDouble((int)(addrPos - this.baseAddress));
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    protected final short getShort(long addrPos) {
        Unsafe unsafe = ChannelBufferUnsafeInputStream.unsafe;
        int result = unsafe.getByte(addrPos++) & 0xFF;
        result = result << 8 | unsafe.getByte(addrPos++) & 0xFF;
        this.addrPosition = addrPos;
        return (short)result;
    }
}

