/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;

public final class SystemProperties {
    public static final String LOG_FILE_NAME = "log-file";
    public static final String SOCKET_INPUT_BUFFER_SIZE_NAME = "socket-input-buffer-size";
    public static final String SOCKET_OUTPUT_BUFFER_SIZE_NAME = "socket-output-buffer-size";
    public static final String READ_TIMEOUT_NAME = "read-timeout";
    public static final String KEEPALIVE_IDLE_NAME = "keepalive-idle";
    public static final String KEEPALIVE_INTVL_NAME = "keepalive-interval";
    public static final String KEEPALIVE_CNT_NAME = "keepalive-count";
    public static final String DNS_CACHE_SIZE = "dns-cache-size";
    public static final String DNS_CACHE_FLUSH_INTERVAL = "dns-cache-flush-interval";
    public static final String THRIFT_SELECTOR_SERVER = "thrift-selector";
    public static final String DEFAULT_PROPERTY_NAME_PREFIX = "gemfire.";
    public static final String DEFAULT_GFXDCLIENT_PROPERTY_NAME_PREFIX = "gemfirexd.client.";
    public static String DEFAULT_LOG_FILE = null;
    public static final int DEFAULT_INPUT_BUFFER_SIZE = 32768;
    public static final int DEFAULT_OUTPUT_BUFFER_SIZE = 32768;
    public static final int DEFAULT_KEEPALIVE_IDLE = 20;
    public static final int DEFAULT_KEEPALIVE_INTVL = 1;
    public static final int DEFAULT_KEEPALIVE_CNT = 10;
    public static final int DEFAULT_DNS_CACHE_SIZE = 0;
    public static final int DEFAULT_DNS_CACHE_FLUSH_INTERVAL = 3600;
    public static final String GFXD_FACTORY_PROVIDER = "com.pivotal.gemfirexd.internal.engine.store.entry.GfxdObjectFactoriesProvider";
    private String logFile;
    private int sockInputBufferSize;
    private int sockOutputBufferSize;
    private int keepAliveIdle;
    private int keepAliveIntvl;
    private int keepAliveCnt;
    private int dnsCacheSize;
    private int dnsCacheFlushInterval;
    private static final SystemProperties serverInstance;
    private static final SystemProperties clientInstance;
    private volatile Callbacks callbacks;

    public static boolean isUsingGemFireXDEntryPoint() {
        StackTraceElement[] stack;
        for (StackTraceElement frame : stack = Thread.currentThread().getStackTrace()) {
            String frameCls = frame.getClassName();
            if (!"com.pivotal.gemfirexd.internal.engine.store.GemFireStore".equals(frameCls) && !"com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor".equals(frameCls) && !"com.pivotal.gemfirexd.tools.internal.GfxdServerLauncher".equals(frameCls) && !"com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceImpl".equals(frameCls) && !"com.pivotal.gemfirexd.tools.GfxdDistributionLocator".equals(frameCls) && !"com.pivotal.gemfirexd.tools.GfxdAgentLauncher".equals(frameCls) && !"com.pivotal.gemfirexd.internal.engine.fabricservice.FabricAgentImpl".equals(frameCls) && !"com.pivotal.gemfirexd.tools.GfxdSystemAdmin".equals(frameCls) && !"com.pivotal.gemfirexd.internal.GemFireXDVersion".equals(frameCls)) continue;
            return true;
        }
        return false;
    }

    private SystemProperties(Callbacks cb) {
        this.callbacks = cb;
        this.refreshProperties();
    }

    public static SystemProperties getServerInstance() {
        return serverInstance;
    }

    public static SystemProperties getClientInstance() {
        return clientInstance;
    }

    public static Callbacks getGFXDServerCallbacks() {
        String provider = GFXD_FACTORY_PROVIDER;
        try {
            Class<?> factoryProvider = Class.forName(GFXD_FACTORY_PROVIDER);
            Method method = factoryProvider.getDeclaredMethod("getSystemCallbacksImpl", new Class[0]);
            return (Callbacks)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception in obtaining GemFireXD Objects Factory provider class", e);
        }
    }

    public synchronized void setCallbacks(Callbacks cb) {
        this.callbacks = cb;
        this.refreshProperties();
    }

    public synchronized Callbacks getCallbacks() {
        return this.callbacks;
    }

    public synchronized void refreshProperties() {
        this.logFile = this.getString(LOG_FILE_NAME, DEFAULT_LOG_FILE);
        this.sockInputBufferSize = this.getInteger(SOCKET_INPUT_BUFFER_SIZE_NAME, 32768);
        this.sockOutputBufferSize = this.getInteger(SOCKET_OUTPUT_BUFFER_SIZE_NAME, 32768);
        this.keepAliveIdle = this.getInteger(KEEPALIVE_IDLE_NAME, 20);
        this.keepAliveIntvl = this.getInteger(KEEPALIVE_INTVL_NAME, 1);
        this.keepAliveCnt = this.getInteger(KEEPALIVE_CNT_NAME, 10);
        this.dnsCacheSize = this.getInteger(DNS_CACHE_SIZE, 0);
        this.dnsCacheFlushInterval = this.getInteger(DNS_CACHE_FLUSH_INTERVAL, 3600);
    }

    public String getString(String name, String defaultValue) {
        try {
            Callbacks cb = this.callbacks;
            String value = cb.getSystemProperty(name, this);
            if (value != null) {
                return value;
            }
            if (this == clientInstance) {
                return serverInstance.getString(name, defaultValue);
            }
            return defaultValue;
        }
        catch (SecurityException | PrivilegedActionException e) {
            Logger log = ClientSharedUtils.getLogger();
            if (log != null) {
                StringBuilder msg = new StringBuilder("Could not read system property: ");
                msg.append(name);
                ClientSharedUtils.getStackTrace(e, msg, null);
                log.warning(msg.toString());
            }
            return defaultValue;
        }
    }

    public int getInteger(String name, int defaultValue) {
        String value = this.getString(name, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw ClientSharedUtils.newRuntimeException("Expected integer value for system property [" + name + "] but found [" + value + "]", nfe);
            }
        }
        return defaultValue;
    }

    public long getLong(String name, long defaultValue) {
        String value = this.getString(name, null);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                throw ClientSharedUtils.newRuntimeException("Expected long value for system property [" + name + "] but found [" + value + "]", nfe);
            }
        }
        return defaultValue;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.getString(name, null);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public String getSystemPropertyNamePrefix() {
        return this.callbacks.getSystemPropertyNamePrefix();
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String fileName) {
        this.logFile = fileName;
    }

    public int getSocketInputBufferSize() {
        return this.sockInputBufferSize;
    }

    public void setSocketInputBufferSize(int size) {
        this.sockInputBufferSize = size;
    }

    public int getSocketOutputBufferSize() {
        return this.sockOutputBufferSize;
    }

    public void setSocketOutputBufferSize(int size) {
        this.sockOutputBufferSize = size;
    }

    public int getKeepAliveIdle() {
        return this.keepAliveIdle;
    }

    public void setKeepAliveIdle(int v) {
        this.keepAliveIdle = v;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveIntvl;
    }

    public void setKeepAliveInterval(int v) {
        this.keepAliveIntvl = v;
    }

    public int getKeepAliveCount() {
        return this.keepAliveCnt;
    }

    public void setKeepAliveCount(int v) {
        this.keepAliveCnt = v;
    }

    public int getDNSCacheSize() {
        return this.dnsCacheSize;
    }

    public void setDNSCacheSize(int v) {
        this.dnsCacheSize = v;
    }

    public int getDNSCacheFlushInterval() {
        return this.dnsCacheFlushInterval;
    }

    public void setDNSCacheFlushInterval(int v) {
        this.dnsCacheFlushInterval = v;
    }

    static {
        Callbacks cb = SystemProperties.isUsingGemFireXDEntryPoint() ? SystemProperties.getGFXDServerCallbacks() : new DefaultCallbacks(DEFAULT_PROPERTY_NAME_PREFIX);
        serverInstance = new SystemProperties(cb);
        clientInstance = new SystemProperties(new DefaultCallbacks(DEFAULT_GFXDCLIENT_PROPERTY_NAME_PREFIX));
    }

    public static class DefaultCallbacks
    implements Callbacks,
    PrivilegedExceptionAction<String> {
        private final String propertyNamePrefix;
        private String _propertyName;

        public DefaultCallbacks(String propertyNamePrefix) {
            this.propertyNamePrefix = propertyNamePrefix;
        }

        @Override
        public String getSystemPropertyNamePrefix() {
            return this.propertyNamePrefix;
        }

        @Override
        public synchronized String getSystemProperty(String key, SystemProperties properties) throws PrivilegedActionException {
            this._propertyName = this.propertyNamePrefix + key;
            String value = AccessController.doPrivileged(this);
            this._propertyName = null;
            return value;
        }

        @Override
        public String run() {
            String key = this._propertyName;
            if (key != null) {
                return System.getProperty(key);
            }
            return null;
        }
    }

    public static interface Callbacks {
        public String getSystemPropertyNamePrefix();

        public String getSystemProperty(String var1, SystemProperties var2) throws PrivilegedActionException;
    }
}

