/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.locks.LockSupport;

public abstract class InputStreamChannel
extends InputStream
implements ReadableByteChannel,
Closeable {
    protected final ReadableByteChannel channel;
    protected volatile Thread parkedThread;
    protected static final long PARK_NANOS = 200L;
    protected static final long PARK_NANOS_MAX = 15000000000L;

    protected InputStreamChannel(ReadableByteChannel channel) {
        this.channel = channel;
    }

    public final ReadableByteChannel getUnderlyingChannel() {
        return this.channel;
    }

    @Override
    public abstract int read(ByteBuffer var1) throws IOException;

    public abstract int readInt() throws IOException;

    public int readFrame() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ": readFrame not supported");
    }

    public int readFrameFragment(int fragmentSize) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ": readFrameFragment not supported");
    }

    protected final int readBuffered(ByteBuffer dst, ByteBuffer channelBuffer) throws IOException {
        int remaining;
        int dstLen = dst.remaining();
        if (dstLen <= (remaining = channelBuffer.remaining())) {
            if (dstLen > 0) {
                int pos = channelBuffer.position();
                channelBuffer.limit(pos + dstLen);
                dst.put(channelBuffer);
                channelBuffer.limit(pos + remaining);
                return dstLen;
            }
            return 0;
        }
        int readBytes = 0;
        if (remaining > 0) {
            dst.put(channelBuffer);
            dstLen -= remaining;
            readBytes += remaining;
        }
        if (dstLen >= channelBuffer.limit() && dst.isDirect()) {
            int bufBytes = this.readIntoBufferNonBlocking(dst);
            if (bufBytes > 0) {
                return readBytes + bufBytes;
            }
            return readBytes > 0 ? readBytes : bufBytes;
        }
        int bufBytes = this.refillBuffer(channelBuffer, -1, null);
        if (bufBytes > 0) {
            if (dstLen >= bufBytes) {
                dst.put(channelBuffer);
                return readBytes + bufBytes;
            }
            channelBuffer.limit(dstLen);
            dst.put(channelBuffer);
            channelBuffer.limit(bufBytes);
            return readBytes + dstLen;
        }
        return readBytes > 0 ? readBytes : bufBytes;
    }

    protected int refillBuffer(ByteBuffer channelBuffer, int tryReadBytes, String eofMessage) throws IOException {
        this.resetAndCopyLeftOverBytes(channelBuffer);
        int totalReadBytes = channelBuffer.position();
        int channelBytes = this.readIntoBuffer(channelBuffer);
        if (channelBytes >= 0) {
            totalReadBytes += channelBytes;
        } else if (totalReadBytes == 0) {
            totalReadBytes = channelBytes;
        }
        while (tryReadBytes > totalReadBytes && channelBuffer.hasRemaining()) {
            int readBytes = this.readIntoBuffer(channelBuffer);
            if (readBytes < 0) {
                if (eofMessage != null) {
                    throw new EOFException(eofMessage);
                }
                if (totalReadBytes != 0) break;
                totalReadBytes = readBytes;
                break;
            }
            if (totalReadBytes < 0) {
                totalReadBytes = 0;
            }
            totalReadBytes += readBytes;
        }
        channelBuffer.flip();
        assert (totalReadBytes == channelBuffer.limit() || totalReadBytes == -1 && channelBuffer.limit() == 0) : "readBytes=" + totalReadBytes + " != limit=" + channelBuffer.limit();
        return totalReadBytes;
    }

    protected void resetAndCopyLeftOverBytes(ByteBuffer channelBuffer) {
        if (channelBuffer.hasRemaining()) {
            channelBuffer.compact();
        } else {
            channelBuffer.clear();
        }
    }

    protected int readIntoBuffer(ByteBuffer buffer) throws IOException {
        int readBytes;
        long parkNanos = 0L;
        while ((readBytes = this.channel.read(buffer)) == 0 && buffer.hasRemaining()) {
            this.parkedThread = Thread.currentThread();
            LockSupport.parkNanos(this, 200L);
            this.parkedThread = null;
            if ((parkNanos += 200L) <= 15000000000L) continue;
            throw new SocketTimeoutException("Connection read timed out.");
        }
        return readBytes;
    }

    protected int readIntoBufferNonBlocking(ByteBuffer buffer) throws IOException {
        return this.channel.read(buffer);
    }

    public final Thread getParkedThread() {
        return this.parkedThread;
    }
}

