/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.FinalizeObject;
import com.gemstone.gnu.trove.TLinkedList;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ListIterator;
import java.util.logging.Logger;

public final class FinalizeHolder {
    final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private final TLinkedList finalizerQueue = new TLinkedList();
    private final TLinkedList pendingQueue = new TLinkedList();
    private int numAdds = 0;
    private static final int MAX_FOREGROUND_FINALIZE = 8;

    FinalizeHolder() {
    }

    final synchronized int addToFinalizerQueue(FinalizeObject obj) {
        this.finalizerQueue.add((Object)obj);
        return ++this.numAdds;
    }

    final synchronized void removeFromFinalizerQueue(FinalizeObject obj) {
        this.finalizerQueue.remove((Object)obj);
    }

    final synchronized void clearFinalizeQueue() {
        this.finalizerQueue.clear();
    }

    public final void addToPendingQueue(FinalizeObject obj) {
        TLinkedList pendingQ = this.pendingQueue;
        if (this.emptyReferenceQueue(this.referenceQueue, pendingQ, obj, 8) >= 8) {
            this.invokePendingFinalizers(8);
        }
    }

    final synchronized int addToQueue(Object obj, TLinkedList list) {
        list.add(obj);
        return list.size();
    }

    final synchronized Object pollQueue(TLinkedList list) {
        return list.size() > 0 ? list.removeFirst() : null;
    }

    private synchronized int emptyReferenceQueue(ReferenceQueue<Object> refQ, TLinkedList pendingQ, FinalizeObject newObj, int maxPoll) {
        Reference<Object> o;
        assert (Thread.holdsLock(this));
        TLinkedList finalizerQ = this.finalizerQueue;
        while (maxPoll-- > 0 && (o = refQ.poll()) != null) {
            ((FinalizeObject)o).clearSuper();
            finalizerQ.remove(o);
            pendingQ.add(o);
        }
        if (newObj != null) {
            pendingQ.add((Object)newObj);
        }
        return pendingQ.size();
    }

    private static void addToBatch(Object o, TLinkedList finalizeList, TLinkedList batchFinalizeList) {
        if (o instanceof FinalizeObject.BatchFinalize) {
            int bsize = batchFinalizeList.size();
            if (bsize == 1) {
                FinalizeObject.BatchFinalize batch = (FinalizeObject.BatchFinalize)batchFinalizeList.getFirst();
                FinalizeObject.BatchFinalize merged = batch.merge((FinalizeObject.BatchFinalize)o);
                if (merged != null) {
                    if (merged != batch) {
                        batchFinalizeList.removeFirst();
                        batchFinalizeList.addFirst((Object)merged);
                    }
                } else {
                    batchFinalizeList.add(o);
                }
            } else if (bsize == 0) {
                batchFinalizeList.add(o);
            } else {
                FinalizeObject.BatchFinalize bobj = (FinalizeObject.BatchFinalize)o;
                ListIterator biter = batchFinalizeList.listIterator(0);
                boolean added = false;
                while (biter.hasNext()) {
                    FinalizeObject.BatchFinalize batch = (FinalizeObject.BatchFinalize)biter.next();
                    FinalizeObject.BatchFinalize merged = batch.merge(bobj);
                    if (merged == null) continue;
                    if (merged != batch) {
                        biter.remove();
                        biter.add(merged);
                    }
                    added = true;
                    break;
                }
                if (!added) {
                    batchFinalizeList.add(o);
                }
            }
        } else {
            finalizeList.add(o);
        }
    }

    void doFinalize(FinalizeObject obj, TLinkedList pendingQ) {
        try {
            if (obj.doFinalize()) {
                obj.clearThis();
            } else {
                this.addToQueue(obj, pendingQ);
            }
        }
        catch (VirtualMachineError err) {
            throw err;
        }
        catch (Throwable t) {
            Logger logger = ClientSharedUtils.getLogger();
            if (logger != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("FinalizeHolder: unexpected exception while invoking finalizer ").append(t.toString());
                ClientSharedUtils.getStackTrace(t, sb, null);
                logger.warning(sb.toString());
            }
            obj.clearThis();
        }
    }

    public final void invokePendingFinalizers() {
        this.invokePendingFinalizers(1000);
    }

    public final void invokePendingFinalizers(int maxPoll) {
        Object o;
        ReferenceQueue<Object> refQ = this.referenceQueue;
        TLinkedList pendingQ = this.pendingQueue;
        TLinkedList finalizeList = new TLinkedList();
        TLinkedList batchFinalizeList = new TLinkedList();
        this.emptyReferenceQueue(refQ, pendingQ, null, maxPoll);
        while (maxPoll-- > 0 && (o = this.pollQueue(pendingQ)) != null) {
            FinalizeHolder.addToBatch(o, finalizeList, batchFinalizeList);
        }
        if (batchFinalizeList.size() > 0) {
            for (Object obj : batchFinalizeList) {
                this.doFinalize((FinalizeObject)obj, pendingQ);
            }
        }
        if (finalizeList.size() > 0) {
            for (Object obj : finalizeList) {
                this.doFinalize((FinalizeObject)obj, pendingQ);
            }
        }
    }

    final void initializeFinalizer(FinalizeObject obj) {
        int n = this.addToFinalizerQueue(obj);
        if (n % 4 == 0 && this.emptyReferenceQueue(this.referenceQueue, this.pendingQueue, null, 8) >= 8) {
            this.invokePendingFinalizers(8);
        }
    }
}

