/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.OutputStreamChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ChannelBufferOutputStream
extends OutputStreamChannel {
    protected final ByteBuffer buffer;
    public static final int DEFAULT_BUFFER_SIZE = 32768;

    public ChannelBufferOutputStream(WritableByteChannel channel) throws IOException {
        this(channel, 32768);
    }

    public ChannelBufferOutputStream(WritableByteChannel channel, int bufferSize) throws IOException {
        super(channel);
        this.buffer = this.allocateBuffer(bufferSize);
    }

    protected ByteBuffer allocateBuffer(int bufferSize) {
        return ByteBuffer.allocateDirect(bufferSize);
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.buffer.hasRemaining()) {
            this.buffer.put((byte)(b & 0xFF));
        } else {
            this.flushBufferBlocking(this.buffer);
            this.buffer.put((byte)(b & 0xFF));
        }
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        if (len == 1) {
            if (this.buffer.hasRemaining()) {
                this.buffer.put(b[off]);
            } else {
                this.flushBufferBlocking(this.buffer);
                this.buffer.put(b[off]);
            }
            return;
        }
        while (len > 0) {
            int remaining = this.buffer.remaining();
            if (len <= remaining) {
                this.buffer.put(b, off, len);
                return;
            }
            if (remaining > 0) {
                this.buffer.put(b, off, remaining);
                len -= remaining;
                off += remaining;
            }
            this.flushBufferBlocking(this.buffer);
        }
    }

    @Override
    public final int write(ByteBuffer src) throws IOException {
        return super.writeBuffered(src, this.buffer);
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer.hasRemaining()) {
            this.flushBufferBlocking(this.buffer);
        }
    }

    @Override
    public final boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.flushBufferBlocking(this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushBufferBlocking(ByteBuffer buffer) throws IOException {
        buffer.flip();
        try {
            do {
                this.writeBuffer(buffer);
            } while (buffer.hasRemaining());
        }
        finally {
            if (buffer.hasRemaining()) {
                buffer.compact();
            } else {
                buffer.clear();
            }
        }
    }
}

