/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ChannelBufferOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public final class ChannelBufferFramedOutputStream
extends ChannelBufferOutputStream {
    protected boolean doWriteFrameSize;

    public ChannelBufferFramedOutputStream(WritableByteChannel channel) throws IOException {
        super(channel);
        this.buffer.position(4);
        this.doWriteFrameSize = true;
    }

    public ChannelBufferFramedOutputStream(WritableByteChannel channel, int bufferSize) throws IOException {
        super(channel, bufferSize);
        this.buffer.position(4);
        this.doWriteFrameSize = true;
    }

    @Override
    public void flush() throws IOException {
        ByteBuffer buffer = this.buffer;
        if (this.doWriteFrameSize) {
            buffer.putInt(0, buffer.position() - 4);
            super.flushBufferBlocking(buffer);
        } else {
            if (buffer.position() > 0) {
                super.flushBufferBlocking(buffer);
            }
            this.doWriteFrameSize = true;
        }
        buffer.position(4);
    }

    @Override
    protected void flushBufferBlocking(ByteBuffer buffer) throws IOException {
        if (this.doWriteFrameSize) {
            buffer.putInt(0, buffer.position() - 4);
            this.doWriteFrameSize = false;
        }
        super.flushBufferBlocking(buffer);
    }
}

