/*
 * Decompiled with CFR 0.152.
 */
package wan.ml;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Trade
implements DataSerializable {
    long TradeId;
    String Trader;
    String Entity;
    String Currency;
    double Amount;
    double ContractRate;
    String CtrCurrency;
    double ctr_amt;
    double BaseUSEquiv;
    double ctr_us_equiv;
    double CcyDollarDiscountFactor;
    double CcySpotRate;
    double ctr_spot;
    String ValueDate;
    String TradeDate;
    long timestamp;
    String counterparty;
    long gf_latency_start;
    static SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy");

    public Trade(String xml) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            StringReader string_reader = new StringReader(xml);
            doc = builder.build((Reader)string_reader);
        }
        catch (Exception e) {
            System.out.println("Caught exception during XML parsing of a Trade");
            e.printStackTrace();
        }
        Element root_element = doc.getRootElement();
        this.TradeId = Trade.getIntegerElement(root_element, "TradeId");
        this.Trader = Trade.getStringElement(root_element, "Trader").trim();
        this.Entity = Trade.getStringElement(root_element, "Entity").trim();
        this.Currency = Trade.getStringElement(root_element, "Currency");
        this.Amount = Trade.getDoubleElement(root_element, "Amount");
        this.ContractRate = Trade.getDoubleElement(root_element, "ContractRate");
        this.CtrCurrency = Trade.getStringElement(root_element, "CtrCurrency");
        this.BaseUSEquiv = 1.0;
        this.CcyDollarDiscountFactor = Trade.getDoubleElement(root_element, "CcyDollarDiscountFactor");
        this.CcySpotRate = Trade.getDoubleElement(root_element, "CcySpotRate");
        this.TradeDate = Trade.getStringElement(root_element, "TradeDate");
        this.ValueDate = Trade.getStringElement(root_element, "ValueDate");
        this.counterparty = Trade.getStringElement(root_element, "CounterParty").trim();
        this.ctr_amt = this.Amount * this.ContractRate * -1.0;
        this.ctr_us_equiv = 1.0 / (this.ContractRate / this.BaseUSEquiv);
        this.ctr_spot = "USD".equals(this.CtrCurrency) ? 1.0 : 1.0 / (this.ContractRate / this.CcySpotRate);
    }

    private static double getDoubleElement(Element root_element, String name) {
        String temp = Trade.getStringElement(root_element, name);
        Double dtemp = new Double(temp);
        return dtemp;
    }

    private static int getIntegerElement(Element root_element, String name) {
        String temp = Trade.getStringElement(root_element, name);
        Integer dtemp = new Integer(temp);
        return dtemp;
    }

    private static String getStringElement(Element root_element, String name) {
        return root_element.getChildText(name);
    }

    public Trade(int TradeId, String Entity, String TradeDate, String Trader, String Currency2, double Amount, double ContractRate, String CtrCurrency, double BaseUSEquiv, double CcyDollarDiscountFactor, double CcySpotRate, String ValueDate) {
        this.TradeId = TradeId;
        this.Trader = Trader;
        this.Entity = Entity;
        this.Currency = Currency2;
        this.Amount = Amount;
        this.ContractRate = ContractRate;
        this.CtrCurrency = CtrCurrency;
        this.ctr_amt = Amount * ContractRate * -1.0;
        this.BaseUSEquiv = BaseUSEquiv;
        this.ctr_us_equiv = 1.0 / (ContractRate / BaseUSEquiv);
        this.CcyDollarDiscountFactor = CcyDollarDiscountFactor;
        this.CcySpotRate = CcySpotRate;
        this.ctr_spot = "USD".equals(CtrCurrency) ? 1.0 : 1.0 / (ContractRate / CcySpotRate);
        this.ValueDate = ValueDate;
        this.TradeDate = TradeDate;
        this.timestamp = System.currentTimeMillis();
    }

    public Trade(long l, String entity2, String tradeDate2, String trader2, String currency2, double d, double e, String ctrCurrency2, double f, double g, double h, String valueDate2) {
    }

    public void dumpTrade() {
        System.out.println("Trade record");
        System.out.print(this.TradeId);
        System.out.print(" ");
        System.out.print(this.Trader);
        System.out.print(" ");
        System.out.print(this.Currency);
        System.out.print(" ");
        System.out.print(this.Amount);
        System.out.print(" ");
        System.out.print(this.ContractRate);
        System.out.print(" ");
        System.out.print(this.CtrCurrency);
        System.out.print(" ");
        System.out.print(this.ctr_amt);
        System.out.print(" ");
        System.out.print(this.BaseUSEquiv);
        System.out.print(" ");
        System.out.print(this.ctr_us_equiv);
        System.out.print(" ");
        System.out.print(this.CcyDollarDiscountFactor);
        System.out.print(" ");
        System.out.print(this.CcySpotRate);
        System.out.print(" ");
        System.out.print(this.ctr_spot);
        System.out.print(" ");
        System.out.print(this.TradeDate);
        System.out.print(" ");
        System.out.print(this.ValueDate);
        System.out.print(" ");
        System.out.println(this.timestamp);
    }

    public long getGFLatencyStart() {
        return this.gf_latency_start;
    }

    public void setGFLatencyStart() {
        this.gf_latency_start = System.currentTimeMillis();
    }

    public Trade() {
    }

    public void toData(DataOutput out) throws IOException {
        out.writeLong(this.TradeId);
        DataSerializer.writeString((String)this.Trader, (DataOutput)out);
        DataSerializer.writeString((String)this.Entity, (DataOutput)out);
        DataSerializer.writeString((String)this.Currency, (DataOutput)out);
        out.writeDouble(this.Amount);
        out.writeDouble(this.ContractRate);
        DataSerializer.writeString((String)this.CtrCurrency, (DataOutput)out);
        out.writeDouble(this.ctr_amt);
        out.writeDouble(this.BaseUSEquiv);
        out.writeDouble(this.ctr_us_equiv);
        out.writeDouble(this.CcyDollarDiscountFactor);
        out.writeDouble(this.CcySpotRate);
        out.writeDouble(this.ctr_spot);
        DataSerializer.writeString((String)this.ValueDate, (DataOutput)out);
        DataSerializer.writeString((String)this.TradeDate, (DataOutput)out);
        out.writeLong(this.timestamp);
        DataSerializer.writeString((String)this.counterparty, (DataOutput)out);
        out.writeLong(this.gf_latency_start);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.TradeId = in.readLong();
        this.Trader = DataSerializer.readString((DataInput)in);
        this.Entity = DataSerializer.readString((DataInput)in);
        this.Currency = DataSerializer.readString((DataInput)in);
        this.Amount = in.readDouble();
        this.ContractRate = in.readDouble();
        this.CtrCurrency = DataSerializer.readString((DataInput)in);
        this.ctr_amt = in.readDouble();
        this.BaseUSEquiv = in.readDouble();
        this.ctr_us_equiv = in.readDouble();
        this.CcyDollarDiscountFactor = in.readDouble();
        this.CcySpotRate = in.readDouble();
        this.ctr_spot = in.readDouble();
        this.ValueDate = DataSerializer.readString((DataInput)in);
        this.TradeDate = DataSerializer.readString((DataInput)in);
        this.timestamp = in.readLong();
        this.counterparty = DataSerializer.readString((DataInput)in);
        this.gf_latency_start = in.readLong();
    }
}

