/*
 * Decompiled with CFR 0.152.
 */
package vsphere.vijava;

import com.vmware.vim25.HostVMotionCompatibility;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.VirtualMachineMovePriority;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class VMotionTrigger {
    private static VMotionTrigger singleton = null;
    private ServiceInstance si = null;
    private ScheduledExecutorService stpe = null;
    private static int vMotionInterval = 360;
    private static int vMotionConcurrency = 1;
    private static int scriptDurationMinutes = 60;
    private static int lastVMIndex = -1;
    private static int[] lastHostIndex;
    private static Boolean[] vmsInVMotion;
    private static ArrayList<ArrayList<String>> vmList;
    private static DateFormat df;
    private static PrintStream logStream;
    static final int CONFIG = 0;
    static final int WARNING = 1;
    static final int INFO = 2;
    static final int DEBUG = 3;
    private static int activeLogLevel;

    public static synchronized VMotionTrigger getVMotionTrigger() throws RemoteException, MalformedURLException {
        if (singleton != null) {
            return singleton;
        }
        singleton = new VMotionTrigger();
        return singleton;
    }

    private VMotionTrigger() throws RemoteException, MalformedURLException {
        String password;
        String url = "https://w2-gf-vc01.gemstone.com/sdk";
        assert (System.console() != null);
        String username = System.console().readLine("%s", "username: ");
        if (username == null || username.trim().equals("")) {
            VMotionTrigger.writeToConsole("User cannot be empty.");
            System.exit(1);
        }
        if ((password = String.copyValueOf(System.console().readPassword("%s", "password: ")).trim()) == null || password.trim().equals("")) {
            VMotionTrigger.writeToConsole("Invalid password.");
            System.exit(1);
        }
        this.si = new ServiceInstance(new URL(url), username.trim(), password.trim(), true);
    }

    public static void main(String[] args) {
        VMotionTrigger trigger = null;
        try {
            if (args == null || args.length < 1 || args.length > 3) {
                VMotionTrigger.writeToConsole("\tUsage: java vsphere.vijava.VMotionTrigger <input_file> [<log_file>] [CONFIG|WARNING|INFO|DEBUG]\n");
                System.exit(1);
            }
            trigger = VMotionTrigger.getVMotionTrigger();
            VMotionTrigger.readInputData(args);
            trigger.createVMotionScheduler();
            trigger.scheduleTasks();
            VMotionTrigger.waitForProgramTermination();
        }
        catch (RemoteException re) {
            VMotionTrigger.log(1, "Failed to get going. " + re);
        }
        catch (MalformedURLException mue) {
            VMotionTrigger.log(1, "Failed to get going. " + mue);
        }
        catch (Throwable e) {
            VMotionTrigger.log(1, "Failed to get going. ", e);
        }
        finally {
            VMotionTrigger.writeToConsole("Waiting for scheduled vMotion tasks to complete...\n");
            if (trigger != null) {
                trigger.closeTrigger();
            }
            if (logStream != null) {
                PrintStream tmp = logStream;
                logStream = null;
                tmp.close();
            }
            VMotionTrigger.writeToConsole("vMotion Trigger terminated. Thank you.\n");
        }
    }

    private static void waitForProgramTermination() {
        Thread readLine = new Thread(new Runnable(){

            @Override
            public void run() {
                VMotionTrigger.writeToConsole("\nAt any point during the program execution, press enter to terminate this trigger and return to command prompt.\n");
                System.console().readLine();
            }
        });
        VMotionTrigger.writeToConsole("This trigger will terminate after " + scriptDurationMinutes + " minutes.");
        readLine.start();
        boolean exit = false;
        long startTime = System.currentTimeMillis();
        while (!exit) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                break;
            }
            if (System.currentTimeMillis() - startTime < (long)(scriptDurationMinutes * 60 * 1000) && readLine.isAlive()) continue;
            exit = true;
        }
        readLine.interrupt();
        try {
            readLine.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void writeToConsole(String s) {
        System.console().writer().write(s);
        System.console().writer().flush();
        System.console().flush();
    }

    private static void setLogLevel(String[] args) {
        if (args.length == 3) {
            String logLevel = args[2];
            if (logLevel.equalsIgnoreCase("CONFIG")) {
                activeLogLevel = 0;
            } else if (logLevel.equalsIgnoreCase("WARNING")) {
                activeLogLevel = 1;
            } else if (logLevel.equalsIgnoreCase("INFO")) {
                activeLogLevel = 2;
            } else if (logLevel.equalsIgnoreCase("DEBUG")) {
                activeLogLevel = 3;
            } else {
                VMotionTrigger.log("Invalid value for log level. Setting log level to INFO.");
                activeLogLevel = 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readInputData(String[] args) throws IOException {
        int i = 0;
        int numOfVMs = 0;
        String line = null;
        String badInput = null;
        BufferedReader br = new BufferedReader(new FileReader(new File(args[0])));
        try {
            if (args.length > 1) {
                logStream = new PrintStream(new File(args[1]));
            }
        }
        catch (FileNotFoundException fnfe) {
            VMotionTrigger.log(1, "Log file could not be created. Using default output stream for logging.");
        }
        VMotionTrigger.setLogLevel(args);
        try {
            while ((line = br.readLine()) != null) {
                String token;
                if (line.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) {
                    badInput = "A line either has to be a comment or a data line. No empty lines allowed.";
                    break;
                }
                if (i == 0) {
                    numOfVMs = Integer.parseInt(st.nextToken());
                    if (numOfVMs < 1) {
                        badInput = "Number of VMs to be moved cannot be less than one.";
                        break;
                    }
                } else if (i > 0 && i <= numOfVMs) {
                    String vm = st.nextToken();
                    for (ArrayList<String> vm1 : vmList) {
                        if (!vm1.get(0).equalsIgnoreCase(vm)) continue;
                        badInput = "VM " + vm1.get(0) + " is repeated.";
                        break;
                    }
                    if (badInput != null) break;
                    ArrayList<String> array = new ArrayList<String>();
                    while (st.hasMoreTokens()) {
                        String host = st.nextToken();
                        for (String host1 : array) {
                            if (!host1.equalsIgnoreCase(host)) continue;
                            badInput = "Host " + host + " is repeated for VM " + vm;
                            break;
                        }
                        if (badInput != null) break;
                        array.add(host);
                    }
                    if (badInput != null) break;
                    if (array.size() < 2) {
                        badInput = "VM " + vm + " needs atleast two hosts to participate in vMotion.";
                        break;
                    }
                    array.add(0, vm);
                    vmList.add(array);
                } else if (i == numOfVMs + 1) {
                    try {
                        token = st.nextToken();
                        if (!token.equalsIgnoreCase("default")) {
                            vMotionInterval = Integer.parseInt(token);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new NumberFormatException("Expected a positive integer for vMotion interval. " + nfe.getMessage());
                    }
                    if (vMotionInterval < 0) {
                        badInput = "Interval between two consecutive vMotions cannot be negative.";
                        break;
                    }
                    if (vMotionInterval < 180) {
                        VMotionTrigger.log(1, "Interval between two consecutive vMotions is preferred to be more than 180 seconds. It is " + vMotionInterval + " seconds.");
                    }
                } else if (i == numOfVMs + 2) {
                    try {
                        token = st.nextToken();
                        if (!token.equalsIgnoreCase("default")) {
                            vMotionConcurrency = Integer.parseInt(token);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new NumberFormatException("Expected a positive integer for vMotion concurrency. " + nfe.getMessage());
                    }
                    if (vMotionConcurrency < 1 || vMotionConcurrency > Math.min(numOfVMs, 3)) {
                        badInput = "Concurrency in vmotion cannot be less than one AND greater than minimum of three and the number of VMs available for vmotion. It is " + vMotionConcurrency + ".";
                        break;
                    }
                } else {
                    if (i != numOfVMs + 3) break;
                    try {
                        token = st.nextToken();
                        if (!token.equalsIgnoreCase("default")) {
                            scriptDurationMinutes = Integer.parseInt(token);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new NumberFormatException("Expected a positive integer for duration in minutes of the script. " + nfe.getMessage());
                    }
                    if (scriptDurationMinutes < 0) {
                        badInput = "Duration of the script cannot be negative.";
                        break;
                    }
                }
                ++i;
            }
            if (vmList.isEmpty()) {
                badInput = "Details about VMs placement not specified.";
            }
            if (badInput != null) {
                throw new IllegalArgumentException(badInput);
            }
            VMotionTrigger.printInputData();
        }
        finally {
            br.close();
        }
    }

    private static void printInputData() {
        StringBuffer sb = new StringBuffer();
        sb.append("Number of VMs for vmotion: " + vmList.size());
        for (ArrayList<String> vm : vmList) {
            sb.append("\n  " + vm.get(0) + ":");
            for (int i = 1; i < vm.size(); ++i) {
                sb.append(" " + vm.get(i));
            }
        }
        sb.append("\nInterval between two consecutive vMotions: " + vMotionInterval + " seconds.");
        sb.append("\nvMotion concurrency: " + vMotionConcurrency);
        sb.append("\nvMotion duration: " + scriptDurationMinutes + " minutes.");
        VMotionTrigger.log(3, sb.toString());
    }

    private void createVMotionScheduler() {
        this.stpe = new ScheduledThreadPoolExecutor(3, new ThreadFactory(){
            AtomicInteger threadNum = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread result = new Thread(r, "vMotion_Task_" + this.threadNum.incrementAndGet());
                VMotionTrigger.log(3, "returning new thread...");
                return result;
            }
        });
        vmsInVMotion = new Boolean[vmList.size()];
        for (int i = 0; i < vmsInVMotion.length; ++i) {
            VMotionTrigger.vmsInVMotion[i] = Boolean.FALSE;
        }
        lastHostIndex = new int[vmList.size()];
    }

    private void scheduleTasks() {
        for (int i = 0; i < vMotionConcurrency; ++i) {
            VMotionTrigger.log(3, "scheduling a task");
            this.stpe.scheduleWithFixedDelay(new VMotionTask(), 5L, vMotionInterval, TimeUnit.SECONDS);
        }
    }

    private void closeTrigger() {
        if (this.stpe != null) {
            VMotionTrigger.log(0, "Shutting down the vmotion trigger...");
            this.stpe.shutdown();
            try {
                this.stpe.awaitTermination(420L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.si != null) {
            this.si.getServerConnection().logout();
        }
    }

    private static void dummyVMotion(ServiceInstance si, Folder rootFolder, HostSystem newHost, String targetVMName, String newHostName) {
        VMotionTrigger.log("Selected host [vm] for vMotion: " + newHostName + " [" + targetVMName + "]");
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        VMotionTrigger.log("vMotion of " + targetVMName + " to " + newHostName + " completed");
    }

    private static boolean migrateVM(ServiceInstance si, Folder rootFolder, HostSystem newHost, String targetVMName, String newHostName) throws Exception {
        VMotionTrigger.log("Selected host [vm] for vMotion: " + newHostName + " [" + targetVMName + "]");
        VirtualMachine vm = (VirtualMachine)new InventoryNavigator((ManagedEntity)rootFolder).searchManagedEntity("VirtualMachine", targetVMName);
        if (vm == null) {
            VMotionTrigger.log(1, "Could not resolve VM " + targetVMName + ", vMotion of this VM cannot be performed.");
            return false;
        }
        ComputeResource cr = (ComputeResource)newHost.getParent();
        String[] checks = new String[]{"cpu", "software"};
        HostVMotionCompatibility[] vmcs = si.queryVMotionCompatibility(vm, new HostSystem[]{newHost}, checks);
        String[] comps = vmcs[0].getCompatibility();
        if (checks.length != comps.length) {
            VMotionTrigger.log(1, "CPU/software NOT compatible, vMotion failed.");
            return false;
        }
        long start = System.currentTimeMillis();
        Task task = vm.migrateVM_Task(cr.getResourcePool(), newHost, VirtualMachineMovePriority.highPriority, VirtualMachinePowerState.poweredOn);
        if (task.waitForMe() == "success") {
            long end = System.currentTimeMillis();
            VMotionTrigger.log("vMotion of " + targetVMName + " to " + newHostName + " completed in " + (end - start) + "ms. Task result: " + task.getTaskInfo().getResult());
            return true;
        }
        TaskInfo info = task.getTaskInfo();
        VMotionTrigger.log(1, "vMotion of " + targetVMName + " to " + newHostName + " failed. Error details: " + info.getError().getFault());
        return false;
    }

    public static void log(String s) {
        VMotionTrigger.log(2, s, null);
    }

    public static void log(int level, String s) {
        VMotionTrigger.log(level, s, null);
    }

    public static void log(int level, String s, Throwable t) {
        if (level > activeLogLevel) {
            return;
        }
        String currentTime = df.format(new Date());
        String levelStr = "";
        switch (level) {
            case 0: {
                levelStr = "Config ";
                break;
            }
            case 1: {
                levelStr = "Warning ";
                break;
            }
            case 2: {
                levelStr = "Info ";
                break;
            }
            case 3: {
                levelStr = "Debug ";
                break;
            }
        }
        if (logStream != null) {
            logStream.println("\n[" + levelStr + currentTime + Thread.currentThread().getName() + "] " + s);
            if (t != null) {
                t.printStackTrace(logStream);
            }
            logStream.flush();
        } else {
            System.out.println("\n[" + levelStr + currentTime + Thread.currentThread().getName() + "] " + s);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    static {
        vmList = new ArrayList();
        df = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss z ");
        logStream = null;
        activeLogLevel = 2;
    }

    class VMotionTask
    implements Runnable {
        VMotionTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int vmToUse = -1;
            try {
                int attempts;
                ArrayList arrayList = vmList;
                synchronized (arrayList) {
                    for (attempts = 0; attempts < vmList.size(); ++attempts) {
                        int n;
                        lastVMIndex = lastVMIndex == vmList.size() - 1 ? 0 : ++lastVMIndex;
                        vmToUse = lastVMIndex;
                        if (vmsInVMotion[vmToUse].booleanValue()) continue;
                        vmsInVMotion[vmToUse] = Boolean.TRUE;
                        int[] nArray = lastHostIndex;
                        if (lastHostIndex[vmToUse] == ((ArrayList)vmList.get(vmToUse)).size() - 1) {
                            n = 1;
                        } else {
                            int[] nArray2 = lastHostIndex;
                            int n2 = vmToUse;
                            n = nArray2[n2] = nArray2[n2] + 1;
                        }
                        nArray[vmToUse] = n;
                        break;
                    }
                }
                if (attempts == vmList.size()) {
                    vmToUse = -1;
                    return;
                }
                String targetVMName = (String)((ArrayList)vmList.get(vmToUse)).get(0);
                String newHostName = (String)((ArrayList)vmList.get(vmToUse)).get(lastHostIndex[vmToUse]);
                Folder rootFolder = VMotionTrigger.this.si.getRootFolder();
                InventoryNavigator in = new InventoryNavigator((ManagedEntity)rootFolder);
                HostSystem newHost = (HostSystem)in.searchManagedEntity("HostSystem", newHostName);
                if (newHost == null) {
                    VMotionTrigger.log(1, "Could not resolve host " + newHostName + ", vMotion to this host cannot be performed.");
                    return;
                }
                VMotionTrigger.migrateVM(VMotionTrigger.this.si, rootFolder, newHost, targetVMName, newHostName);
            }
            catch (Exception e) {
                VMotionTrigger.log(1, "Found ", e);
            }
            finally {
                if (vmToUse != -1) {
                    ArrayList arrayList = vmList;
                    synchronized (arrayList) {
                        vmsInVMotion[vmToUse] = Boolean.FALSE;
                    }
                }
            }
        }
    }
}

