/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import hydra.Log;
import java.io.Serializable;
import java.util.Properties;
import util.AbstractListener;
import util.SilenceListenerBB;
import util.TestException;
import util.TestHelper;

public class SilenceListener
extends AbstractListener
implements CacheListener,
Declarable,
Serializable {
    public void afterCreate(EntryEvent event) {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        this.logCall("afterCreate", (CacheEvent)event);
    }

    public void afterDestroy(EntryEvent event) {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        this.logCall("afterDestroy", (CacheEvent)event);
    }

    public void afterInvalidate(EntryEvent event) {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        this.logCall("afterInvalidate", (CacheEvent)event);
    }

    public void afterRegionDestroy(RegionEvent event) {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        this.logCall("afterRegionDestroy", (CacheEvent)event);
    }

    public void afterRegionInvalidate(RegionEvent event) {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
    }

    public void afterUpdate(EntryEvent event) {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        this.logCall("afterUpdate", (CacheEvent)event);
    }

    public void close() {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        this.logCall("close", null);
    }

    public void afterRegionClear(RegionEvent event) {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        this.logCall("afterRegionCreate", (CacheEvent)event);
    }

    public void afterRegionLive(RegionEvent event) {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }

    public static void waitForSilence(long desiredSilenceSec, long sleepMS) {
        Log.getLogWriter().info("Waiting for a period of silence for " + desiredSilenceSec + " seconds...");
        long desiredSilenceMS = desiredSilenceSec * 1000L;
        long silenceStartTime = System.currentTimeMillis();
        long currentTime = System.currentTimeMillis();
        long lastEventTime = SilenceListenerBB.getBB().getSharedCounters().read(SilenceListenerBB.lastEventTime);
        while (currentTime - silenceStartTime < desiredSilenceMS) {
            try {
                Thread.sleep(sleepMS);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            lastEventTime = SilenceListenerBB.getBB().getSharedCounters().read(SilenceListenerBB.lastEventTime);
            if (lastEventTime > silenceStartTime) {
                silenceStartTime = lastEventTime;
            }
            currentTime = System.currentTimeMillis();
        }
        long duration = currentTime - silenceStartTime;
        Log.getLogWriter().info("Done waiting, clients have been silent for " + duration + " ms");
    }
}

