/*
 * Decompiled with CFR 0.152.
 */
package util;

import hydra.Log;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import util.QueryObjectBB;
import util.RandomValues;
import util.TestException;
import util.TestHelper;

public class QueryObject
implements Serializable,
Cloneable,
Comparable {
    public String myVersion = "tests/util.QueryObject";
    public long aPrimitiveLong;
    public Long aLong;
    public int aPrimitiveInt;
    public Integer anInteger;
    public short aPrimitiveShort;
    public Short aShort;
    public float aPrimitiveFloat;
    public Float aFloat;
    public double aPrimitiveDouble;
    public Double aDouble;
    public byte aPrimitiveByte;
    public Byte aByte;
    public char aPrimitiveChar;
    public Character aCharacter;
    public boolean aPrimitiveBoolean;
    public Boolean aBoolean;
    public String aString;
    public byte[] aByteArray;
    public QueryObject aQueryObject;
    public Object extra;
    public long id = QueryObjectBB.getBB().getSharedCounters().incrementAndRead(QueryObjectBB.QueryObjectID);
    public static final int EQUAL_VALUES = 1;
    public static final int SEQUENTIAL_VALUES = 2;
    public static final int RANDOM_VALUES = 3;
    public static final int INCREMENT = 4;
    public static final int NEGATE = 5;
    public static final int NULL_NONPRIM_FIELDS = 5;

    public QueryObject() {
    }

    public QueryObject(long base, int valueGeneration, int byteArraySize, int levels) {
        this.fillInBaseValues(base, valueGeneration, byteArraySize);
        QueryObject firstQueryObject = null;
        QueryObject currentQueryObject = null;
        for (int i = 1; i < levels; ++i) {
            QueryObject queryObject = new QueryObject();
            queryObject.fillInBaseValues(base + (long)i, valueGeneration, byteArraySize);
            if (i == 1) {
                firstQueryObject = queryObject;
                currentQueryObject = queryObject;
                continue;
            }
            currentQueryObject.aQueryObject = queryObject;
            currentQueryObject = queryObject;
        }
        this.aQueryObject = firstQueryObject;
    }

    public void fillInBaseValues(long base, int valueGeneration, int byteArraySize) {
        if (valueGeneration == 1) {
            this.aPrimitiveLong = base;
            this.aLong = new Long(base);
            this.aPrimitiveInt = (int)base;
            this.anInteger = new Integer(this.aPrimitiveInt);
            this.aPrimitiveShort = (short)base;
            this.aShort = new Short(this.aPrimitiveShort);
            this.aPrimitiveFloat = base;
            this.aFloat = new Float(base);
            this.aPrimitiveDouble = base;
            this.aDouble = new Double(base);
            this.aPrimitiveByte = (byte)base;
            this.aByte = new Byte(this.aPrimitiveByte);
            this.aPrimitiveChar = (char)base;
            this.aCharacter = new Character(this.aPrimitiveChar);
            this.aPrimitiveBoolean = true;
            this.aBoolean = new Boolean(true);
            this.aString = "" + base;
        } else if (valueGeneration == 2) {
            long currValue = base;
            this.aPrimitiveLong = currValue++;
            this.aLong = new Long(currValue++);
            this.aPrimitiveInt = (int)currValue++;
            this.anInteger = new Integer((int)currValue++);
            this.aPrimitiveShort = (short)currValue++;
            this.aShort = new Short((short)currValue++);
            this.aPrimitiveFloat = currValue++;
            this.aFloat = new Float(currValue++);
            this.aPrimitiveDouble = currValue++;
            this.aDouble = new Double(currValue++);
            this.aPrimitiveByte = (byte)currValue++;
            this.aByte = new Byte((byte)currValue++);
            this.aPrimitiveChar = (char)currValue++;
            this.aCharacter = new Character((char)currValue++);
            this.aPrimitiveBoolean = true;
            this.aBoolean = new Boolean(true);
            this.aString = "" + currValue++;
        } else if (valueGeneration == 3) {
            RandomValues rv = new RandomValues();
            this.aPrimitiveLong = rv.getRandom_long();
            this.aLong = new Long(rv.getRandom_long());
            this.aPrimitiveInt = rv.getRandom_int();
            this.anInteger = new Integer(rv.getRandom_int());
            this.aPrimitiveShort = rv.getRandom_short();
            this.aShort = new Short(rv.getRandom_short());
            this.aPrimitiveFloat = rv.getRandom_float();
            this.aFloat = new Float(rv.getRandom_float());
            this.aPrimitiveDouble = rv.getRandom_double();
            this.aDouble = new Double(rv.getRandom_double());
            this.aPrimitiveByte = rv.getRandom_byte();
            this.aByte = new Byte(rv.getRandom_byte());
            this.aPrimitiveChar = rv.getRandom_char();
            this.aCharacter = new Character(rv.getRandom_char());
            this.aPrimitiveBoolean = rv.getRandom_boolean();
            this.aBoolean = new Boolean(rv.getRandom_boolean());
            this.aString = rv.getRandom_String();
        }
        if (byteArraySize >= 0) {
            this.aByteArray = new byte[byteArraySize];
        }
    }

    public int hashCode() {
        int hashCode = new Long(this.aPrimitiveLong).hashCode() + this.aLong.hashCode() + new Integer(this.aPrimitiveInt).hashCode() + this.anInteger.hashCode() + new Short(this.aPrimitiveShort).hashCode() + this.aShort.hashCode() + new Float(this.aPrimitiveFloat).hashCode() + this.aFloat.hashCode() + new Double(this.aPrimitiveDouble).hashCode() + this.aDouble.hashCode() + new Byte(this.aPrimitiveByte).hashCode() + this.aByte.hashCode() + new Character(this.aPrimitiveChar).hashCode() + this.aCharacter.hashCode() + new Boolean(this.aPrimitiveBoolean).hashCode() + this.aBoolean.hashCode() + this.aString.hashCode();
        if (this.aByteArray != null) {
            hashCode += this.aByteArray.length;
        }
        if (this.aQueryObject != null) {
            hashCode += this.aQueryObject.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object anObj) {
        boolean result = this._equals(anObj);
        return result;
    }

    private boolean _equals(Object anObj) {
        if (anObj == null) {
            return false;
        }
        if (!(anObj instanceof QueryObject)) {
            return false;
        }
        QueryObject qo = (QueryObject)anObj;
        if (this.aPrimitiveLong != qo.aPrimitiveLong) {
            return false;
        }
        if (!this.aLong.equals(qo.aLong)) {
            return false;
        }
        if (this.aPrimitiveInt != qo.aPrimitiveInt) {
            return false;
        }
        if (!this.anInteger.equals(qo.anInteger)) {
            return false;
        }
        if (this.aPrimitiveShort != qo.aPrimitiveShort) {
            return false;
        }
        if (!this.aShort.equals(qo.aShort)) {
            return false;
        }
        if (this.aPrimitiveFloat != qo.aPrimitiveFloat) {
            return false;
        }
        if (!this.aFloat.equals(qo.aFloat)) {
            return false;
        }
        if (this.aPrimitiveDouble != qo.aPrimitiveDouble) {
            return false;
        }
        if (!this.aDouble.equals(qo.aDouble)) {
            return false;
        }
        if (this.aPrimitiveByte != qo.aPrimitiveByte) {
            return false;
        }
        if (!this.aByte.equals(qo.aByte)) {
            return false;
        }
        if (this.aPrimitiveChar != qo.aPrimitiveChar) {
            return false;
        }
        if (!this.aCharacter.equals(qo.aCharacter)) {
            return false;
        }
        if (this.aPrimitiveBoolean != qo.aPrimitiveBoolean) {
            return false;
        }
        if (!this.aBoolean.equals(qo.aBoolean)) {
            return false;
        }
        if (!this.aString.equals(qo.aString)) {
            return false;
        }
        if (this.aByteArray == null) {
            if (qo.aByteArray != null) {
                return false;
            }
        } else {
            if (qo.aByteArray == null) {
                return false;
            }
            if (this.aByteArray.length != qo.aByteArray.length) {
                return false;
            }
        }
        if (this.aQueryObject == null && qo.aQueryObject != null) {
            return false;
        }
        if (this.aQueryObject != null && qo.aQueryObject == null) {
            return false;
        }
        if (this.aQueryObject != null) {
            return this.aQueryObject.equals(qo.aQueryObject);
        }
        return qo.aQueryObject == null;
    }

    public Object clone() throws CloneNotSupportedException {
        QueryObject qo = (QueryObject)super.clone();
        qo.id = QueryObjectBB.getBB().getSharedCounters().incrementAndRead(QueryObjectBB.QueryObjectID);
        if (qo.aQueryObject != null) {
            qo.aQueryObject = (QueryObject)this.aQueryObject.clone();
        }
        return qo;
    }

    public String toString() {
        return this.toStringAbbreviated();
    }

    public String toStringFull() {
        return this.toString(1);
    }

    private String toString(int level) {
        StringBuffer aStr = new StringBuffer();
        for (int i = 1; i < level; ++i) {
            aStr.append("==");
        }
        aStr.append(this.getClass().getName() + "(" + System.identityHashCode(this) + ") with id " + this.id + " (at level " + level + "), ");
        this.fieldsToString(aStr);
        if (this.aQueryObject == null) {
            aStr.append("aQueryObject: null");
        } else {
            aStr.append("aQueryObject:\n" + this.aQueryObject.toString(level + 1));
        }
        aStr.append("\n");
        return aStr.toString();
    }

    public String constantToString(int constant) {
        if (constant == 1) {
            return "EQUAL_VALUES";
        }
        if (constant == 2) {
            return "SEQUENTIAL_VALUES";
        }
        if (constant == 3) {
            return "RANDOM_VALUES";
        }
        if (constant == 4) {
            return "INCREMENT";
        }
        if (constant == 5) {
            return "NEGATE";
        }
        throw new TestException("Test problem; Unknown constant " + constant);
    }

    public static String toString(List aList) {
        return QueryObject.toString(aList, false);
    }

    public static String toStringFull(List aList) {
        return QueryObject.toString(aList, false);
    }

    public static String toStringAbbreviated(List aList) {
        return QueryObject.toString(aList, true);
    }

    private static String toString(List aList, boolean abbreviated) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("List of size " + aList.size() + "\n");
        for (int i = 0; i < aList.size(); ++i) {
            Object anObj = aList.get(i);
            if (anObj instanceof QueryObject) {
                QueryObject qo = (QueryObject)anObj;
                if (abbreviated) {
                    aStr.append(qo.toStringAbbreviated());
                } else {
                    aStr.append(qo.toStringFull());
                }
            } else {
                aStr.append(anObj);
            }
            aStr.append("\n");
        }
        return aStr.toString();
    }

    public static String toString(Map aMap) {
        return QueryObject.toString(aMap, false);
    }

    public static String toStringFull(Map aMap) {
        return QueryObject.toString(aMap, false);
    }

    public static String toStringAbbreviated(Map aMap) {
        return QueryObject.toString(aMap, true);
    }

    private static String toString(Map aMap, boolean abbreviated) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Map of size " + aMap.size() + "\n");
        for (Object key : aMap.keySet()) {
            Object anObj = aMap.get(key);
            aStr.append(key + "=");
            if (anObj instanceof QueryObject) {
                QueryObject qo = (QueryObject)anObj;
                if (abbreviated) {
                    aStr.append(qo.toStringAbbreviated());
                } else {
                    aStr.append(qo.toStringFull());
                }
            } else {
                aStr.append(anObj);
            }
            aStr.append("\n");
        }
        return aStr.toString();
    }

    public String toStringAbbreviated() {
        QueryObject currentQO = this;
        int levels = 0;
        while (currentQO != null) {
            ++levels;
            currentQO = currentQO.aQueryObject;
        }
        return this.getClass().getName() + " with id " + this.id + " (contains " + levels + " levels, aPrimitiveLong=" + this.aPrimitiveLong + ")";
    }

    public String toStringOneLevel() {
        StringBuffer aStr = new StringBuffer();
        aStr.append(this.getClass().getName() + " with id " + this.id + ", ");
        this.fieldsToString(aStr);
        aStr.append("aQueryObject: " + this.aQueryObject);
        return aStr.toString();
    }

    protected void fieldsToString(StringBuffer aStr) {
        int limit = 50;
        aStr.append("myVersion: " + this.myVersion + ", ");
        aStr.append("aPrimitiveLong: " + this.aPrimitiveLong + ", ");
        aStr.append("aLong: " + this.aLong + ", ");
        aStr.append("aPrimitiveInt: " + this.aPrimitiveInt + ", ");
        aStr.append("anInteger: " + this.anInteger + ", ");
        aStr.append("aPrimitiveShort: " + this.aPrimitiveShort + ", ");
        aStr.append("aShort: " + this.aShort + ", ");
        aStr.append("aPrimitiveFloat: " + this.aPrimitiveFloat + ", ");
        aStr.append("aFloat: " + this.aFloat + ", ");
        aStr.append("aPrimitiveDouble: " + this.aPrimitiveDouble + ", ");
        aStr.append("aDouble: " + this.aDouble + ", ");
        aStr.append("aPrimitiveByte: " + this.aPrimitiveByte + ", ");
        aStr.append("aByte: " + this.aByte + ", ");
        aStr.append("aPrimitiveChar: " + (byte)this.aPrimitiveChar + ", ");
        aStr.append("aCharacter: " + (byte)this.aCharacter.charValue() + "(byte value), ");
        aStr.append("aPrimitiveBoolean: " + this.aPrimitiveBoolean + ", ");
        aStr.append("aBoolean: " + this.aBoolean + ", ");
        if (this.aString.length() <= 50) {
            aStr.append("String: \"" + this.aString + "\", ");
        } else {
            aStr.append("<String of length " + this.aString.length() + " starting with \"" + this.aString.substring(0, 50) + "\">, ");
        }
        if (this.aByteArray == null) {
            aStr.append("byte[]: " + this.aByteArray + ", ");
        } else {
            aStr.append("byte[] of size: " + this.aByteArray.length + ", ");
        }
        aStr.append("extra: " + this.extra + " ");
    }

    public void modify(int changeValueGeneration, int delta, boolean log) {
        if (log) {
            Log.getLogWriter().info("Modifying " + this.toStringFull() + " with " + this.constantToString(changeValueGeneration) + " delta " + delta);
        }
        RandomValues rv = new RandomValues();
        if (this.aLong == null) {
            this.aLong = new Long(rv.getRandom_long());
        }
        if (this.anInteger == null) {
            this.anInteger = new Integer(rv.getRandom_int());
        }
        if (this.aShort == null) {
            this.aShort = new Short(rv.getRandom_short());
        }
        if (this.aFloat == null) {
            this.aFloat = new Float(rv.getRandom_float());
        }
        if (this.aDouble == null) {
            this.aDouble = new Double(rv.getRandom_double());
        }
        if (this.aByte == null) {
            this.aByte = new Byte(rv.getRandom_byte());
        }
        if (this.aCharacter == null) {
            this.aCharacter = new Character(rv.getRandom_char());
        }
        if (this.aBoolean == null) {
            this.aBoolean = new Boolean(rv.getRandom_boolean());
        }
        if (this.aString == null) {
            this.aString = rv.getRandom_String();
        }
        if (changeValueGeneration == 4) {
            this.aPrimitiveLong += (long)delta;
            this.aLong = new Long(this.aLong + (long)delta);
            this.aPrimitiveInt += delta;
            this.anInteger = new Integer(this.anInteger + delta);
            this.aPrimitiveShort = (short)(this.aPrimitiveShort + delta);
            this.aShort = new Short((short)(this.aShort + delta));
            this.aPrimitiveFloat += (float)delta;
            this.aFloat = new Float(this.aFloat.floatValue() + (float)delta);
            this.aPrimitiveDouble += (double)delta;
            this.aDouble = new Double(this.aDouble + (double)delta);
            this.aPrimitiveByte = (byte)(this.aPrimitiveByte + delta);
            this.aByte = new Byte((byte)(this.aByte + delta));
            this.aPrimitiveChar = (char)((byte)this.aPrimitiveChar + delta);
            this.aCharacter = new Character((char)((byte)this.aCharacter.charValue() + delta));
            this.aPrimitiveBoolean = !this.aPrimitiveBoolean;
            this.aBoolean = new Boolean(this.aBoolean == false);
            try {
                this.aString = "" + (Long.valueOf(this.aString) + (long)delta);
            }
            catch (NumberFormatException e) {
                this.aString = rv.getRandom_String();
            }
        } else if (changeValueGeneration == 5) {
            this.aPrimitiveLong = -this.aPrimitiveLong;
            this.aLong = new Long(-this.aLong.longValue());
            this.aPrimitiveInt = -this.aPrimitiveInt;
            this.anInteger = new Integer(-this.anInteger.intValue());
            this.aPrimitiveShort = -this.aPrimitiveShort;
            this.aShort = new Short(-this.aShort.shortValue());
            this.aPrimitiveFloat = -this.aPrimitiveFloat;
            this.aFloat = new Float(-this.aFloat.floatValue());
            this.aPrimitiveDouble = -this.aPrimitiveDouble;
            this.aDouble = new Double(-this.aDouble.doubleValue());
            this.aPrimitiveByte = -this.aPrimitiveByte;
            this.aByte = new Byte(-this.aByte.byteValue());
            this.aPrimitiveChar = (char)(-((byte)this.aPrimitiveChar));
            this.aCharacter = new Character((char)(-((byte)this.aCharacter.charValue())));
            this.aPrimitiveBoolean = !this.aPrimitiveBoolean;
            this.aBoolean = new Boolean(this.aBoolean == false);
            try {
                this.aString = new String("" + -Long.valueOf(this.aString).longValue());
            }
            catch (NumberFormatException e) {
                this.aString = rv.getRandom_String();
            }
        } else if (changeValueGeneration == 5) {
            this.aLong = null;
            this.anInteger = null;
            this.aShort = null;
            this.aFloat = null;
            this.aDouble = null;
            this.aByte = null;
            this.aCharacter = null;
            this.aBoolean = null;
            this.aString = null;
        } else {
            throw new TestException("unknown changeValueGeneration " + changeValueGeneration);
        }
        if (log) {
            Log.getLogWriter().info("Done modifying " + this.toStringFull() + " with " + this.constantToString(changeValueGeneration) + " delta is " + delta);
        }
    }

    public QueryObject modifyWithNewInstance(int changeValueGeneration, int delta, boolean log) {
        Log.getLogWriter().info("Creating a new copy (to modify) of " + this.toStringAbbreviated());
        try {
            QueryObject qo = (QueryObject)this.clone();
            Log.getLogWriter().info("Created " + qo.toStringAbbreviated() + ", which is a copy of " + this.toStringAbbreviated());
            qo.modify(changeValueGeneration, delta, log);
            Log.getLogWriter().info("Created modified copy: " + qo.toStringFull());
            return qo;
        }
        catch (CloneNotSupportedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public void modify(int depth, int changeValueGeneration, int delta, boolean randomDepth, boolean log) {
        int modifyDepth = depth;
        if (randomDepth) {
            modifyDepth = new Random().nextInt(depth) + 1;
        }
        if (log) {
            Log.getLogWriter().info("Modifying " + this.toStringFull() + " at depth " + modifyDepth);
        }
        QueryObject qo = this.getAtDepth(modifyDepth);
        qo.modify(changeValueGeneration, delta, log);
    }

    public QueryObject modifyWithNewInstance(int depth, int changeValueGeneration, int delta, boolean randomDepth, boolean log) {
        try {
            QueryObject qo = (QueryObject)this.clone();
            Log.getLogWriter().info("Created " + qo.toStringAbbreviated() + ", which is a copy of " + this.toStringAbbreviated());
            qo.modify(depth, changeValueGeneration, delta, randomDepth, log);
            Log.getLogWriter().info("Created modified copy: " + qo.toStringFull());
            return qo;
        }
        catch (CloneNotSupportedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public int depth() {
        int depth = 1;
        QueryObject currentQO = this;
        while (currentQO.aQueryObject != null) {
            ++depth;
            currentQO = currentQO.aQueryObject;
        }
        return depth;
    }

    public QueryObject getAtDepth(int depth) {
        QueryObject currentQO = this;
        for (int i = 2; i <= depth; ++i) {
            if (currentQO == null) {
                return null;
            }
            currentQO = currentQO.aQueryObject;
        }
        return currentQO;
    }

    public boolean hasEqualId(QueryObject anObj) {
        return this.id == anObj.id;
    }

    public int compareTo(Object anObj) {
        QueryObject qo = (QueryObject)anObj;
        if (this.id < qo.id) {
            return -1;
        }
        if (this.id == qo.id) {
            return 0;
        }
        return 1;
    }

    public static void main(String[] args) throws Exception {
        QueryObject qo1 = new QueryObject(1L, 1, 4, 3);
        System.out.println("qo1 is " + qo1 + "\n");
        QueryObject qo2 = new QueryObject(1L, 2, 4, 3);
        System.out.println("qo2 is " + qo2 + "\n");
        QueryObject qo3 = new QueryObject(4113L, 2, 0, 3);
        QueryObject qo4 = new QueryObject(4113L, 2, 0, 6);
        System.out.println("qo3 equals qo4: " + qo3.equals(qo4));
        System.out.println("qo4 equals qo3: " + qo4.equals(qo3));
        System.out.println("qo3 hashcode: " + qo3.hashCode());
        System.out.println("qo4 hashcode: " + qo4.hashCode());
    }
}

