/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.BackupStatus;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.internal.util.IOUtils;
import hydra.DiskStorePrms;
import hydra.DistributedSystemHelper;
import hydra.HostHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.TestConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import management.test.cli.CommandTest;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import util.AdminHelper;
import util.CliHelper;
import util.CliHelperPrms;
import util.PersistenceBB;
import util.TestException;
import util.TestHelper;

public class PersistenceUtil {
    public static final Pattern DISK_STORE_ID = Pattern.compile("^([0-9a-f\\-]+) \\[(.*):(.*)\\]$");

    public static void HydraTask_doOfflineValAndCompactionOnce() {
        long leader = PersistenceBB.getBB().getSharedCounters().incrementAndRead(PersistenceBB.offlineToolLeader);
        Log.getLogWriter().info("Leader is " + leader);
        if (leader != 1L) {
            return;
        }
        if (HostHelper.isWindows() && !CliHelperPrms.getUseCli()) {
            Log.getLogWriter().info("Not running off line val and compaction on windows to avoid bug 42432");
            return;
        }
        PersistenceUtil.doOfflineValAndCompaction();
    }

    public static void HydraTask_doOfflineExportOnce() {
        long leader = PersistenceBB.getBB().getSharedCounters().incrementAndRead(PersistenceBB.offlineToolLeader);
        if (leader != 1L) {
            return;
        }
        if (HostHelper.isWindows()) {
            Log.getLogWriter().info("Not running off line val and compaction on windows to avoid bug 42432");
            return;
        }
        PersistenceUtil.doOfflineExport();
    }

    public static void HydraTask_initialize() {
        PersistenceBB.getBB().getSharedCounters().zero(PersistenceBB.offlineToolLeader);
    }

    public static void doOfflineValAndCompaction() {
        Log.getLogWriter().info("Running offline tools...");
        Map<Integer, List<File>> diskDirMap = PersistenceUtil.getDiskDirMap();
        Log.getLogWriter().info("diskDirMap is " + diskDirMap);
        for (Integer vmID : diskDirMap.keySet()) {
            List<File> diskDirList = diskDirMap.get(vmID);
            File[] diskDirArr = diskDirList.toArray(new File[0]);
            PersistenceUtil.scramble(diskDirArr);
            for (File diskDir : diskDirArr) {
                String[] diskDirFileNames;
                for (String diskFileName : diskDirFileNames = diskDir.list()) {
                    String searchStr1 = "BACKUP";
                    String searchStr2 = ".if";
                    if (!diskFileName.startsWith(searchStr1) || !diskFileName.endsWith(searchStr2)) continue;
                    int index1 = diskFileName.indexOf(searchStr1);
                    int index2 = diskFileName.indexOf(searchStr2);
                    String diskStoreName = diskFileName.substring(index1 + searchStr1.length(), index2);
                    PersistenceUtil.runOfflineValAndCompaction(diskStoreName, diskDirArr);
                }
            }
        }
    }

    public static Set<String> getDiskStores() {
        Log.getLogWriter().info("Getting list of diskStores...");
        Map<Integer, List<File>> diskDirMap = PersistenceUtil.getDiskDirMap();
        Log.getLogWriter().info("diskDirMap is " + diskDirMap);
        HashSet<String> diskStores = new HashSet<String>();
        for (Integer vmID : diskDirMap.keySet()) {
            File[] diskDirArr;
            List<File> diskDirList = diskDirMap.get(vmID);
            for (File diskDir : diskDirArr = diskDirList.toArray(new File[0])) {
                String[] diskDirFileNames;
                for (String diskFileName : diskDirFileNames = diskDir.list()) {
                    String searchStr1 = "BACKUP";
                    String searchStr2 = ".if";
                    if (!diskFileName.startsWith(searchStr1) || !diskFileName.endsWith(searchStr2)) continue;
                    int index1 = diskFileName.indexOf(searchStr1);
                    int index2 = diskFileName.indexOf(searchStr2);
                    String diskStoreName = diskFileName.substring(index1 + searchStr1.length(), index2);
                    diskStores.add(diskStoreName);
                }
            }
        }
        Log.getLogWriter().info("Returning list of diskStores: " + diskStores);
        return diskStores;
    }

    public static void doOfflineExport() {
        Log.getLogWriter().info("Running offline export ...");
        Map<Integer, List<File>> diskDirMap = PersistenceUtil.getDiskDirMap();
        Log.getLogWriter().info("diskDirMap is " + diskDirMap);
        Object[] vmIds = diskDirMap.keySet().toArray();
        for (int i = 0; i < vmIds.length; ++i) {
            File[] diskDirArr;
            Integer vmid = (Integer)vmIds[i];
            List<File> diskDirList = diskDirMap.get(vmid);
            for (File diskDir : diskDirArr = diskDirList.toArray(new File[0])) {
                String[] diskDirFileNames;
                for (String diskFileName : diskDirFileNames = diskDir.list()) {
                    String searchStr1 = "BACKUP";
                    String searchStr2 = ".if";
                    if (!diskFileName.startsWith(searchStr1) || !diskFileName.endsWith(searchStr2)) continue;
                    int index1 = diskFileName.indexOf(searchStr1);
                    int index2 = diskFileName.indexOf(searchStr2);
                    String diskStoreName = diskFileName.substring(index1 + searchStr1.length(), index2);
                    PersistenceUtil.runOfflineExport(vmid, diskStoreName, diskDirArr);
                }
            }
        }
    }

    public static void runOfflineExport(Integer vmid, String diskStoreName, File[] diskDirArr) {
        String diskDirStr = "";
        for (File diskDir : diskDirArr) {
            diskDirStr = diskDirStr + diskDir.getAbsolutePath() + " ";
        }
        String exeName = "gemfire";
        String command = "env GF_JAVA=" + System.getProperty("java.home") + "/bin/java ";
        if (HostHelper.isWindows()) {
            exeName = "gemfire.bat";
            command = "cmd /c set GF_JAVA=" + System.getProperty("java.home") + "/bin/java.exe && cmd /c ";
        }
        command = command + System.getProperty("gemfire.home") + File.separator + "bin" + File.separator + exeName + " export-disk-store " + diskStoreName + " " + diskDirStr + " -outputDir=snapshotDir_" + vmid;
        Log.getLogWriter().info("Calling offline export with command " + command);
        String result = ProcessMgr.fgexec(command, 0);
        Log.getLogWriter().info("Done calling offline export, result is " + result);
    }

    public static Map<Integer, List<File>> getDiskDirMap() {
        File[] currDirContents;
        HashMap<Integer, List<File>> aMap = new HashMap<Integer, List<File>>();
        String currDirName = System.getProperty("user.dir");
        File currDir = new File(currDirName);
        for (File fileInCurrDir : currDirContents = currDir.listFiles()) {
            String fileName = fileInCurrDir.getName();
            if (!fileInCurrDir.isDirectory() || fileName.indexOf("_disk_") < 0) continue;
            String searchStr = "vm_";
            int index1 = fileName.indexOf(searchStr);
            if (index1 >= 0) {
                int index2 = fileName.indexOf("_", searchStr.length());
                if (index2 >= 0) {
                    Integer vmID = Integer.valueOf(fileName.substring(searchStr.length(), index2));
                    ArrayList<File> aList = (ArrayList<File>)aMap.get(vmID);
                    if (aList == null) {
                        aList = new ArrayList<File>();
                        aMap.put(vmID, aList);
                    }
                    aList.add(fileInCurrDir);
                    continue;
                }
                throw new TestException("Test error; unexpected disk dir name format " + fileName);
            }
            throw new TestException("Test error; unexpected disk dir name format " + fileName);
        }
        return aMap;
    }

    protected static void scramble(File[] fileArr) {
        if (fileArr.length == 1) {
            return;
        }
        for (int i = 0; i < fileArr.length; ++i) {
            int randInt = TestConfig.tab().getRandGen().nextInt(0, fileArr.length - 1);
            File tmp = fileArr[i];
            fileArr[i] = fileArr[randInt];
            fileArr[randInt] = tmp;
        }
    }

    public static boolean diskDirsContainInfoFile(List<File> diskDirList, String diskStoreName) {
        for (File diskDir : diskDirList) {
            File[] contents;
            for (File diskFile : contents = diskDir.listFiles()) {
                String diskFileName = diskFile.getName();
                if (!diskFileName.endsWith(".if") || diskFileName.indexOf(diskStoreName) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void runOfflineValAndCompaction(String diskStoreName, File[] diskDirArr) {
        HydraVector diskStoreNames = TestConfig.tab().vecAt(DiskStorePrms.names);
        int i = diskStoreNames.indexOf(diskStoreName);
        HydraVector maxOpLogSizes = TestConfig.tab().vecAt(DiskStorePrms.maxOplogSize, new HydraVector());
        long opLogSize = 0L;
        opLogSize = maxOpLogSizes.size() == 0 || i < 0 || i >= maxOpLogSizes.size() ? DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE : Long.valueOf((String)maxOpLogSizes.get(i));
        try {
            Object[] tmp = PersistenceUtil.runOfflineValidate(diskStoreName, diskDirArr);
            String beforeCompactionStr = (String)tmp[0];
            Map beforeCompactionMap = (Map)tmp[1];
            Log.getLogWriter().info("Before compaction, results map is " + beforeCompactionMap);
            PersistenceUtil.runOfflineCompaction(diskStoreName, diskDirArr, opLogSize);
            tmp = PersistenceUtil.runOfflineValidate(diskStoreName, diskDirArr);
            String afterCompactionStr = (String)tmp[0];
            Map afterCompactionMap = (Map)tmp[1];
            Log.getLogWriter().info("After compaction, results map is " + afterCompactionMap);
            if (!beforeCompactionMap.equals(afterCompactionMap)) {
                throw new TestException("Before compaction, validator results was " + beforeCompactionStr + " and after compaction, validator results is " + afterCompactionStr + ", but expect validator results for entryCount/bucketCount to be equal");
            }
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private static void runOfflineCompaction(String diskStoreName, File[] diskDirArr, long opLogSize) {
        String diskDirStr = "";
        for (File diskDir : diskDirArr) {
            diskDirStr = diskDirStr + diskDir.getAbsolutePath() + " ";
        }
        String result = null;
        if (CliHelperPrms.getUseCli()) {
            boolean connected = false;
            CliHelper.execCommand("StartNewCLI", true);
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                CliHelper.execCommand("ConnectCLI", true);
                connected = true;
            }
            String command = "compact offline-disk-store --name=" + diskStoreName + " --disk-dirs=" + diskDirStr + " --max-oplog-size=" + opLogSize;
            result = CliHelper.execCommand(command, true)[1];
            if (!connected) {
                CliHelper.execCommand("ConnectCLI", true);
            }
        } else {
            String exeName = "gemfire";
            String command = "env GF_JAVA=" + System.getProperty("java.home") + "/bin/java ";
            if (HostHelper.isWindows()) {
                exeName = "gemfire.bat";
                command = "cmd /c set GF_JAVA=" + System.getProperty("java.home") + "/bin/java.exe && cmd /c ";
            }
            command = command + System.getProperty("gemfire.home") + File.separator + "bin" + File.separator + exeName + " compact-disk-store " + diskStoreName + " " + diskDirStr + "-maxOplogSize=" + opLogSize;
            Log.getLogWriter().info("Calling offline compaction tool with diskStoreName " + diskStoreName + ", disk dirs " + diskDirStr + " and opLogSize " + opLogSize);
            result = ProcessMgr.fgexec(command, 0);
            Log.getLogWriter().info("Done calling offline compaction tool, result is " + result);
        }
        if (result.indexOf("Offline compaction") < 0) {
            throw new TestException("Offline compaction tool returned " + result);
        }
    }

    public static Object[] runOfflineValidate(String diskStoreName, File[] diskDirArr) {
        String diskDirStr = "";
        for (File diskDir : diskDirArr) {
            diskDirStr = diskDirStr + diskDir.getAbsolutePath() + " ";
        }
        if (CliHelperPrms.getUseCli()) {
            CliHelper.execCommand("StartNewCLI", true);
            String command = "validate offline-disk-store --name=" + diskStoreName + " --disk-dirs=" + diskDirStr;
            String offlineResult = CliHelper.execCommand(command, true)[1];
            CliHelper.execCommand("ConnectCLI", true);
            String onlineResult = CliHelper.execCommand(command, true)[1];
            if (!offlineResult.equals(onlineResult)) {
                throw new TestException("Expected " + command + " output when offline to be the same as  when online, but they are different. Offline results: " + offlineResult + ", online results: " + onlineResult);
            }
            return new Object[]{offlineResult, PersistenceUtil.getValidateResultsMap(offlineResult)};
        }
        String exeName = "gemfire";
        String command = "env GF_JAVA=" + System.getProperty("java.home") + "/bin/java ";
        if (HostHelper.isWindows()) {
            exeName = "gemfire.bat";
            command = "cmd /c set GF_JAVA=" + System.getProperty("java.home") + "/bin/java.exe && cmd /c ";
        }
        command = command + System.getProperty("gemfire.home") + File.separator + "bin" + File.separator + exeName + " validate-disk-store " + diskStoreName + " " + diskDirStr;
        Log.getLogWriter().info("Calling offline validate tool with diskStoreName " + diskStoreName + " and disk dirs " + diskDirStr);
        String result = ProcessMgr.fgexec(command, 0);
        Log.getLogWriter().info("Done calling offline validate tool, result is " + result);
        return new Object[]{result, PersistenceUtil.getValidateResultsMap(result)};
    }

    private static Map<String, Map<String, Integer>> getValidateResultsMap(String resultsStr) {
        TreeMap<String, Map<String, Integer>> resultMap = new TreeMap<String, Map<String, Integer>>();
        String[] tokens = resultsStr.split("[\\s]+");
        int calculatedEntryCountTotal = 0;
        for (int tokensIndex = 0; tokensIndex < tokens.length; ++tokensIndex) {
            String token = tokens[tokensIndex];
            if (token.startsWith("/")) {
                token = token.split(":")[0];
                if (tokensIndex + 2 >= tokens.length) continue;
                String entryCountToken = tokens[tokensIndex + 1];
                String bucketCountToken = tokens[tokensIndex + 2];
                try {
                    int entryCount = -1;
                    int bucketCount = 0;
                    int i = entryCountToken.indexOf("=");
                    if (i > 0) {
                        entryCount = Integer.valueOf(entryCountToken.substring(i + 1, entryCountToken.length()));
                    }
                    if ((i = bucketCountToken.indexOf("=")) > 0) {
                        bucketCount = Integer.valueOf(bucketCountToken.substring(i + 1), bucketCountToken.length());
                    }
                    if (entryCount < 0 || bucketCount < 0) {
                        throw new TestException("Results from offline validator not in expected form  or had negative entryCount or negative bucketCount: " + resultsStr);
                    }
                    TreeMap<String, Integer> countMap = new TreeMap<String, Integer>();
                    countMap.put("entryCount", entryCount);
                    countMap.put("bucketCount", bucketCount);
                    resultMap.put(token, countMap);
                    calculatedEntryCountTotal += entryCount;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new TestException("entryCount/bucketCount results from offline validator  not in expected format: " + resultsStr);
                }
            }
            if (!token.equals("Total") || tokensIndex + 10 >= tokens.length) continue;
            String line = token;
            for (int i = 1; i <= 9; ++i) {
                line = line + " " + tokens[tokensIndex + i];
            }
            if (!line.equals("Total number of region entries in this disk store is:")) continue;
            try {
                int totalFromResults = Integer.valueOf(tokens[tokensIndex + 10]);
                if (totalFromResults == calculatedEntryCountTotal) continue;
                throw new TestException("Total of entryCounts for each region (" + calculatedEntryCountTotal + ") is not equal to the reported total " + totalFromResults + "\n" + resultsStr);
            }
            catch (NumberFormatException e) {
                throw new TestException("Totals reported by validator not in expected format: " + resultsStr);
            }
        }
        int index = resultsStr.indexOf("Total number of region entries in this disk store is: ");
        if (index < 0) {
            throw new TestException("Result from offline validator did not include expected totals line: " + resultsStr);
        }
        return resultMap;
    }

    private static String getBackupDir(long counter) {
        File backupDir = new File("backup_" + counter);
        if (!backupDir.exists()) {
            throw new TestException("PersistenceUtil#getBackupDir: Backup directory " + backupDir.getName() + " does not exist.");
        }
        File[] files = backupDir.listFiles();
        if (null == files || files.length != 1) {
            throw new TestException("PersistenceUtil#getBackupDir: Backup directory " + backupDir.getName() + " is malformed or is not a directory");
        }
        return IOUtils.tryGetCanonicalFileElseGetAbsoluteFile((File)files[0]).getAbsolutePath();
    }

    public static void doOnlineBackup(boolean incremental) {
        long counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.onlineBackupNumber);
        String dirName = "backup_" + counter;
        File dir = new File(dirName);
        String baselineDir = incremental ? PersistenceUtil.getBackupDir(counter - 1L) : null;
        dir.mkdir();
        if (CliHelperPrms.getUseCli()) {
            if (incremental) {
                CliHelper.execCommand("backup disk-store --dir=" + dirName + " --baseline-dir=" + baselineDir, true);
            } else {
                CliHelper.execCommand("backup disk-store --dir=" + dirName, true);
            }
        } else {
            if (counter % 2L == 1L && !HostHelper.isWindows()) {
                String exeName = "gemfire";
                String command = "env GF_JAVA=" + System.getProperty("java.home") + "/bin/java ";
                if (HostHelper.isWindows()) {
                    exeName = "gemfire.bat";
                    command = "cmd /c set GF_JAVA=" + System.getProperty("java.home") + "/bin/java.exe && cmd /c ";
                }
                Properties p = DistributedSystemHelper.getDistributedSystem().getProperties();
                Object mcastPort = p.get("mcast-port");
                Object locators = p.get("locators");
                command = command + System.getProperty("gemfire.home") + File.separator + "bin" + File.separator + exeName + " -J-Dgemfire.mcast-port=" + mcastPort + " -J-Dgemfire.locators=" + locators + " backup ";
                String incrementalOption = incremental ? "-baseline=" + baselineDir + " " : "";
                command = command + incrementalOption + dirName;
                Log.getLogWriter().info("Calling online backup tool from command line tool...");
                String result = ProcessMgr.fgexec(command, 0);
                Log.getLogWriter().info("Done calling online backup tool, result is " + result);
                if (result.indexOf("Backup successful") < 0) {
                    throw new TestException("On line backup was not successful, result from online backup is " + result);
                }
            } else {
                try {
                    Log.getLogWriter().info("Calling online backup tool from admin API...");
                    BackupStatus bStatus = null;
                    bStatus = incremental ? AdminHelper.getAdminDistributedSystem().backupAllMembers(dir, new File(baselineDir)) : AdminHelper.getAdminDistributedSystem().backupAllMembers(dir);
                    Map backedUp = bStatus.getBackedUpDiskStores();
                    Set offline = bStatus.getOfflineDiskStores();
                    Log.getLogWriter().info("Done calling online backup tool from admin API, backed up disk stores " + backedUp);
                    Log.getLogWriter().info("Done calling online backup tool from admin API, offline disk stores: " + offline);
                    Set keySet = backedUp.keySet();
                    if (keySet.contains(null)) {
                        throw new TestException("BackupStatus.getBackedUpDiskStores contains a null key: " + backedUp);
                    }
                    if (offline.size() != 0) {
                        throw new TestException("Expected BackupStatus.getOfflineDiskStores set to be empty, but it is " + offline);
                    }
                }
                catch (AdminException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
            if (HostHelper.isWindows()) {
                Log.getLogWriter().info("Not running offline val and compaction on windows to avoid bug 42432");
                return;
            }
        }
        if (!ParRegPrms.getDoIncrementalBackup()) {
            PersistenceUtil.runOfflineValAndCompactionOnBackup(dir);
        }
    }

    private static void runOfflineValAndCompactionOnBackup(File backupDir) {
        File[] dirContents = backupDir.listFiles();
        if (dirContents.length != 1) {
            throw new TestException("Expected dirContents to be size 1, but it is size " + dirContents.length);
        }
        for (File hostAndPidDir : dirContents = dirContents[0].listFiles()) {
            File[] hostAndPidDirContents;
            for (File aFile : hostAndPidDirContents = hostAndPidDir.listFiles()) {
                File[] diskStoresContents;
                if (!aFile.getName().equals("diskstores")) continue;
                for (File diskStoreDir : diskStoresContents = aFile.listFiles()) {
                    String diskStoreName = diskStoreDir.getName();
                    int index = diskStoreName.indexOf("_");
                    if (index < 0) {
                        throw new TestException("Test problem, unable to obtain disk store name from " + diskStoreName);
                    }
                    diskStoreName = diskStoreName.substring(0, index);
                    File[] diskDirs = diskStoreDir.listFiles();
                    PersistenceUtil.scramble(diskDirs);
                    PersistenceUtil.runOfflineValAndCompaction(diskStoreName, diskDirs);
                }
            }
        }
    }

    public static String runListMissingDiskStores() {
        String[] elements;
        if (CliHelperPrms.getUseCli()) {
            String command = "show missing-disk-stores";
            String result = CommandTest.testInstance.execCommand(command, true)[1];
            return result;
        }
        String exeName = "gemfire";
        String command = "env GF_JAVA=" + System.getProperty("java.home") + "/bin/java ";
        if (HostHelper.isWindows()) {
            exeName = "gemfire.bat";
            command = "cmd /c set GF_JAVA=" + System.getProperty("java.home") + "/bin/java.exe && cmd /c ";
        }
        Properties p = DistributedSystemHelper.getDistributedSystem().getProperties();
        Object mcastPort = p.get("mcast-port");
        Object locators = p.get("locators");
        command = command + System.getProperty("gemfire.home") + File.separator + "bin" + File.separator + exeName + " -J-Dgemfire.mcast-port=" + mcastPort + " -J-Dgemfire.locators=" + locators + " list-missing-disk-stores";
        Log.getLogWriter().info("Calling list-missing-disk-stores from command line tool...");
        String result = ProcessMgr.fgexec(command, 0);
        Log.getLogWriter().info("Done calling list-missing-disk-stores tool, result is " + result);
        for (String line : elements = result.split("\n")) {
            if (line.startsWith("Connecting to distributed system") || DISK_STORE_ID.matcher(line).matches()) continue;
            throw new TestException("Unexpected output from list-missing-disk-stores: " + result);
        }
        return result;
    }

    public static void runRevokeMissingDiskStore(PersistentID id) {
        String result = null;
        if (CliHelperPrms.getUseCli()) {
            String command = "revoke missing-disk-store --id=" + id.getUUID().toString();
            result = CommandTest.testInstance.execCommand(command, true)[1];
            if (result.indexOf("Missing disk store successfully revoked") < 0) {
                throw new TestException("Unexpected result: " + result + ", from command " + command);
            }
        } else {
            String[] elements;
            String exeName = "gemfire";
            String command = "env GF_JAVA=" + System.getProperty("java.home") + "/bin/java ";
            if (HostHelper.isWindows()) {
                exeName = "gemfire.bat";
                command = "cmd /c set GF_JAVA=" + System.getProperty("java.home") + "/bin/java.exe && cmd /c ";
            }
            Properties p = DistributedSystemHelper.getDistributedSystem().getProperties();
            Object mcastPort = p.get("mcast-port");
            Object locators = p.get("locators");
            String uuid = id.getUUID().toString();
            command = command + System.getProperty("gemfire.home") + File.separator + "bin" + File.separator + exeName + " -J-Dgemfire.mcast-port=" + mcastPort + " -J-Dgemfire.locators=" + locators + " revoke-missing-disk-store " + uuid;
            Log.getLogWriter().info("Calling revoke-missing-disk-store from command line tool...");
            result = ProcessMgr.fgexec(command, 0);
            Log.getLogWriter().info("Done calling revoke-missing-disk-store tool, result is " + result);
            int index = result.indexOf("The following disk stores are still missing:");
            if (result.indexOf(uuid, index) >= 0) {
                throw new TestException("revoke-missing-disk-store command line tool revoked " + uuid + ", but command results shows it is still missing: " + result);
            }
            for (String line : elements = result.split("\n")) {
                if (line.startsWith("Connecting to distributed system") || line.startsWith("The following disk stores are still missing:") || DISK_STORE_ID.matcher(line).matches() || line.startsWith("revocation was successful and no disk stores are now missing")) continue;
                throw new TestException("Unexpected output from revoke-missing-disk-stores: " + result);
            }
        }
        if (result.indexOf("The following disk stores are still missing:") >= 0 && result.indexOf("revocation was successful and no disk stores are now missing") >= 0) {
            throw new TestException("Result of revoke-missing-disk-stores reports disk stores are still missing AND no disk stores are missing, result is " + result);
        }
    }
}

