/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.cache.Region;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import util.NameBB;
import util.NameFactoryVersion;
import util.TestException;
import util.TestHelper;

public class NameFactory {
    public static final String OBJECT_NAME_PREFIX = NameFactoryVersion.getObjectNamePrefix();
    public static final String REGION_NAME_PREFIX = NameFactoryVersion.getRegionNamePrefix();
    public static final String LISTENER_NAME_PREFIX = NameFactoryVersion.getListenerNamePrefix();

    public static String getNextListenerName() {
        long counter = NameBB.getBB().incrementAndRead(NameBB.LISTENER_NAME_COUNTER);
        String name = LISTENER_NAME_PREFIX + counter;
        return name;
    }

    public static String getNextRegionName() {
        long counter = NameBB.getBB().incrementAndRead(NameBB.REGION_NAME_COUNTER);
        String name = REGION_NAME_PREFIX + counter;
        return name;
    }

    public static String getObjectNameForCounter(long counter) {
        String name = OBJECT_NAME_PREFIX + counter;
        return name;
    }

    public static String getNextPositiveObjectName() {
        long counter = NameBB.getBB().incrementAndRead(NameBB.POSITIVE_NAME_COUNTER);
        return NameFactory.getObjectNameForCounter(counter);
    }

    public static String getNextPositiveObjectNameInLimit(int limit) {
        long counter = NameBB.getBB().incrementAndRead(NameBB.POSITIVE_NAME_COUNTER);
        return NameFactory.getObjectNameForCounter(counter % (long)limit);
    }

    public static String getNextNegativeObjectName() {
        long counter = NameBB.getBB().decrementAndRead(NameBB.NEGATIVE_NAME_COUNTER);
        return NameFactory.getObjectNameForCounter(counter);
    }

    public static long getPositiveNameCounter() {
        long positiveCounter = NameBB.getBB().read(NameBB.POSITIVE_NAME_COUNTER);
        return positiveCounter;
    }

    public static long getNegativeNameCounter() {
        long negativeCounter = NameBB.getBB().read(NameBB.NEGATIVE_NAME_COUNTER);
        return negativeCounter;
    }

    public static long getTotalNameCounter() {
        long positiveCounter = NameBB.getBB().read(NameBB.POSITIVE_NAME_COUNTER);
        long negativeCounter = NameBB.getBB().read(NameBB.NEGATIVE_NAME_COUNTER);
        long numNames = positiveCounter + Math.abs(negativeCounter);
        return numNames;
    }

    public static String getKeySetDiscrepancies(Region aRegion, Set keySet) {
        long positiveCounter = NameBB.getBB().read(NameBB.POSITIVE_NAME_COUNTER);
        long negativeCounter = NameBB.getBB().read(NameBB.NEGATIVE_NAME_COUNTER);
        return NameFactory.getKeySetDiscrepancies(aRegion, keySet, (int)positiveCounter, (int)negativeCounter, new HashMap());
    }

    public static String getKeySetDiscrepancies(Region aRegion, Set keySet, Map ignoreMap) {
        long positiveCounter = NameBB.getBB().read(NameBB.POSITIVE_NAME_COUNTER);
        long negativeCounter = NameBB.getBB().read(NameBB.NEGATIVE_NAME_COUNTER);
        return NameFactory.getKeySetDiscrepancies(aRegion, keySet, (int)positiveCounter, (int)negativeCounter, ignoreMap);
    }

    public static String getKeySetDiscrepancies(Region aRegion, Set keySet, int positiveCounter, int negativeCounter) {
        return NameFactory.getKeySetDiscrepancies(aRegion, keySet, positiveCounter, negativeCounter, new HashMap());
    }

    public static String getKeySetDiscrepancies(Region aRegion, Set keySet, int positiveCounter, int negativeCounter, Map ignoreMap) {
        int i;
        StringBuffer aStr = new StringBuffer();
        boolean[] foundPositiveName = new boolean[positiveCounter + 1];
        boolean[] foundNegativeName = new boolean[0 - negativeCounter + 1];
        Iterator it = keySet.iterator();
        if (!it.hasNext() && keySet.size() != 0) {
            aStr.append(" keySet size is " + keySet.size() + ", but keySet.iterator().hasNext() is " + it.hasNext());
        }
        while (it.hasNext()) {
            boolean inRange;
            Object name = it.next();
            if (ignoreMap.get(name) != null) continue;
            int nameCounter = new Integer(((String)name).substring(OBJECT_NAME_PREFIX.length()));
            int arrayIndex = Math.abs(nameCounter);
            int arrayLimit = nameCounter > 0 ? positiveCounter : Math.abs(negativeCounter);
            boolean bl = inRange = arrayIndex <= arrayLimit;
            if (!inRange) {
                try {
                    aStr.append("Name " + name + " with value " + TestHelper.toString(aRegion.get(name)) + " was found in the key set of " + TestHelper.regionToString(aRegion, false) + ", but it was not expected\n");
                    continue;
                }
                catch (Exception e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
            if (nameCounter > 0) {
                foundPositiveName[arrayIndex] = true;
                continue;
            }
            foundNegativeName[arrayIndex] = true;
        }
        for (i = 1; i <= positiveCounter; ++i) {
            if (foundPositiveName[i]) continue;
            aStr.append("Name " + NameFactory.getObjectNameForCounter(i) + " was expected in key set, but was not found\n");
        }
        for (i = 1; i <= 0 - negativeCounter; ++i) {
            if (foundNegativeName[i]) continue;
            aStr.append("Name " + NameFactory.getObjectNameForCounter(0 - i) + " was expected in key set, but was not found\n");
        }
        return aStr.toString();
    }

    public static long getCounterForName(Object name) {
        if (!(name instanceof String)) {
            throw new TestException("Unable to get counter for name (expected String) " + TestHelper.toString(name));
        }
        String nameStr = new String((String)name);
        if ((nameStr = nameStr.trim()).indexOf(OBJECT_NAME_PREFIX) >= 0) {
            return new Long(nameStr.substring(OBJECT_NAME_PREFIX.length()));
        }
        if (nameStr.indexOf(REGION_NAME_PREFIX) >= 0) {
            return new Long(nameStr.substring(REGION_NAME_PREFIX.length()));
        }
        throw new TestException("Unable to get counter for name " + name);
    }

    static TreeSet getOrderedKeySet(Set keySet) {
        class NameComparator
        implements Comparator {
            NameComparator() {
            }

            public int compare(Object o1, Object o2) {
                Long aLong1 = new Long(((String)o1).substring(OBJECT_NAME_PREFIX.length()));
                Long aLong2 = new Long(((String)o2).substring(OBJECT_NAME_PREFIX.length()));
                return aLong1.compareTo(aLong2);
            }

            @Override
            public boolean equals(Object anObj) {
                return anObj.equals(this);
            }
        }
        TreeSet aSet = new TreeSet(new NameComparator());
        aSet.addAll(keySet);
        return aSet;
    }
}

