/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Scope;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedMap;
import util.CachePrms;
import util.TestHelper;

public class CacheBB
extends Blackboard {
    static String CACHE_BB_NAME = "Cache_Blackboard";
    static String CACHE_BB_TYPE = "RMI";
    private static CacheBB bbInstance = null;
    static String SCOPE = "ScopeAttribute";
    static String MIRROR = "MirrorAttribute";
    static String DATA_POLICY = "DataPolicyAttribute";
    public static int MAX_GET_TIME_NANOS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheBB getBB() {
        if (bbInstance != null) return bbInstance;
        Class<CacheBB> clazz = CacheBB.class;
        synchronized (CacheBB.class) {
            if (bbInstance != null) return bbInstance;
            bbInstance = new CacheBB(CACHE_BB_NAME, CACHE_BB_TYPE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return bbInstance;
        }
    }

    public static boolean HydraTask_initialize() {
        CacheBB.getBB().initialize();
        return true;
    }

    public void initialize() {
        SharedMap aMap = this.getSharedMap();
        String scope = TestConfig.tab().stringAt(CachePrms.scopeAttribute, null);
        String mirror = TestConfig.tab().stringAt(CachePrms.mirrorAttribute, null);
        String dataPolicy = TestConfig.tab().stringAt(CachePrms.dataPolicyAttribute, null);
        if (scope != null) {
            aMap.put(SCOPE, TestConfig.tab().stringAt(CachePrms.scopeAttribute, null));
            Log.getLogWriter().info("Scope attribute is " + aMap.get(SCOPE));
        }
        if (mirror != null) {
            aMap.put(MIRROR, TestConfig.tab().stringAt(CachePrms.mirrorAttribute, null));
            Log.getLogWriter().info("Mirroring attribute is " + aMap.get(MIRROR));
        }
        if (dataPolicy != null) {
            aMap.put(DATA_POLICY, dataPolicy);
            Log.getLogWriter().info("DataPolicy attribute is " + aMap.get(DATA_POLICY));
        }
    }

    public Scope getScopeAttribute() {
        SharedMap aMap = this.getSharedMap();
        String attribute = (String)aMap.get(SCOPE);
        return TestHelper.getScope(attribute);
    }

    public MirrorType getMirrorAttribute() {
        SharedMap aMap = this.getSharedMap();
        String attribute = (String)aMap.get(MIRROR);
        return TestHelper.getMirrorType(attribute);
    }

    public DataPolicy getDataPolicyAttribute() {
        SharedMap aMap = this.getSharedMap();
        String attribute = (String)aMap.get(DATA_POLICY);
        return TestHelper.getDataPolicy(attribute);
    }

    public CacheBB() {
    }

    public CacheBB(String name, String type) {
        super(name, type, CacheBB.class);
    }
}

