/*
 * Decompiled with CFR 0.152.
 */
package util;

import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedMap;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import util.TestException;
import util.TestHelper;

public class Bounds
implements Serializable {
    public static final int UPWARD = 0;
    public static final int DOWNWARD = 1;
    private static final String TREND_KEY = "CurrentTrend";
    private int targetLowPoint;
    private int targetHighPoint;
    private boolean bounce;
    private String bbClassName;
    private String bbName;
    private String bbType;

    public Bounds() {
    }

    public Bounds(int low, int high, boolean shouldBounce, Class bbClass, String bbName, String bbType) {
        this.targetLowPoint = low;
        this.targetHighPoint = high;
        this.bounce = shouldBounce;
        this.bbClassName = bbClass.getName();
        this.bbName = bbName;
        this.bbType = bbType;
        if (this.bounce) {
            if (bbClass == null || bbName == null || bbType == null) {
                throw new TestException("bounce is true, but the blackboard is not complete; must have a blackboard; bbClass is " + bbClass + ", bbName is " + bbName + ", bbType is " + bbType);
            }
            this.getBB().getSharedMap().put(TREND_KEY, new Integer(0));
        }
        Log.getLogWriter().info("Created Bounds with low " + this.targetLowPoint + ", high " + this.targetHighPoint + ", bounce " + this.bounce + ", blackboard " + bbClass.getName());
    }

    public int getDirection(int currentPoint) {
        if (this.bounce) {
            SharedMap bbMap = this.getBB().getSharedMap();
            if (currentPoint >= this.targetHighPoint) {
                bbMap.put(TREND_KEY, new Integer(1));
                return 1;
            }
            if (currentPoint <= this.targetLowPoint) {
                bbMap.put(TREND_KEY, new Integer(0));
                return 0;
            }
            int trend = (Integer)bbMap.get(TREND_KEY);
            if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 80) {
                return trend;
            }
            if (trend == 0) {
                return 1;
            }
            return 0;
        }
        if (currentPoint >= this.targetHighPoint) {
            return 1;
        }
        if (currentPoint <= this.targetLowPoint) {
            return 0;
        }
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        return super.toString() + ": targetLowPoint = " + this.targetLowPoint + ", targetHighPoint = " + this.targetHighPoint + ", bounce = " + this.bounce;
    }

    public static String trendToString(int trend) {
        if (trend == 0) {
            return "UPWARD";
        }
        if (trend == 1) {
            return "DOWNWARD";
        }
        throw new TestException("Unknown trend " + trend);
    }

    public boolean getBounce() {
        return this.bounce;
    }

    public int getTargetHighPoint() {
        return this.targetHighPoint;
    }

    public int getTargetLowPoint() {
        return this.targetLowPoint;
    }

    private Blackboard getBB() {
        try {
            Class<?> bbClass = Class.forName(this.bbClassName);
            Constructor<?> con = bbClass.getConstructor(String.class, String.class);
            Blackboard bb = (Blackboard)con.newInstance(this.bbName, this.bbType);
            return bb;
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (NoSuchMethodException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InstantiationException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InvocationTargetException e) {
            throw new TestException(TestHelper.getStackTrace(e.getTargetException()));
        }
    }
}

