/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import diskReg.DiskRegUtil;
import hydra.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import tx.Operation;
import util.CacheUtil;
import util.TestException;

public class RegionValidator {
    private static Map visible = null;
    private static Map notVisible = null;
    private String regionName = null;
    private Operation op = null;
    private boolean regionExists;
    private boolean hasKeys;
    private boolean hasValues;

    public RegionValidator(Operation op) {
        this.op = op;
    }

    public RegionValidator(boolean regionExists, boolean hasKeys, boolean hasValues) {
        this.regionExists = regionExists;
        this.hasKeys = hasKeys;
        this.hasValues = hasValues;
    }

    public RegionValidator(Operation op, String regionName, boolean regionExists, boolean hasKeys, boolean hasValues) {
        this.op = op;
        this.regionName = regionName;
        this.regionExists = regionExists;
        this.hasKeys = hasKeys;
        this.hasValues = hasValues;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public static RegionValidator getExpected(Operation op, boolean isVisible) {
        String regionName = op.getRegionName();
        String opName = op.getOpName();
        Log.getLogWriter().info("RegionValidator.getExpected(" + op.toString() + " isVisible = " + isVisible + ")");
        Map aMap = isVisible ? visible : notVisible;
        RegionValidator template = (RegionValidator)aMap.get(opName);
        RegionValidator expected = new RegionValidator(op);
        expected.setRegionName(regionName);
        expected.regionExists = template.regionExists;
        expected.hasKeys = template.hasKeys;
        expected.hasValues = template.hasValues;
        Log.getLogWriter().info("getExpected returns " + expected.toString());
        return expected;
    }

    public static RegionValidator getActual(Operation op) {
        String regionName = op.getRegionName();
        String opName = op.getOpName();
        Log.getLogWriter().info("RegionValidator.getActual(" + op.toString() + ")");
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        boolean regionExists = aRegion != null;
        boolean hasKeys = false;
        boolean hasValues = false;
        if (regionExists) {
            Set keySet = aRegion.keySet();
            hasKeys = keySet.size() > 0;
            int valueCount = 0;
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                if (!aRegion.containsValueForKey(it.next())) continue;
                ++valueCount;
            }
            hasValues = valueCount > 0;
        }
        RegionValidator actualValues = new RegionValidator(op, regionName, regionExists, hasKeys, hasValues);
        Log.getLogWriter().info("RegionValidator.getActual returning = " + actualValues.toString());
        return actualValues;
    }

    public void compare(RegionValidator vc) {
        if (this.regionExists != vc.regionExists) {
            throw new TestException("RegionValidator comparison failure: expected " + this.toString() + " but actualValues = " + vc.toString());
        }
        if (this.hasValues != vc.hasValues) {
            if (!this.hasValues) {
                Region aRegion = CacheUtil.getCache().getRegion(this.regionName);
                Set keySet = aRegion.keySet();
                StringBuffer aStr = new StringBuffer();
                aStr.append("Region contains unexpected key/value pairs\n");
                for (String key : keySet) {
                    if (!aRegion.containsValueForKey((Object)key)) continue;
                    Object value = DiskRegUtil.getValueInVM(aRegion, key);
                    aStr.append("    key:value = " + key + ":" + value + "\n");
                }
                HashSet txSet = new HashSet(((LocalRegion)aRegion).testHookTXKeys());
                if (txSet.size() != 0) {
                    aStr.append("For " + aRegion.getFullPath() + " tx set is " + txSet + "\n");
                }
                Log.getLogWriter().info(aStr.toString());
            }
            throw new TestException("RegionValidator comparison failure: expected " + this.toString() + " but actualValues = " + vc.toString());
        }
    }

    public String toString() {
        String aStr = "op: " + this.op + " regionName: " + this.regionName + ", regionExists: " + this.regionExists + ", hasKeys: " + this.hasKeys + ", hasValues: " + this.hasValues;
        return aStr;
    }

    static {
        visible = new HashMap();
        visible.put("region-create", new RegionValidator(true, false, false));
        visible.put("region-destroy", new RegionValidator(false, false, false));
        visible.put("region-localDestroy", new RegionValidator(false, false, false));
        visible.put("region-inval", new RegionValidator(true, true, false));
        visible.put("region-localInval", new RegionValidator(true, true, false));
        notVisible = new HashMap();
        notVisible.put("region-create", new RegionValidator(false, false, false));
        notVisible.put("region-destroy", new RegionValidator(true, true, true));
        notVisible.put("region-localDestroy", new RegionValidator(true, true, true));
        notVisible.put("region-inval", new RegionValidator(true, true, true));
        notVisible.put("region-localInval", new RegionValidator(true, true, true));
    }
}

