/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TransactionEvent;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedMap;
import java.util.List;
import java.util.Set;
import parReg.tx.PrTxBB;
import tx.OpList;
import tx.Operation;
import tx.TxBB;
import tx.TxPrms;
import tx.TxUtil;
import util.AbstractListener;
import util.BaseValueHolder;
import util.TestException;
import util.TestHelper;
import util.TxEventCountersBB;

public class PrTxListener
extends AbstractListener
implements TransactionListener {
    public void afterCommit(TransactionEvent event) {
        this.logTxEvent("afterCommit", event);
        TxBB.inc(TxBB.TX_SUCCESS);
        this.validate(TxBB.TXACTION_COMMIT, event);
    }

    public void afterRollback(TransactionEvent event) {
        this.logTxEvent("afterRollback", event);
        TxBB.inc(TxBB.TX_ROLLBACK);
        this.validate(TxBB.TXACTION_ROLLBACK, event);
    }

    public void afterFailedCommit(TransactionEvent event) {
        this.logTxEvent("afterFailedCommit", event);
        TxBB.inc(TxBB.TX_FAILURE);
        this.validate(TxBB.TXACTION_ROLLBACK, event);
    }

    public void close() {
        Log.getLogWriter().info("PrTxListener: close()");
    }

    private void validate(String txAction, TransactionEvent txEvent) {
        Log.getLogWriter().fine("PrTxListener: validate() invoked with TxEvent " + txEvent.toString());
        long txid = TxBB.getBB().getSharedCounters().read(TxBB.TX_NUMBER);
        List txEventList = txEvent.getEvents();
        OpList eventOpList = new OpList();
        for (EntryEvent event : txEventList) {
            Object newValue;
            Object oldValue;
            com.gemstone.gemfire.cache.Operation eventOp = event.getOperation();
            String opName = null;
            if (eventOp.isCreate()) {
                opName = "entry-create";
                this.updateTxEventCounter("Create", event);
            } else if (eventOp.isUpdate()) {
                opName = "entry-update";
                this.updateTxEventCounter("Update", event);
            } else if (eventOp.isDestroy()) {
                opName = "destroy";
                opName = "entry-destroy";
                this.updateTxEventCounter("Destroy", event);
            } else if (eventOp.isInvalidate()) {
                opName = "entry-inval";
                this.updateTxEventCounter("Invalidate", event);
            }
            if (!event.isDistributed()) {
                boolean scopeLocal;
                RegionAttributes ratts = event.getRegion().getAttributes();
                boolean bl = scopeLocal = ratts.getScope() == Scope.LOCAL;
                if (!scopeLocal) {
                    if (opName.equals("entry-destroy")) {
                        opName = "entry-localDestroy";
                    }
                    if (opName.equals("entry-inval")) {
                        opName = "entry-localInval";
                    }
                }
            }
            if (event.isLoad()) {
                if (eventOp.equals(com.gemstone.gemfire.cache.Operation.LOCAL_LOAD_CREATE)) {
                    opName = "entry-create";
                } else if (eventOp.equals(com.gemstone.gemfire.cache.Operation.LOCAL_LOAD_UPDATE)) {
                    opName = "entry-update";
                }
            }
            if ((oldValue = event.getOldValue()) instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            if ((newValue = event.getNewValue()) instanceof BaseValueHolder) {
                newValue = ((BaseValueHolder)newValue).modVal;
            }
            Operation op = new Operation(event.getRegion().getFullPath(), event.getKey(), opName, oldValue, newValue);
            eventOpList.add(op);
        }
        if (eventOpList.numOps() > 0) {
            String key = null;
            key = TxUtil.inTxVm() ? TxBB.LocalListenerOpListPrefix + txid : TxBB.RemoteListenerOpListPrefix + txid;
            OpList cacheListenerOpList = (OpList)TxBB.getBB().getSharedMap().get(key);
            String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
            OpList originalOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
            OpList collapsedOpList = originalOpList.collapseForEvents(txAction);
            if (TxUtil.inTxVm()) {
                Log.getLogWriter().info("checking order of operations vs. txEvents");
                this.checkEventOrder(collapsedOpList, eventOpList);
            } else {
                Log.getLogWriter().info("checking order of operations vs. txEvents");
                this.checkEventOrder(collapsedOpList, eventOpList);
            }
        }
    }

    protected void checkEventOrder(OpList entryOpList, OpList eventOpList) {
        Operation op;
        int i;
        if (!TxPrms.checkTxEventOrder()) {
            return;
        }
        OpList newOpList = new OpList();
        for (i = 0; i < entryOpList.numOps(); ++i) {
            boolean addOp = true;
            op = entryOpList.getOperation(i);
            if (op.isGetOperation()) {
                if (op.getOldValue() == null) {
                    op.setOpName("entry-create");
                } else if (op.getOldValue().toString().equals("INVALID")) {
                    op.setOpName("entry-update");
                } else if (!op.getOldValue().equals(op.getNewValue())) {
                    op.setOpName("entry-update");
                } else {
                    addOp = false;
                }
            } else if (op.isDoubleInvalidate()) {
                Log.getLogWriter().info("Not adding " + op.toString() + " : double invalidate");
                addOp = false;
            }
            Region aRegion = RegionHelper.getRegion(op.getRegionName());
            if (PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) {
                DistributedMember dm = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
                boolean alwaysFireLocalListeners = (Boolean)PrTxBB.getBB().getSharedMap().get("alwaysFireLocalListeners");
                int redundantCopies = (Integer)PrTxBB.getBB().getSharedMap().get("redundantCopies");
                if (alwaysFireLocalListeners && redundantCopies > 0) {
                    Set dataHosts = PartitionRegionHelper.getAllMembersForKey((Region)aRegion, (Object)op.getKey());
                    if (!dataHosts.contains(dm)) {
                        Log.getLogWriter().info("Not adding " + op.toString() + " this VM does not host this entry");
                        addOp = false;
                    }
                } else {
                    DistributedMember primaryDM = PartitionRegionHelper.getPrimaryMemberForKey((Region)aRegion, (Object)op.getKey());
                    if (primaryDM != dm) {
                        Log.getLogWriter().info("Not adding " + op.toString() + " this VM does not host this entry");
                        addOp = false;
                    }
                }
            }
            if (!addOp) continue;
            newOpList.add(op);
        }
        Log.getLogWriter().info("Event OpList operations = " + eventOpList.toString());
        Log.getLogWriter().info("Original OpList operations = " + newOpList.toString());
        if (newOpList.numOps() != eventOpList.numOps()) {
            StringBuffer aStr = new StringBuffer();
            aStr.append("eventOpList and opList have different sizes, expected to contain same number of entries (and same operations)\n");
            aStr.append("\tEventOpList = " + eventOpList.toString() + "\n");
            aStr.append("\tOpList = " + newOpList.toString());
            this.throwException(aStr.toString());
        }
        for (i = 0; i < newOpList.numOps(); ++i) {
            Operation eventOp = eventOpList.getOperation(i);
            op = newOpList.getOperation(i);
            if (op.equalsEventOp(eventOp)) continue;
            String errStr = "Original operation: <" + op.toString() + "> does not match eventOp <" + eventOp.toString() + ">";
            this.throwException(errStr);
        }
    }

    private void updateTxEventCounter(String eventName, EntryEvent event) {
        TxEventCountersBB.incrementEntryTxEventCntrs(eventName, event.isDistributed(), event.isExpiration(), event.isOriginRemote(), event.isLoad(), event.isLocalLoad(), event.isNetLoad(), event.isNetSearch());
    }

    protected void throwException(String errStr) {
        StringBuffer qualifiedErrStr = new StringBuffer();
        qualifiedErrStr.append("Exception reported in " + RemoteTestModule.getMyClientName() + "\n");
        qualifiedErrStr.append(errStr);
        errStr = qualifiedErrStr.toString();
        SharedMap aMap = TxBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }
}

