/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import hydra.BridgeHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.Log;
import hydra.TestConfig;
import java.util.List;
import tx.TxBB;
import tx.TxPrms;
import tx.ViewTest;

public class BridgeViewTest
extends ViewTest {
    public static void HydraTask_initialize() {
        Log.getLogWriter().info("In HydraTask_initialize");
        if (viewTest == null) {
            viewTest = new BridgeViewTest();
            viewTest.initialize();
        }
        TxBB.getBB().getSharedMap().put("afterCommitProcessed", new Boolean(false));
    }

    @Override
    public void setupCommitTestCallbacks(String commitStatePrm) {
        int commitStateTrigger = TxPrms.getCommitStateTrigger(commitStatePrm);
        TxBB.getBB().getSharedMap().put(TxBB.CommitStateTrigger, new Integer(commitStateTrigger));
        Log.getLogWriter().info("TxPrms.commitStateTrigger = " + commitStatePrm + "(" + commitStateTrigger + ")");
    }

    protected void postClientVmInfoToBB() {
        PoolImpl pool = (PoolImpl)PoolManager.find((String)"brloader");
        ServerLocation delegate = pool.getServerAffinityLocation();
        int delegatePort = delegate.getPort();
        String delegateHost = delegate.getHostName();
        int dot = delegateHost.indexOf(".");
        if (dot != -1) {
            delegateHost = delegateHost.substring(0, dot);
        }
        Log.getLogWriter().info("Delegate is " + delegateHost + ":" + delegatePort);
        ClientVmInfo delegateVmInfo = null;
        ClientVmInfo nonDelegateVmInfo = null;
        List<BridgeHelper.Endpoint> endpoints = BridgeHelper.getEndpoints();
        for (BridgeHelper.Endpoint endpoint : endpoints) {
            if (endpoint.getHost().equalsIgnoreCase(delegateHost) && endpoint.getPort() == delegatePort) {
                delegateVmInfo = new ClientVmInfo(endpoint);
                continue;
            }
            nonDelegateVmInfo = new ClientVmInfo(endpoint);
        }
        TxBB.getBB().getSharedMap().put("DelegateVmInfo", delegateVmInfo);
        TxBB.getBB().getSharedMap().put("NonDelegateServerVmInfo", nonDelegateVmInfo);
        Log.getLogWriter().info("Writing delegateVmInfo to BB: " + delegateVmInfo);
        Log.getLogWriter().info("Writing nonDelegateVmInfo to BB: " + nonDelegateVmInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_killCommittor() throws ClientVmNotFoundException {
        Log.getLogWriter().info("In killCommittor ... killing tx edge client vm");
        Object object = ViewTest.killSyncObject;
        synchronized (object) {
            try {
                ViewTest.killSyncObject.wait();
            }
            catch (InterruptedException e) {
                Log.getLogWriter().info("killCommittor interrupted, did not kill VM");
            }
        }
        Boolean timeToStop = (Boolean)TxBB.getBB().getSharedMap().get("timeToStop");
        int stopMode = -21;
        String commitStatePrm = TestConfig.tab().stringAt(TxPrms.commitStateTrigger, null);
        if (commitStatePrm != null && TxPrms.getCommitStateTrigger(commitStatePrm) == 6) {
            stopMode = -20;
        }
        if (timeToStop.equals(Boolean.FALSE)) {
            ClientVmMgr.stop("product invoked CommitTestCallback, killing committor", stopMode, -32);
        } else {
            Log.getLogWriter().info("killCommittor invoked, signalled by waitForDist to allow test to continue normally.  Not killing this VM");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_killDelegate() throws ClientVmNotFoundException {
        Log.getLogWriter().info("In killDelegate ... ");
        Object object = ViewTest.killSyncObject;
        synchronized (object) {
            try {
                ViewTest.killSyncObject.wait();
            }
            catch (InterruptedException e) {
                Log.getLogWriter().info("killCommittor interrupted, did not kill VM");
            }
        }
        Boolean timeToStop = (Boolean)TxBB.getBB().getSharedMap().get("timeToStop");
        if (timeToStop.equals(Boolean.FALSE)) {
            ClientVmMgr.stop("product invoked CommitTestCallback, killing committor", -21, -32, (ClientVmInfo)TxBB.getBB().getSharedMap().get("DelegateVmInfo"));
        } else {
            Log.getLogWriter().info("killCommittor invoked, signalled by waitForDist to allow test to continue normally.  Not killing this VM");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_killNonDelegate() throws ClientVmNotFoundException {
        Log.getLogWriter().info("In killNonDelegate ...");
        Object object = ViewTest.killSyncObject;
        synchronized (object) {
            try {
                ViewTest.killSyncObject.wait();
            }
            catch (InterruptedException e) {
                Log.getLogWriter().info("killCommittor interrupted, did not kill VM");
            }
        }
        Boolean timeToStop = (Boolean)TxBB.getBB().getSharedMap().get("timeToStop");
        if (timeToStop.equals(Boolean.FALSE)) {
            ClientVmMgr.stop("product invoked CommitTestCallback, killing committor", -21, -32, (ClientVmInfo)TxBB.getBB().getSharedMap().get("NonDelegateServerVmInfo"));
        } else {
            Log.getLogWriter().info("killCommittor invoked, signalled by waitForDist to allow test to continue normally.  Not killing this VM");
        }
    }
}

