/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedMap;
import tx.OpList;
import tx.Operation;
import tx.TxBB;
import tx.TxUtil;
import util.AbstractListener;
import util.BaseValueHolder;
import util.EventCountersBB;
import util.TestException;
import util.TestHelper;

public class BWCTestListener
extends AbstractListener
implements CacheListener {
    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
        boolean eventsProcessed = this.handleEntryEvent("entry-create", event);
        if (eventsProcessed) {
            this.incrementAfterCreateCounters(event, (Blackboard)EventCountersBB.getBB());
            this.checkCallback((CacheEvent)event, "Create event originated in pid ");
        }
    }

    public void afterDestroy(EntryEvent event) {
        boolean eventsProcessed;
        this.logCall("afterDestroy", (CacheEvent)event);
        String opName = "entry-destroy";
        if (!event.isDistributed()) {
            boolean scopeLocal;
            RegionAttributes ratts = event.getRegion().getAttributes();
            boolean bl = scopeLocal = ratts.getScope() == Scope.LOCAL;
            if (!scopeLocal) {
                opName = "entry-localDestroy";
            }
        }
        if (eventsProcessed = this.handleEntryEvent(opName, event)) {
            this.incrementAfterDestroyCounters(event, (Blackboard)EventCountersBB.getBB());
            this.checkCallback((CacheEvent)event, "Destroy event originated in pid ");
        }
    }

    public void afterInvalidate(EntryEvent event) {
        boolean eventsProcessed;
        this.logCall("afterInvalidate", (CacheEvent)event);
        String opName = "entry-inval";
        if (!event.isDistributed()) {
            boolean scopeLocal;
            RegionAttributes ratts = event.getRegion().getAttributes();
            boolean bl = scopeLocal = ratts.getScope() == Scope.LOCAL;
            if (!scopeLocal) {
                opName = "entry-localInval";
            }
        }
        if (eventsProcessed = this.handleEntryEvent(opName, event)) {
            this.incrementAfterInvalidateCounters(event, (Blackboard)EventCountersBB.getBB());
            this.checkCallback((CacheEvent)event, "Invalidate event originated in pid ");
        }
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
        boolean eventsProcessed = this.handleEntryEvent("entry-update", event);
        if (eventsProcessed) {
            this.incrementAfterUpdateCounters(event, (Blackboard)EventCountersBB.getBB());
            this.checkCallback((CacheEvent)event, "Update event originated in pid ");
        }
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
        this.checkCallback((CacheEvent)event, "Region destroy event originated in pid ");
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
        this.checkCallback((CacheEvent)event, "Region invalidate event originated in pid ");
    }

    public void close() {
        this.logCall("close", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleEntryEvent(String opName, EntryEvent event) {
        Object newValue;
        if (TxBB.getBB().getSharedCounters().read(TxBB.PROCESS_EVENTS) == 0L) {
            Log.getLogWriter().fine("handleEntryEvent - currently not processing events");
            return false;
        }
        Object oldValue = event.getOldValue();
        if (oldValue instanceof BaseValueHolder) {
            oldValue = ((BaseValueHolder)oldValue).modVal;
        }
        if ((newValue = event.getNewValue()) instanceof BaseValueHolder) {
            newValue = ((BaseValueHolder)newValue).modVal;
        }
        Operation op = new Operation(event.getRegion().getFullPath(), event.getKey(), opName, oldValue, newValue);
        Log.getLogWriter().fine("BWCTestListener: op from event = " + op.toString());
        Long txid = new Long(TxBB.getBB().getSharedCounters().read(TxBB.TX_NUMBER));
        String key = null;
        if (txid != null && txid.intValue() > 0) {
            key = TxUtil.inTxVm() ? TxBB.LocalListenerOpListPrefix + txid : TxBB.RemoteListenerOpListPrefix + txid;
            Log.getLogWriter().info("handleEntryEvent() - adding <" + op.toString() + ">to opList with key <" + key + ">");
            TxBB txBB = TxBB.getBB();
            synchronized (txBB) {
                OpList opList = (OpList)TxBB.getBB().getSharedMap().get(key);
                if (opList == null) {
                    opList = new OpList();
                }
                opList.add(op);
                TxBB.getBB().getSharedMap().put(key, opList);
            }
            return true;
        }
        return false;
    }

    protected void checkCallback(CacheEvent event, String expectedCallbackPrefix) {
        if (event.getOperation().isClose()) {
            return;
        }
        if (event.isOriginRemote() || event.getOperation().isLoad() || event.getOperation().isPutAll()) {
            return;
        }
        String callbackObj = (String)event.getCallbackArgument();
        if (callbackObj != null) {
            String memberIdString = "memberId=";
            int index = callbackObj.indexOf(memberIdString, 0);
            index += memberIdString.length();
            memberIdString = callbackObj.substring(index);
            Log.getLogWriter().info("memberId from callbackObj = <" + memberIdString + "> memberId from event = <" + event.getDistributedMember() + ">");
            int myPID = ProcessMgr.getProcessId();
            boolean eventProducedInThisVM = callbackObj.indexOf("" + myPID + " ") >= 0;
            boolean isRemote = event.isOriginRemote();
            if (isRemote == eventProducedInThisVM) {
                String errStr = "Unexpected event.isOriginRemote() = " + isRemote + ", myPID = " + myPID + ", callbackObj showing origination VM = " + callbackObj;
                this.throwException(errStr);
            }
        }
    }

    protected void throwException(String errStr) {
        SharedMap aMap = TxBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }
}

