/*
 * Decompiled with CFR 0.152.
 */
package swarm;

import java.sql.SQLException;
import swarm.DUnitClassInfo;
import swarm.DUnitTestMethodDetail;
import swarm.Swarm;

public class DUnitMethodInfo {
    private final int id;
    private final String name;
    private final int classId;

    public DUnitMethodInfo(int id, String name, int classId) {
        this.id = id;
        this.name = name;
        this.classId = classId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getClassId() {
        return this.classId;
    }

    public DUnitClassInfo getClassInfo() {
        try {
            return Swarm.getDUnitClassInfo(this.getClassId());
        }
        catch (SQLException se) {
            se.printStackTrace();
            return null;
        }
    }

    public int getPassCount() {
        try {
            return Swarm.getPassedDetailsForMethod(this.getId()).size();
        }
        catch (SQLException se) {
            se.printStackTrace();
            return -1;
        }
    }

    public int getFailCount() {
        try {
            return Swarm.getFailedDetailsForMethod(this.getId()).size();
        }
        catch (SQLException se) {
            se.printStackTrace();
            return -1;
        }
    }

    public int getPassPercent() {
        float p = this.getPassCount();
        float f = this.getFailCount();
        float pct = p / (p + f) * 100.0f;
        return (int)pct;
    }

    public DUnitTestMethodDetail getLastRun() {
        try {
            return Swarm.getLastRun(this.getId());
        }
        catch (SQLException se) {
            se.printStackTrace();
            return null;
        }
    }

    public DUnitTestMethodDetail getLastPass() {
        try {
            return Swarm.getLastPass(this.getId());
        }
        catch (SQLException se) {
            se.printStackTrace();
            return null;
        }
    }

    public DUnitTestMethodDetail getLastFail() {
        try {
            return Swarm.getLastFail(this.getId());
        }
        catch (SQLException se) {
            se.printStackTrace();
            return null;
        }
    }
}

