/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedMap;
import java.util.HashSet;
import java.util.Set;
import splitBrain.CrashEventMemberInfo;
import util.TestException;

public class SplitBrainBB
extends Blackboard {
    static String SPLITBRAIN_BB_NAME = "SplitBrain_Blackboard";
    static String SPLITBRAIN_BB_TYPE = "RMI";
    static String ELIGIBLE_COORDINATORS = "EligibleCoordinators";
    static String FORCED_DISCONNECT_LIST = "forcedDisconnectList";
    static String RECONNECTED_LIST = "reconnectedList";
    static String EXPECT_RECONNECTED_LIST = "expectedReconnectedList";
    static String EXPECT_FORCED_DISCONNECTS = "losingPartitionList";
    static String LOSING_SIDE_HOST = "";
    static String CRASH_EVENT_MEMBER_LIST = "crashEventMemberList";
    public static SplitBrainBB bbInstance = null;
    public static int ExecutionNumber;
    public static int ReadyToBegin;
    public static int TimeToRespond;
    public static int FinishedTask;
    public static int TimeToStop;
    public static int NumVMsInDS;
    public static int NumVMsStopped;
    public static int OpsComplete;
    public static int dropConnectionComplete;
    public static int loadClientRegionSize;
    public static int adminForcedDisconnects;
    public static int expectedAdminForcedDisconnects;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SplitBrainBB getBB() {
        if (bbInstance != null) return bbInstance;
        Class<SplitBrainBB> clazz = SplitBrainBB.class;
        synchronized (SplitBrainBB.class) {
            if (bbInstance != null) return bbInstance;
            bbInstance = new SplitBrainBB(SPLITBRAIN_BB_NAME, SPLITBRAIN_BB_TYPE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return bbInstance;
        }
    }

    public SplitBrainBB() {
    }

    public SplitBrainBB(String name, String type) {
        super(name, type, SplitBrainBB.class);
    }

    public static void HydraTask_initialize() {
        SharedMap aMap = SplitBrainBB.getBB().getSharedMap();
        aMap.put(ELIGIBLE_COORDINATORS, new HashSet());
        aMap.put(FORCED_DISCONNECT_LIST, new HashSet());
        aMap.put(RECONNECTED_LIST, new HashSet());
        aMap.put(EXPECT_FORCED_DISCONNECTS, new HashSet());
        aMap.put(CRASH_EVENT_MEMBER_LIST, new HashSet());
        aMap.put(EXPECT_RECONNECTED_LIST, new HashSet());
    }

    public static synchronized void addEligibleCoordinator(String clientName) {
        SplitBrainBB bb = SplitBrainBB.getBB();
        SharedMap aMap = bb.getSharedMap();
        bb.getSharedLock().lock();
        Set aSet = (Set)aMap.get(ELIGIBLE_COORDINATORS);
        aSet.add(clientName);
        aMap.put(ELIGIBLE_COORDINATORS, aSet);
        bb.getSharedLock().unlock();
        Log.getLogWriter().info("After adding " + clientName + ", EligibleCoordinators = " + aSet);
    }

    public static synchronized void addExpectForcedDisconnect(int vmid) {
        SplitBrainBB bb = SplitBrainBB.getBB();
        SharedMap aMap = bb.getSharedMap();
        String clientVm = "vm_" + vmid;
        bb.getSharedLock().lock();
        Set aSet = (Set)aMap.get(EXPECT_FORCED_DISCONNECTS);
        if (!aSet.contains(clientVm)) {
            aSet.add(clientVm);
            aMap.put(EXPECT_FORCED_DISCONNECTS, aSet);
            Log.getLogWriter().info("After adding " + clientVm + ", ExpectForcedDisconnect = " + aSet);
        }
        bb.getSharedLock().unlock();
    }

    public static synchronized Set getExpectForcedDisconnects() {
        SharedMap aMap = SplitBrainBB.getBB().getSharedMap();
        return (Set)aMap.get(EXPECT_FORCED_DISCONNECTS);
    }

    public static synchronized void addDisconnectedClient(int vmid) {
        SplitBrainBB bb = SplitBrainBB.getBB();
        SharedMap aMap = bb.getSharedMap();
        String clientVm = "vm_" + vmid;
        bb.getSharedLock().lock();
        Set aSet = (Set)aMap.get(FORCED_DISCONNECT_LIST);
        if (!aSet.contains(clientVm)) {
            aSet.add(clientVm);
            aMap.put(FORCED_DISCONNECT_LIST, aSet);
        }
        bb.getSharedLock().unlock();
        Log.getLogWriter().info("After adding " + clientVm + ", ForcedDisconnectList = " + aSet);
    }

    public static synchronized Set getForcedDisconnectList() {
        SharedMap aMap = SplitBrainBB.getBB().getSharedMap();
        return (Set)aMap.get(FORCED_DISCONNECT_LIST);
    }

    public static synchronized void addExpectedReconnectedClient(int vmid) {
        SplitBrainBB bb = SplitBrainBB.getBB();
        SharedMap aMap = bb.getSharedMap();
        String clientVm = "vm_" + vmid;
        bb.getSharedLock().lock();
        Set aSet = (Set)aMap.get(EXPECT_RECONNECTED_LIST);
        if (!aSet.contains(clientVm)) {
            aSet.add(clientVm);
            aMap.put(EXPECT_RECONNECTED_LIST, aSet);
        }
        bb.getSharedLock().unlock();
        Log.getLogWriter().info("After adding " + clientVm + ", ExpectedReconnectList = " + aSet);
    }

    public static synchronized Set getExpectedReconnectList() {
        SharedMap aMap = SplitBrainBB.getBB().getSharedMap();
        return (Set)aMap.get(EXPECT_RECONNECTED_LIST);
    }

    public static synchronized void addReconnectedClient(int vmid) {
        SplitBrainBB bb = SplitBrainBB.getBB();
        SharedMap aMap = bb.getSharedMap();
        String clientVm = "vm_" + vmid;
        bb.getSharedLock().lock();
        Set aSet = (Set)aMap.get(RECONNECTED_LIST);
        if (!aSet.contains(clientVm)) {
            aSet.add(clientVm);
            aMap.put(RECONNECTED_LIST, aSet);
        }
        bb.getSharedLock().unlock();
        Log.getLogWriter().info("After adding " + clientVm + ", ReconnectList = " + aSet);
    }

    public static synchronized Set getReconnectedList() {
        SharedMap aMap = SplitBrainBB.getBB().getSharedMap();
        return (Set)aMap.get(RECONNECTED_LIST);
    }

    public static Set getEligibleCoordinators() {
        SharedMap aMap = SplitBrainBB.getBB().getSharedMap();
        return (Set)aMap.get(ELIGIBLE_COORDINATORS);
    }

    public static void postSelfAsLosingSideHost() {
        SplitBrainBB.putLosingSideHost(RemoteTestModule.getMyHost());
    }

    public static void putLosingSideHost(String hostName) {
        Log.getLogWriter().info("Posting " + hostName + " as losingSideHost");
        SharedMap aMap = SplitBrainBB.getBB().getSharedMap();
        aMap.put(LOSING_SIDE_HOST, hostName);
    }

    public static String getLosingSideHost() {
        SharedMap aMap = SplitBrainBB.getBB().getSharedMap();
        return (String)aMap.get(LOSING_SIDE_HOST);
    }

    public static synchronized void addMember(DistributedMember dm, boolean inSurvivingSide) {
        SplitBrainBB bb = SplitBrainBB.getBB();
        SharedMap aMap = bb.getSharedMap();
        bb.getSharedLock().lock();
        Set aSet = (Set)aMap.get(CRASH_EVENT_MEMBER_LIST);
        aSet.add(new CrashEventMemberInfo(dm, inSurvivingSide));
        aMap.put(CRASH_EVENT_MEMBER_LIST, aSet);
        bb.getSharedLock().unlock();
        Log.getLogWriter().info("After adding " + dm + ", CrashEventMemberList = " + aSet);
    }

    public static synchronized void updateMember(DistributedMember dm, boolean reportedBySurvivingSide) {
        SplitBrainBB bb = SplitBrainBB.getBB();
        SharedMap aMap = bb.getSharedMap();
        bb.getSharedLock().lock();
        Set aSet = (Set)aMap.get(CRASH_EVENT_MEMBER_LIST);
        CrashEventMemberInfo m2 = null;
        for (CrashEventMemberInfo m2 : aSet) {
            if (!m2.getDm().equals(dm)) continue;
            m2.incrementCounter(reportedBySurvivingSide);
            break;
        }
        aMap.put(CRASH_EVENT_MEMBER_LIST, aSet);
        bb.getSharedLock().unlock();
        if (m2 == null) {
            throw new TestException("Received Unexpected memberCrashed event for " + dm.toString());
        }
        Log.getLogWriter().info("After updating " + dm + ", CrashEventMemberList = " + aSet);
    }

    public static synchronized Set getMembers() {
        SharedMap aMap = SplitBrainBB.getBB().getSharedMap();
        return (Set)aMap.get(CRASH_EVENT_MEMBER_LIST);
    }
}

