/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.MembershipTestHook;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.DistributedSystemHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.NetworkHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedLock;
import java.rmi.RemoteException;
import java.util.Set;
import java.util.Vector;
import splitBrain.SplitBrainBB;
import splitBrain.SplitBrainPrms;
import util.TestException;
import vsphere.vijava.VMotionBB;

public class SBUtil {
    public static final int ONEWAY = 0;
    public static final int TWOWAY = 1;

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
        if (SBUtil.isCoordinator()) {
            Log.getLogWriter().info("This VM is currently the Coordinator");
        } else {
            SplitBrainBB.addEligibleCoordinator(RemoteTestModule.getMyClientName());
        }
    }

    public static void stopLocatorTask() {
        DistributedSystemHelper.stopLocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreConnection() {
        SharedLock criticalCodeSection = SplitBrainBB.getBB().getSharedLock();
        criticalCodeSection.lock();
        try {
            String hdName1 = TestConfig.tab().stringAt(SplitBrainPrms.hostDescription1, "host1");
            String hdName2 = TestConfig.tab().stringAt(SplitBrainPrms.hostDescription2, "host2");
            String src = TestConfig.getInstance().getHostDescription(hdName1).getHostName();
            String target = TestConfig.getInstance().getHostDescription(hdName2).getHostName();
            SBUtil.restoreConnection(src, target);
        }
        finally {
            criticalCodeSection.unlock();
        }
        VMotionBB.getBB().getSharedMap().put("connectionDropped", Boolean.FALSE);
    }

    public static void restoreConnection(String src, String target) {
        boolean enableNetworkHelper = TestConfig.tab().booleanAt(SplitBrainPrms.enableNetworkHelper, true);
        if (!enableNetworkHelper) {
            Log.getLogWriter().info("Not restoring connection between " + src + " and " + target + " as enableNetworkHelper is false");
            return;
        }
        NetworkHelper.printConnectionState();
        int dropType = SplitBrainPrms.getDropType();
        try {
            switch (dropType) {
                case 0: {
                    NetworkHelper.restoreConnectionOneWay(src, target);
                    break;
                }
                case 1: {
                    NetworkHelper.restoreConnectionTwoWay(src, target);
                    break;
                }
                default: {
                    throw new TestException("Invalid dropType = " + dropType);
                }
            }
        }
        catch (IllegalStateException e) {
            Log.getLogWriter().info("Caught " + e + " indicating that connections are already restored");
        }
        NetworkHelper.printConnectionState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreMultipleConnections() {
        HydraVector hostDescriptions = TestConfig.tab().vecAt(SplitBrainPrms.hostPairsForConnectionDropRestore);
        SharedLock criticalCodeSection = SplitBrainBB.getBB().getSharedLock();
        criticalCodeSection.lock();
        try {
            for (int i = 0; i < hostDescriptions.size(); ++i) {
                Vector vector = (Vector)hostDescriptions.elementAt(i);
                String hostDescName1 = (String)vector.elementAt(0);
                String hostDescName2 = (String)vector.elementAt(1);
                String src = TestConfig.getInstance().getHostDescription(hostDescName1).getHostName();
                String target = TestConfig.getInstance().getHostDescription(hostDescName2).getHostName();
                SBUtil.restoreConnection(src, target);
            }
        }
        finally {
            criticalCodeSection.unlock();
        }
    }

    public static void killEligibleCoordinator() {
        Set aSet = SplitBrainBB.getEligibleCoordinators();
        if (aSet.isEmpty()) {
            throw new TestException("Cannot kill eligibleCoordinator, none available");
        }
        Object[] vms = aSet.toArray();
        ClientVmInfo targetVm = new ClientVmInfo(null, (String)vms[0], null);
        try {
            ClientVmMgr.stopAsync("Killing EligibleCoordinator " + targetVm, -21, -32, targetVm);
        }
        catch (ClientVmNotFoundException e) {
            throw new TestException("Failed to kill eligibleCoordinator, caught Exception " + e);
        }
    }

    public static void killCoordinator() {
        DistributedMember dm = SBUtil.getCoordinator();
        String host = dm.getHost();
        int pid = dm.getProcessId();
        ClientVmInfo targetVm = SBUtil.getClientVmInfo(host, pid);
        try {
            ClientVmMgr.stopAsync("Killing Coordinator " + dm.toString(), -21, -32, targetVm);
        }
        catch (ClientVmNotFoundException e) {
            throw new TestException("Failed to kill coordinator, caught Exception " + e);
        }
    }

    public static void killLeadMember() {
        DistributedMember dm = SBUtil.getLeadMember();
        String host = dm.getHost();
        int pid = dm.getProcessId();
        ClientVmInfo targetVm = SBUtil.getClientVmInfo(host, pid);
        try {
            ClientVmMgr.stopAsync("Killing LeadMember " + dm.toString(), -21, -32, targetVm);
        }
        catch (ClientVmNotFoundException e) {
            throw new TestException("Failed to kill leadMember, caught Exception " + e);
        }
    }

    public static void dropConnection() {
        String hdName1 = TestConfig.tab().stringAt(SplitBrainPrms.hostDescription1, "host1");
        String hdName2 = TestConfig.tab().stringAt(SplitBrainPrms.hostDescription2, "host2");
        String src = TestConfig.getInstance().getHostDescription(hdName1).getHostName();
        String target = TestConfig.getInstance().getHostDescription(hdName2).getHostName();
        SBUtil.dropConnection(src, target);
        SplitBrainBB.getBB().getSharedCounters().increment(SplitBrainBB.dropConnectionComplete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropConnection(String src, String target) {
        boolean enableNetworkHelper = TestConfig.tab().booleanAt(SplitBrainPrms.enableNetworkHelper, true);
        SharedLock criticalCodeSection = SplitBrainBB.getBB().getSharedLock();
        criticalCodeSection.lock();
        Log.getLogWriter().fine("SBUtil.dropConnections() obtained the SharedLock!");
        try {
            if (enableNetworkHelper) {
                NetworkHelper.printConnectionState();
                int dropType = SplitBrainPrms.getDropType();
                switch (dropType) {
                    case 0: {
                        NetworkHelper.dropConnectionOneWay(src, target);
                        break;
                    }
                    case 1: {
                        NetworkHelper.dropConnectionTwoWay(src, target);
                        break;
                    }
                    default: {
                        throw new TestException("Invalid dropType = " + dropType);
                    }
                }
                NetworkHelper.printConnectionState();
                VMotionBB.getBB().getSharedMap().put("connectionDropped", Boolean.TRUE);
            } else {
                Log.getLogWriter().info("Not dropping connection between " + src + " and " + target + " as enableNetworkHelper is false");
            }
            int waitTimeSec = SplitBrainPrms.getDropWaitTimeSec();
            if (waitTimeSec > 0) {
                Log.getLogWriter().info("SBUtil.dropConnections sleeping for " + waitTimeSec + " seconds");
                MasterController.sleepForMs(waitTimeSec * 1000);
            }
        }
        finally {
            criticalCodeSection.unlock();
            Log.getLogWriter().fine("SBUtil.dropConnections() released the SharedLock!");
        }
    }

    public static void dropMultipleConnections() {
        HydraVector hostDescriptions = TestConfig.tab().vecAt(SplitBrainPrms.hostPairsForConnectionDropRestore);
        for (int i = 0; i < hostDescriptions.size(); ++i) {
            Vector vector = (Vector)hostDescriptions.elementAt(i);
            String hostDescName1 = (String)vector.elementAt(0);
            String hostDescName2 = (String)vector.elementAt(1);
            String src = TestConfig.getInstance().getHostDescription(hostDescName1).getHostName();
            String target = TestConfig.getInstance().getHostDescription(hostDescName2).getHostName();
            SBUtil.dropConnection(src, target);
        }
        SplitBrainBB.getBB().getSharedCounters().increment(SplitBrainBB.dropConnectionComplete);
    }

    public static boolean isCoordinator() {
        DistributedSystem ds;
        DistributedMember coordinator = SBUtil.getCoordinator();
        return coordinator.equals((ds = DistributedSystemHelper.getDistributedSystem()).getDistributedMember());
    }

    protected static DistributedMember getCoordinator() {
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        if (ds == null) {
            throw new TestException("Can't get coordinator because DistributedSystem is " + ds);
        }
        DistributedMember dm = MembershipManagerHelper.getCoordinator((DistributedSystem)ds);
        return dm;
    }

    public static DistributedMember getLeadMember() {
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        if (ds == null) {
            throw new TestException("Can't get lead member because DistributedSystem is " + ds);
        }
        DistributedMember dm = MembershipManagerHelper.getLeadMember((DistributedSystem)ds);
        return dm;
    }

    public static boolean isLeadMember() {
        DistributedSystem ds;
        DistributedMember leadMember = SBUtil.getLeadMember();
        return leadMember.equals((ds = DistributedSystemHelper.getDistributedSystem()).getDistributedMember());
    }

    protected static ClientVmInfo getClientVmInfo(String host, int pid) {
        Integer vmid = null;
        try {
            vmid = RemoteTestModule.Master.getVmid(host, pid);
        }
        catch (RemoteException e) {
            throw new TestException("Could not convert dm host and pid to vmid, caught Exception " + e);
        }
        if (vmid == null) {
            throw new TestException("killCoordinator cannot get vmId for host " + host + " and PID " + pid);
        }
        return new ClientVmInfo(vmid);
    }

    protected static Object[] waitForLeadChange(DistributedMember member, int msToSleep) {
        long LOG_INTERVAL_MILLIS = 10000L;
        Log.getLogWriter().info("Waiting for lead member to change from " + member + "...");
        long lastLogTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        while (true) {
            boolean leadHasChanged;
            DistributedMember currentLead = SBUtil.getLeadMember();
            boolean bl = leadHasChanged = member == null && currentLead != null || member != null && currentLead == null || member != null && currentLead != null && member.getProcessId() != currentLead.getProcessId();
            if (leadHasChanged) {
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime;
                Log.getLogWriter().info("Lead member has changed from " + member + " to " + currentLead + " after waiting " + duration + " ms");
                return new Object[]{new Long(duration), currentLead};
            }
            if (System.currentTimeMillis() - lastLogTime > 10000L) {
                Log.getLogWriter().info("Waiting for lead member to change from " + currentLead + "...");
                lastLogTime = System.currentTimeMillis();
            }
            MasterController.sleepForMs(msToSleep);
        }
    }

    protected static Object[] waitForCoordChange(DistributedMember member, int msToSleep) {
        long LOG_INTERVAL_MILLIS = 10000L;
        Log.getLogWriter().info("Waiting for coordinator to change from " + member + "...");
        long lastLogTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        while (true) {
            boolean coordHasChanged;
            DistributedMember currentCoord = SBUtil.getCoordinator();
            boolean bl = coordHasChanged = member == null && currentCoord != null || member != null && currentCoord == null || member != null && currentCoord != null && member.getProcessId() != currentCoord.getProcessId();
            if (coordHasChanged) {
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime;
                Log.getLogWriter().info("Coordinator has changed from " + member + " to " + currentCoord + " after waiting " + duration + " ms");
                return new Object[]{new Long(duration), currentCoord};
            }
            if (System.currentTimeMillis() - lastLogTime > 10000L) {
                Log.getLogWriter().info("Waiting for coordinator to change from " + currentCoord + "...");
                lastLogTime = System.currentTimeMillis();
            }
            MasterController.sleepForMs(msToSleep);
        }
    }

    public static String getMyUniqueName() {
        StringBuffer buf = new StringBuffer(50);
        buf.append("vm_").append(RemoteTestModule.getMyVmid());
        buf.append("_").append(RemoteTestModule.getMyClientName());
        buf.append("_").append(RemoteTestModule.getMyHost());
        buf.append("_").append(RemoteTestModule.getMyPid());
        return buf.toString();
    }

    public static void addMembershipHook(MembershipTestHook hook) {
        MembershipManagerHelper.addTestHook((DistributedSystem)DistributedSystemHelper.getDistributedSystem(), (MembershipTestHook)hook);
    }

    public static void removeMembershipHook(MembershipTestHook hook) {
        MembershipManagerHelper.removeTestHook((DistributedSystem)DistributedSystemHelper.getDistributedSystem(), (MembershipTestHook)hook);
    }

    public static void beSick() {
        Log.getLogWriter().info("Calling beSickMember");
        MembershipManagerHelper.beSickMember((DistributedSystem)DistributedSystemHelper.getDistributedSystem());
        Log.getLogWriter().info("Done calling beSickMember");
    }

    public static void beHealthy() {
        Log.getLogWriter().info("Calling beHealthyMember");
        MembershipManagerHelper.beHealthyMember((DistributedSystem)DistributedSystemHelper.getDistributedSystem());
        Log.getLogWriter().info("Done calling beHealthyMember");
    }

    public static void playDead() {
        Log.getLogWriter().info("Calling playDead()");
        MembershipManagerHelper.playDead((DistributedSystem)DistributedSystemHelper.getDistributedSystem());
        Log.getLogWriter().info("Done calling playDead");
    }
}

